/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.handlers;

import com.kms.katalon.console.handlers.FileReader;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.addon.ExecutionBundleActivator;
import com.kms.katalon.execution.collector.ConsoleOptionCollector;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import joptsimple.OptionSet;
import org.apache.commons.io.FileUtils;

public class ProjectHandler {
    public static void setDefaultExecutionPropertiesOfProject(ProjectEntity project, Map<String, String> consoleOptionValueMap) throws IOException, InvalidConsoleArgumentException {
        ConsoleOptionCollector.getInstance().writeDefaultPropertyFile(project);
        FileReader.readPropertiesFileAndSetToConsoleOptionValueMap(project.getFolderLocation() + File.separator + "console.properties", consoleOptionValueMap);
    }

    public static ProjectEntity findProject(OptionSet options) throws Exception {
        String projectPath = null;
        if (options.has("projectPath")) {
            projectPath = String.valueOf(options.valueOf("projectPath"));
        } else if (options.has("propertiesFile")) {
            projectPath = FileReader.readPropertyFileAndGetProperty(String.valueOf(options.valueOf("propertiesFile")), "projectPath");
        }
        if (projectPath == null) {
            throw new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_MISSING_REQUIRED_ARG, "projectPath"));
        }
        return ProjectHandler.getProject(projectPath);
    }

    private static ProjectEntity getProject(String projectPk) throws Exception {
        File projectFile = new File(projectPk);
        if (projectFile.isDirectory()) {
            LogUtil.printOutputLine((String)StringConstants.MNG_PRT_PROJECT_PATH_IS_FOLDER);
            File[] projectFiles = projectFile.listFiles();
            if (projectFiles != null) {
                File[] fileArray = projectFiles;
                int n = projectFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile()) {
                        LogUtil.printOutputLine((String)MessageFormat.format(StringConstants.MNG_PR_EXAMINE_FILE, file.getName()));
                    } else {
                        LogUtil.printOutputLine((String)MessageFormat.format(StringConstants.MNG_PR_EXAMINE_FOLDER, file.getName()));
                    }
                    if (file.isFile() && file.getName().endsWith(ProjectEntity.getProjectFileExtension())) {
                        projectPk = file.getAbsolutePath();
                        LogUtil.printOutputLine((String)MessageFormat.format(StringConstants.MNG_PRT_FOUND_PROJECT_FILE, projectPk));
                    }
                    ++n2;
                }
            }
        }
        ProjectHandler.deleteLibFolders(projectPk);
        boolean allowSourceAttachment = false;
        ProjectEntity projectEntity = ProjectController.getInstance().openProject(projectPk, allowSourceAttachment);
        ExecutionBundleActivator.getInstance().getEventBroker().post("PROJECT/OPENED", null);
        if (projectEntity == null) {
            throw new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_INVALID_ARG_CANNOT_FIND_PROJ_X, projectPk));
        }
        return projectEntity;
    }

    private static void deleteLibFolders(String projectPk) {
        try {
            File projectFolder;
            File projectFile = new File(projectPk);
            if (projectFile.isFile() && projectFile.exists() && (projectFolder = projectFile.getParentFile()).exists()) {
                ProjectHandler.deleteLibFolder(projectFolder, "bin");
                ProjectHandler.deleteLibFolder(projectFolder, "Libs");
            }
        }
        catch (Throwable t) {
            LogUtil.printAndLogError((Throwable)t, (String)ExecutionMessageConstants.RE_ERROR_DELETE_LIB_FOLDERS);
        }
    }

    private static void deleteLibFolder(File projectFolder, String libFolderName) {
        File libFolder = new File(projectFolder, libFolderName);
        if (libFolder.exists()) {
            LogUtil.printOutputLine((String)MessageFormat.format(ExecutionMessageConstants.RE_DELETE_FOLDER, libFolderName));
            try {
                FileUtils.forceDelete((File)libFolder);
            }
            catch (IOException e) {
                LogUtil.printAndLogError((Throwable)e, (String)MessageFormat.format(ExecutionMessageConstants.RE_ERROR_DELETE_FOLDERS, libFolderName));
            }
        }
    }
}

