/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.strategy;

import com.kms.katalon.console.constants.ConsoleMessageConstants;
import com.kms.katalon.console.entity.ConsoleLauncherEntity;
import com.kms.katalon.console.strategy.AbstractConsoleModeStrategy;
import com.kms.katalon.core.logging.TestSuiteXMLLogParser;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.ReportWriterUtil;
import com.kms.katalon.core.setting.ReportBundleSettingStore;
import com.kms.katalon.core.setting.ReportSettings;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.entity.ReportFolder;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.integration.ReportIntegrationFactory;
import com.kms.katalon.integration.analytics.report.AnalyticsReportService;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.testops.core.model.exception.AnalyticsApiException;
import jakarta.inject.Singleton;
import java.io.File;
import java.text.MessageFormat;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class ReportingModeStrategy
extends AbstractConsoleModeStrategy {
    @Override
    public int execute(ConsoleLauncherEntity consoleLauncherEntity) throws Exception {
        LogUtil.logInfo((String)ConsoleMessageConstants.GENERATE_REPORT_INFO_STARTING);
        int initializationResult = super.performInitializationTasks(consoleLauncherEntity);
        if (initializationResult != 200) {
            return initializationResult;
        }
        String reportPath = this.extractOptionValue(consoleLauncherEntity, "reportPath");
        ProjectEntity project = super.performProjectInitialization(consoleLauncherEntity);
        boolean generatePDF = this.getBooleanOption(consoleLauncherEntity, "report.generatePDF");
        boolean generateHTML = this.getBooleanOption(consoleLauncherEntity, "report.generateHTML");
        boolean generateCSV = this.getBooleanOption(consoleLauncherEntity, "report.generateCSV");
        LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_INFO_FORMAT_FLAGS_DETECTED, generatePDF, generateHTML, generateCSV));
        if (!this.validateInputParameters(generatePDF, generateHTML, generateCSV, reportPath, project)) {
            return 4;
        }
        File reportDir = new File(reportPath);
        File executionLogFile = new File(reportDir, "execution0.log");
        int generationResult = this.generateReports(generatePDF, generateHTML, generateCSV, reportDir, executionLogFile, project);
        if (generationResult != 200) {
            return generationResult;
        }
        this.uploadReportToTestOps(executionLogFile);
        return 200;
    }

    private boolean validateInputParameters(boolean generatePDF, boolean generateHTML, boolean generateCSV, String reportPath, ProjectEntity project) {
        if (!(generatePDF || generateHTML || generateCSV)) {
            LogUtil.printErrorLine((String)ConsoleMessageConstants.GENERATE_REPORT_ERROR_NO_FORMAT_SPECIFIED);
            this.printReportingUsage();
            return false;
        }
        if (reportPath == null || reportPath.trim().isEmpty()) {
            LogUtil.printErrorLine((String)ConsoleMessageConstants.GENERATE_REPORT_ERROR_REPORT_PATH_REQUIRED);
            this.printReportingUsage();
            return false;
        }
        if (generateHTML && project == null) {
            LogUtil.printErrorLine((String)ConsoleMessageConstants.GENERATE_REPORT_ERROR_PROJECT_INIT_REQUIRED);
            this.printReportingUsage();
            return false;
        }
        return true;
    }

    private int generateReports(boolean generatePDF, boolean generateHTML, boolean generateCSV, File reportDir, File executionLogFile, ProjectEntity project) {
        TestSuiteLogRecord testSuiteLogRecord;
        block6: {
            block5: {
                String executionLogPath = executionLogFile.getAbsolutePath();
                String formatsToGenerate = this.buildFormatsString(generateHTML, generatePDF, generateCSV);
                LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_INFO_GENERATING, formatsToGenerate));
                LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_INFO_EXECUTION_LOG_PATH, executionLogPath));
                LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_INFO_REPORT_OUTPUT_PATH, reportDir.getAbsolutePath()));
                try {
                    if (executionLogFile.exists()) break block5;
                    LogUtil.printErrorLine((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_ERROR_LOG_FILE_NOT_EXISTS, executionLogPath));
                    return 4;
                }
                catch (Exception e) {
                    LogUtil.printErrorLine((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_ERROR_GENERATING_REPORT, e.getMessage()));
                    LogUtil.logError((String)ExceptionUtils.getStackTrace((Throwable)e));
                    return 2;
                }
            }
            if (!reportDir.exists()) {
                reportDir.mkdirs();
            }
            if ((testSuiteLogRecord = this.parseExecutionLogFile(executionLogFile)) != null) break block6;
            LogUtil.printErrorLine((String)ConsoleMessageConstants.GENERATE_REPORT_ERROR_PARSE_LOG_FILE);
            return 2;
        }
        this.executeReportGeneration(generateHTML, generatePDF, generateCSV, testSuiteLogRecord, reportDir, project);
        return 200;
    }

    private void executeReportGeneration(boolean generateHTML, boolean generatePDF, boolean generateCSV, TestSuiteLogRecord testSuiteLogRecord, File reportDir, ProjectEntity project) {
        if (generateHTML) {
            this.generateHTMLReport(testSuiteLogRecord, reportDir, project);
        }
        if (generatePDF) {
            this.generatePDFReport(testSuiteLogRecord, reportDir);
        }
        if (generateCSV) {
            this.generateCSVReport(testSuiteLogRecord, reportDir);
        }
    }

    private TestSuiteLogRecord parseExecutionLogFile(File executionLogFile) {
        try {
            TestSuiteXMLLogParser parser = new TestSuiteXMLLogParser();
            TestSuiteLogRecord logRecord = parser.readTestSuiteLogFromXMLFiles(executionLogFile.getParent(), (IProgressMonitor)new NullProgressMonitor());
            return logRecord;
        }
        catch (Exception e) {
            LogUtil.printErrorLine((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_ERROR_PARSING_LOG_FILE, e.getMessage()));
            LogUtil.logError((String)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    private void generateHTMLReport(TestSuiteLogRecord testSuiteLogRecord, File reportDir, ProjectEntity project) {
        try {
            String projectLocation;
            String string = projectLocation = project != null ? project.getFolderLocation() : null;
            if (projectLocation == null) {
                LogUtil.printErrorLine((String)ConsoleMessageConstants.GENERATE_REPORT_ERROR_PROJECT_NULL_LOCATION);
            }
            ReportSettings settings = ReportBundleSettingStore.getStore((String)projectLocation).getSettings();
            File htmlFile = new File(reportDir, "report.html");
            ReportWriterUtil.writeHTMLReport((ReportWriterUtil.SuiteReportGenerationOptions)((ReportWriterUtil.SuiteReportGenerationOptionsBuilder)((ReportWriterUtil.SuiteReportGenerationOptionsBuilder)((ReportWriterUtil.SuiteReportGenerationOptionsBuilder)ReportWriterUtil.SuiteReportGenerationOptionsBuilder.create().suiteLogRecord(testSuiteLogRecord).settings(settings)).reportDir(reportDir)).outputFile(htmlFile)).build());
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_INFO_HTML_SUCCESS, htmlFile.getAbsolutePath()));
        }
        catch (Exception e) {
            LogUtil.printErrorLine((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_ERROR_GENERATING_FORMAT_REPORT, "HTML", e.getMessage()));
            LogUtil.logError((String)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void generatePDFReport(TestSuiteLogRecord testSuiteLogRecord, File reportDir) {
        try {
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_INFO_PDF_START, reportDir));
            File pdfFile = ReportWriterUtil.writePdfReport((TestSuiteLogRecord)testSuiteLogRecord, (File)reportDir);
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_INFO_PDF_SUCCESS, pdfFile.getAbsolutePath()));
        }
        catch (Exception e) {
            LogUtil.printErrorLine((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_ERROR_GENERATING_FORMAT_REPORT, "PDF", e.getMessage()));
            LogUtil.logError((String)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void generateCSVReport(TestSuiteLogRecord testSuiteLogRecord, File reportDir) {
        try {
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_INFO_CSV_START, reportDir));
            File csvFile = ReportWriterUtil.writeCSVReport((TestSuiteLogRecord)testSuiteLogRecord, (File)reportDir);
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_INFO_CSV_SUCCESS, csvFile.getAbsolutePath()));
        }
        catch (Exception e) {
            LogUtil.printErrorLine((String)MessageFormat.format(ConsoleMessageConstants.GENERATE_REPORT_ERROR_GENERATING_FORMAT_REPORT, "CSV", e.getMessage()));
            LogUtil.logError((String)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void uploadReportToTestOps(File executionLogFile) {
        block5: {
            try {
                TestSuiteLogRecord testSuiteLogRecord = this.parseExecutionLogFile(executionLogFile);
                if (testSuiteLogRecord == null) {
                    LogUtil.logError((String)"Cannot upload to TestOps: Failed to parse execution log file");
                    return;
                }
                ReportIntegrationContribution analyticsProvider = ReportIntegrationFactory.getInstance().getAnalyticsProvider();
                analyticsProvider.fetchRemoteSettings();
                if (!analyticsProvider.isIntegrationEnabled()) break block5;
                LogUtil.printOutputLine((String)ConsoleMessageConstants.GENERATE_REPORT_TESTOPS_START_SENDING);
                try {
                    ReportFolder reportFolder = new ReportFolder(testSuiteLogRecord.getLogFolder());
                    AnalyticsReportService reportService = new AnalyticsReportService();
                    reportService.upload(reportFolder);
                    LogUtil.printOutputLine((String)ConsoleMessageConstants.GENERATE_REPORT_TESTOPS_SUCCESS);
                }
                catch (Exception e) {
                    LogUtil.logError((Throwable)e, (String)ConsoleMessageConstants.GENERATE_REPORT_TESTOPS_ERROR_UPLOAD);
                    throw AnalyticsApiException.wrap((Exception)e);
                }
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e, (String)ConsoleMessageConstants.GENERATE_REPORT_TESTOPS_ERROR_GENERAL);
            }
        }
    }

    private String extractOptionValue(ConsoleLauncherEntity consoleLauncherEntity, String option) {
        return consoleLauncherEntity.getOptions().has(option) ? String.valueOf(consoleLauncherEntity.getOptions().valueOf(option)) : null;
    }

    private boolean getBooleanOption(ConsoleLauncherEntity consoleLauncherEntity, String option) {
        return consoleLauncherEntity.getOptions().has(option) && Boolean.parseBoolean(String.valueOf(consoleLauncherEntity.getOptions().valueOf(option)));
    }

    private String buildFormatsString(boolean generateHTML, boolean generatePDF, boolean generateCSV) {
        StringBuilder formats = new StringBuilder();
        if (generateHTML) {
            formats.append("HTML ");
        }
        if (generatePDF) {
            formats.append("PDF ");
        }
        if (generateCSV) {
            formats.append("CSV ");
        }
        return formats.toString().trim();
    }

    private void printReportingUsage() {
        LogUtil.printErrorLine((String)"\nReporting Mode Usage:");
        LogUtil.printErrorLine((String)"katalonc -mode=reporting -reportPath=<report_folder> -projectPath=<project_path> -apiKey=<api_key> [options]");
        LogUtil.printErrorLine((String)"\nRequired arguments:");
        LogUtil.printErrorLine((String)"  -reportPath                               Path to the report folder (containing execution0.log)");
        LogUtil.printErrorLine((String)"  -projectPath                              Path to the project folder");
        LogUtil.printErrorLine((String)"  -apiKey                                   API key for authentication");
        LogUtil.printErrorLine((String)"\nReport format options (at least one must be specified):");
        LogUtil.printErrorLine((String)"  -report.generateHTML=true   Generate HTML report");
        LogUtil.printErrorLine((String)"  -report.generatePDF=true    Generate PDF report");
        LogUtil.printErrorLine((String)"  -report.generateCSV=true    Generate CSV report");
        LogUtil.printErrorLine((String)"\nNote:");
        LogUtil.printErrorLine((String)"  - The execution log file 'execution0.log' must exist in the reportPath folder");
        LogUtil.printErrorLine((String)"  - Generated reports will be saved directly in the reportPath folder");
        LogUtil.printErrorLine((String)"  - API key is required for authentication and TestOps integration");
        LogUtil.printErrorLine((String)"  - Project path is required to load report settings");
        LogUtil.printErrorLine((String)"  - Multiple formats can be generated simultaneously");
        LogUtil.printErrorLine((String)"  - At least one format flag must be explicitly specified");
        LogUtil.printErrorLine((String)"\nExamples:");
        LogUtil.printErrorLine((String)"# Generate all formats");
        LogUtil.printErrorLine((String)"katalonc -mode=reporting -reportPath=/path/to/report/folder \\");
        LogUtil.printErrorLine((String)"  -projectPath=/path/to/project -apiKey=your-api-key \\");
        LogUtil.printErrorLine((String)"  -report.generateHTML=true -report.generatePDF=true -report.generateCSV=true");
        LogUtil.printErrorLine((String)"\n# Generate only PDF");
        LogUtil.printErrorLine((String)"katalonc -mode=reporting -reportPath=/path/to/report/folder \\");
        LogUtil.printErrorLine((String)"  -projectPath=/path/to/project -apiKey=your-api-key \\");
        LogUtil.printErrorLine((String)"  -report.generatePDF=true");
    }
}

