/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.util;

import com.kms.katalon.application.KatalonApplication;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.MachineUtil;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.console.handlers.ArgumentOptionsHandler;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.discovery.services.DiscoveryController;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.SystemInformationUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Optional;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;

public class LocalInformationUtil {
    private static final int MEGABYTE = 0x100000;
    private static final String BIT = "bit";
    private static final String OS_ARCHITECTURE_PROPERTY = "sun.arch.data.model";
    private static final String OS_NAME_PROPERTY = "os.name";
    private static final IDiscoveryController discoveryCOntroller = DiscoveryController.getInstance();
    private static final String STORE_URL_PROPERTY_KEY = "storeUrl";
    private static final String DEVELOPMENT_URL = "https://store-staging.katalon.com";
    private static final String PRODUCTION_URL = "https://store.katalon.com";

    public static String getLocalOS() {
        return System.getProperty(OS_NAME_PROPERTY) + " " + System.getProperty(OS_ARCHITECTURE_PROPERTY) + BIT;
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getKatalonVersion() {
        return ApplicationInfo.versionNo();
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public static String getErrorLog() {
        return Platform.getLogFileLocation().toString();
    }

    public static String getTotalMemoryInMegabyte() {
        try {
            long totalMem = SystemInformationUtil.totalPhysicalMemorySizeInByte();
            return String.format("%.0f MB", Float.valueOf(totalMem / 0x100000L));
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException jMException) {
            return "unknown";
        }
    }

    public static String getFreeMemoryInMegabyte() {
        try {
            long freeMem = SystemInformationUtil.freePhysicalMemorySizeInByte();
            return String.format("%.0f MB", Float.valueOf(freeMem / 0x100000L));
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException jMException) {
            return "unknown";
        }
    }

    public static String getSystemEnvironment(String key, String defaultString) {
        return System.getenv().getOrDefault(key, defaultString);
    }

    public static String getProcessCpuLoad() {
        try {
            double cpuLoad = SystemInformationUtil.getProcessCpuLoad();
            return String.format("%.0f%%", cpuLoad);
        }
        catch (InstanceNotFoundException | MalformedObjectNameException | ReflectionException jMException) {
            return "unknown";
        }
    }

    public static void printSystemInformation() {
        String javaVendor = LocalInformationUtil.getJavaVendor();
        String javaVersion = LocalInformationUtil.getJavaVersion();
        LogUtil.logInfo((String)"\n");
        LogUtil.logInfo((String)("INFO: Katalon Version: " + LocalInformationUtil.getKatalonVersion()));
        LogUtil.logInfo((String)("INFO: Command-line arguments: " + LocalInformationUtil.maskSensitiveArgs()));
        LogUtil.logInfo((String)("INFO: User working dir: " + LocalInformationUtil.getUserDir()));
        LogUtil.logInfo((String)("INFO: Error log: " + LocalInformationUtil.getErrorLog()));
        LogUtil.logInfo((String)("INFO: Katalon KatOne server URL: " + LocalInformationUtil.getAdminServerUrl()));
        LogUtil.logInfo((String)("INFO: Katalon TestOps server URL: " + LocalInformationUtil.getTestOpsServerUrl()));
        LogUtil.logInfo((String)("INFO: Katalon Store server URL: " + LocalInformationUtil.getKatalonStoreUrl()));
        LogUtil.logInfo((String)("INFO: User home: " + LocalInformationUtil.getUserHome()));
        LogUtil.logInfo((String)("INFO: Java vendor: " + javaVendor));
        LogUtil.logInfo((String)("INFO: Java version: " + javaVersion));
        LogUtil.logInfo((String)("INFO: Local OS: " + LocalInformationUtil.getLocalOS()));
        LogUtil.logInfo((String)("INFO: CPU load: " + LocalInformationUtil.getProcessCpuLoad()));
        LogUtil.logInfo((String)("INFO: Total memory: " + LocalInformationUtil.getTotalMemoryInMegabyte()));
        LogUtil.logInfo((String)("INFO: Free memory: " + LocalInformationUtil.getFreeMemoryInMegabyte()));
        LogUtil.logInfo((String)("INFO: Machine ID: " + MachineUtil.getMachineId()));
        LogUtil.logInfo((String)"\n");
    }

    public static void printLicenseServerInfo(String serverURL, String apiKey) {
        LogUtil.logInfo((String)"\n");
        LogUtil.logInfo((String)("INFO: Katalon KatOne server URL: " + serverURL));
        LogUtil.logInfo((String)("INFO: Katalon TestOps server URL: " + ApplicationInfo.getTestOpsServer()));
        int length = apiKey.length();
        if (length > 7) {
            LogUtil.logInfo((String)("INFO: API key: " + apiKey.substring(0, 3) + "*****" + apiKey.substring(length - 3, length)));
        } else {
            LogUtil.logError((String)"Make sure your API key is valid.");
        }
        LogUtil.logInfo((String)"\n");
    }

    private static String maskSensitiveArgs() {
        ArrayList<String> sensitiveArgs = new ArrayList<String>(){
            {
                this.add("apiKey");
                this.add("apikey");
                this.add("username");
                this.add("password");
                this.add("apiKeyOP");
                this.add("apiKeyOnPremise");
                this.add("proxy.password");
                this.add("proxy.auth.password");
                this.add("proxy.system.password");
            }
        };
        ArrayList<String> markedArgs = new ArrayList<String>();
        String[] stringArray = Platform.getCommandLineArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            Optional<String> findSensitiveArgResult = sensitiveArgs.stream().filter(sensitiveArgument -> arg.startsWith(MessageFormat.format("-{0}=", sensitiveArgument))).findAny();
            if (findSensitiveArgResult.isPresent()) {
                String sensitiveArgument2 = findSensitiveArgResult.get();
                markedArgs.add(MessageFormat.format("-{0}=********", sensitiveArgument2));
            } else {
                markedArgs.add(arg);
            }
            ++n2;
        }
        return StringUtils.join((Object[])markedArgs.toArray(new String[0]), (String)" ");
    }

    public static String getAdminServerUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)ArgumentOptionsHandler.getInstance().getAdminServerUrl(), (CharSequence)discoveryCOntroller.getServerUrl(ServerType.ADMIN));
    }

    public static String getTestOpsServerUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)ArgumentOptionsHandler.getInstance().getTestOpsServerUrl(), (CharSequence)discoveryCOntroller.getServerUrl(ServerType.TESTOPS));
    }

    public static String getKatalonStoreUrl() {
        String storeUrlArgument = LocalInformationUtil.getStoreUrlArgument();
        if (!StringUtils.isBlank((CharSequence)storeUrlArgument)) {
            return storeUrlArgument;
        }
        if (VersionUtil.isStagingBuild() || VersionUtil.isDevelopmentBuild()) {
            return DEVELOPMENT_URL;
        }
        return PRODUCTION_URL;
    }

    private static String getStoreUrlArgument() {
        return System.getProperty(STORE_URL_PROPERTY_KEY);
    }

    private static String printLicenseMessage() {
        if (KatalonApplication.isRunningInDevOpsEnvironment()) {
            return ExecutionMessageConstants.LocalInformationUtil_MSG_DEVOPS_LICENSE_COMPATIBILITY;
        }
        return ExecutionMessageConstants.LocalInformationUtil_MSG_NON_DEVOPS_LICENSE_COMPATIBLITY;
    }
}

