/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.addon;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.components.services.SelectionServiceSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.logging.LogConfigurator;
import com.kms.katalon.util.ExecutionTimeTracker;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.function.Function;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

public class ComponentInjectionManagerAddon {
    @Inject
    private Logger logger;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    @Inject
    private UISynchronize sync;

    @PostConstruct
    public void initHandlers() {
        LogConfigurator.setupEclipseE4LogAppender((Logger)this.logger);
        LoggerSingleton.getInstance().setupLogAdapter();
        EventBrokerSingleton.getInstance().setEventBroker(this.eventBroker);
        SelectionServiceSingleton.getInstance().setSelectionService(this.selectionService);
        ModelServiceSingleton.getInstance().setModelService(this.modelService);
        ApplicationSingleton.getInstance().setApplication(this.application);
        UISynchronizeService.getInstance().setSync(this.sync);
        boolean isTimeTrackerEnabled = Boolean.valueOf(System.getProperty("katalon.timeTrackerEnabled"));
        if (isTimeTrackerEnabled) {
            ExecutionTimeTracker.getInstance().setLogFunction((Function)new Function<String, Void>(){

                @Override
                public Void apply(String message) {
                    ComponentInjectionManagerAddon.this.logger.info(message);
                    return null;
                }
            });
        }
    }
}

