/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.dialogs;

import com.kms.katalon.composer.components.constants.StringConstants;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractEntityFinderDialog
extends Dialog {
    private static final String DEFAULT_LABEL_VALUE = StringConstants.DIA_DEFAULT_LBL_VAL;
    private static final String COLUMN_OBJECT_NAME_HEADER = StringConstants.DIA_OBJ_HEADER_NAME;
    private static final String COLUMN_OBJECT_LOCATION_HEADER = StringConstants.DIA_OBJ_HEADER_LOC;
    protected String message = StringConstants.DIA_MESSAGE;
    protected String title;
    private Table table;
    private TableViewer tableViewer;
    private String searchText = "";
    private Object selectedObject;
    private AbstractEntityFinderDialog _instance = this;
    private List<Object> input;
    private ColumnLabelProvider[] columnLabelProviders = new ColumnLabelProvider[2];
    private ViewerFilter filter;

    protected AbstractEntityFinderDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.createMessageArea(container);
        this.createFilterText(container);
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setText(DEFAULT_LABEL_VALUE);
        this.tableViewer = new TableViewer(container, 67584);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnName = tableViewerColumnName.getColumn();
        tblclmnName.setWidth(100);
        tblclmnName.setText(COLUMN_OBJECT_NAME_HEADER);
        tblclmnName.setWidth(250);
        tableViewerColumnName.setLabelProvider((CellLabelProvider)this.columnLabelProviders[0]);
        TableViewerColumn tableViewerColumnPK = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnPK = tableViewerColumnPK.getColumn();
        tblclmnPK.setWidth(100);
        tblclmnPK.setText(COLUMN_OBJECT_LOCATION_HEADER);
        tblclmnPK.setWidth(317);
        tableViewerColumnPK.setLabelProvider((CellLabelProvider)this.columnLabelProviders[1]);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractEntityFinderDialog.this.selectedObject = ((StructuredSelection)event.getSelection()).getFirstElement();
                AbstractEntityFinderDialog.this._instance.close();
            }
        });
        try {
            new ArrayContentProvider();
            this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.tableViewer.setInput(this.input);
            if (this.input.size() > 0) {
                this.setSelectionIndex(0);
            }
            this.tableViewer.addFilter(this.filter);
            this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AbstractEntityFinderDialog.this.selectedObject = ((StructuredSelection)event.getSelection()).getFirstElement();
                }
            });
            this.setInitObject();
        }
        catch (Exception e) {
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
        }
        return container;
    }

    protected abstract void setInitObject() throws Exception;

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        if (this.message != null) {
            label.setText(this.message);
        }
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text createFilterText(Composite parent) {
        Text text = new Text(parent, 2048);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        text.setLayoutData((Object)data);
        text.setFont(parent.getFont());
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text source = (Text)e.getSource();
                AbstractEntityFinderDialog.this.searchText = source.getText();
                AbstractEntityFinderDialog.this.tableViewer.refresh();
                if (AbstractEntityFinderDialog.this.table.getItems().length > 0) {
                    AbstractEntityFinderDialog.this.setSelectionIndex(0);
                }
            }
        });
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    AbstractEntityFinderDialog.this.table.setFocus();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        return text;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title != null) {
            newShell.setText(this.title);
        }
    }

    protected Point getInitialSize() {
        return new Point(600, 500);
    }

    public Object getSelectedValue() {
        return this.selectedObject;
    }

    protected void setSelectionIndex(int index) {
        this.table.setSelection(index);
        this.selectedObject = this.table.getItem(index).getData();
    }

    protected void setColumnLabelProviders(ColumnLabelProvider[] columnLabelProviders) {
        this.columnLabelProviders = columnLabelProviders;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    protected void setInput(List<Object> input) {
        this.input = input;
    }

    protected List<Object> getInput() {
        return this.input;
    }

    protected void setViewerFilter(ViewerFilter filter) {
        this.filter = filter;
    }

    protected String getSearchText() {
        return this.searchText;
    }
}

