/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileUtil {
    private static final String ANY_EXTENSION = "*";

    public static IFile getFileFromFileLocation(String fileLocation) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileLocation));
    }

    public static File[] getFiles(File folder, String suffix, Date origin) {
        final ArrayList filePaths = new ArrayList();
        FileUtil.enumFiles(folder, suffix, origin, new FileProcessor(){

            @Override
            public void process(File f) {
                filePaths.add(f);
            }
        });
        return filePaths.toArray(new File[0]);
    }

    private static void enumFiles(File folder, String suffix, Date origin, FileProcessor fileProcessor) {
        if (!folder.isDirectory()) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(Arrays.asList(folder.listFiles()));
        int i = 0;
        while (i < files.size()) {
            File file = (File)files.get(i);
            if (file.isDirectory()) {
                files.addAll(Arrays.asList(file.listFiles()));
            } else if (FileUtil.isFileSatisfy(file, suffix, origin)) {
                fileProcessor.process(file);
            }
            ++i;
        }
    }

    private static boolean isFileSatisfy(File file, String suffix, Date origin) {
        boolean satisfyName;
        String fileName = file.getName();
        boolean bl = satisfyName = suffix.equals(ANY_EXTENSION) ? true : fileName.endsWith(suffix);
        if (!satisfyName) {
            return false;
        }
        return FileUtil.isFileCreateAfter(file, origin);
    }

    public static boolean isFileCreateAfter(File file, Date time) {
        try {
            return time.getTime() < Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
        }
        catch (IOException e) {
            LoggerSingleton.logError(e);
            return false;
        }
    }

    public static int countAllFiles(File folder, String suffix, Date origin) {
        final int[] count = new int[1];
        FileUtil.enumFiles(folder, suffix, origin, new FileProcessor(){

            @Override
            public void process(File f) {
                count[0] = count[0] + 1;
            }
        });
        return count[0];
    }

    private static interface FileProcessor {
        public void process(File var1);
    }
}

