/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class FontUtil {
    private static final String FONTS_FOLDER = "/resources/fonts/";
    private static final List<String> FONTS = Arrays.asList("TT Norms/TTNorms-Black.otf", "TT Norms/TTNorms-BlackItalic.otf", "TT Norms/TTNorms-Bold.otf", "TT Norms/TTNorms-BoldItalic.otf", "TT Norms/TTNorms-Italic.otf", "TT Norms/TTNorms-Light.ttf", "TT Norms/TTNorms-Medium.ttf", "TT Norms/TTNorms-Regular.otf");
    public static final int SIZE_H1 = 24;
    public static final int SIZE_H2 = 18;
    public static final int SIZE_H3 = 14;
    public static final int SIZE_H4 = 12;
    public static final int SIZE_H5 = 10;
    public static final int SIZE_H6 = 8;
    public static final int SIZE_NORMAL = 9;
    public static final int STYLE_NORMAL = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_BOLD_ITALIC = 3;
    public static final int SIZE_DEFAULT = 9;
    public static final int STYLE_DEFAULT = 0;
    public static final String FONT_FAMILY_DEFAULT;
    public static final String FONT_FAMILY_TTNORMS = "TTNorms-Regular";
    public static final String FONT_FAMILY_TTNORMS_LIGHT = "TTNorms-Light";
    public static final String FONT_FAMILY_TTNORMS_BOLD = "TTNorms-Bold";
    public static final String FONT_FAMILY_TTNORMS_MEDIUM = "TTNorms-Medium";
    public static final Font REGULAR;
    public static final Font BOLD;
    public static final Font ITALIC;
    public static final Font H1;
    public static final Font H1_BOLD;
    public static final Font H1_ITALIC;
    public static final Font H1_BOLD_ITALIC;
    public static final Font H2;
    public static final Font H2_BOLD;
    public static final Font H2_ITALIC;
    public static final Font H2_BOLD_ITALIC;
    public static final Font H3;
    public static final Font H3_BOLD;
    public static final Font H3_ITALIC;
    public static final Font H3_BOLD_ITALIC;
    public static final Font H4;
    public static final Font H4_BOLD;
    public static final Font H4_ITALIC;
    public static final Font H4_BOLD_ITALIC;
    public static final Font H5;
    public static final Font H5_BOLD;
    public static final Font H5_ITALIC;
    public static final Font H5_BOLD_ITALIC;
    public static final Font H6;
    public static final Font H6_BOLD;
    public static final Font H6_ITALIC;
    public static final Font H6_BOLD_ITALIC;
    public static final Font FONT_TTNORMS;
    public static final Font FONT_TTNORMS_LIGHT;
    public static final Font FONT_TTNORMS_BOLD;
    public static final Font FONT_TTNORMS_MEDIUM;

    static {
        Label label = new Label((Composite)new Shell(), 0);
        FONT_FAMILY_DEFAULT = label.getFont().getFontData()[0].getName();
        REGULAR = FontUtil.build(9, 0, FONT_FAMILY_DEFAULT);
        BOLD = FontUtil.build(9, 1, FONT_FAMILY_DEFAULT);
        ITALIC = FontUtil.build(9, 2, FONT_FAMILY_DEFAULT);
        H1 = FontUtil.build(24, 0, FONT_FAMILY_DEFAULT);
        H1_BOLD = FontUtil.build(24, 1, FONT_FAMILY_DEFAULT);
        H1_ITALIC = FontUtil.build(24, 2, FONT_FAMILY_DEFAULT);
        H1_BOLD_ITALIC = FontUtil.build(24, 3, FONT_FAMILY_DEFAULT);
        H2 = FontUtil.build(18, 0, FONT_FAMILY_DEFAULT);
        H2_BOLD = FontUtil.build(18, 1, FONT_FAMILY_DEFAULT);
        H2_ITALIC = FontUtil.build(18, 2, FONT_FAMILY_DEFAULT);
        H2_BOLD_ITALIC = FontUtil.build(18, 3, FONT_FAMILY_DEFAULT);
        H3 = FontUtil.build(14, 0, FONT_FAMILY_DEFAULT);
        H3_BOLD = FontUtil.build(14, 1, FONT_FAMILY_DEFAULT);
        H3_ITALIC = FontUtil.build(14, 2, FONT_FAMILY_DEFAULT);
        H3_BOLD_ITALIC = FontUtil.build(14, 3, FONT_FAMILY_DEFAULT);
        H4 = FontUtil.build(12, 0, FONT_FAMILY_DEFAULT);
        H4_BOLD = FontUtil.build(12, 1, FONT_FAMILY_DEFAULT);
        H4_ITALIC = FontUtil.build(12, 2, FONT_FAMILY_DEFAULT);
        H4_BOLD_ITALIC = FontUtil.build(12, 3, FONT_FAMILY_DEFAULT);
        H5 = FontUtil.build(10, 0, FONT_FAMILY_DEFAULT);
        H5_BOLD = FontUtil.build(10, 1, FONT_FAMILY_DEFAULT);
        H5_ITALIC = FontUtil.build(10, 2, FONT_FAMILY_DEFAULT);
        H5_BOLD_ITALIC = FontUtil.build(10, 3, FONT_FAMILY_DEFAULT);
        H6 = FontUtil.build(8, 0, FONT_FAMILY_DEFAULT);
        H6_BOLD = FontUtil.build(8, 1, FONT_FAMILY_DEFAULT);
        H6_ITALIC = FontUtil.build(8, 2, FONT_FAMILY_DEFAULT);
        H6_BOLD_ITALIC = FontUtil.build(8, 3, FONT_FAMILY_DEFAULT);
        FONT_TTNORMS = FontUtil.build(9, 0, FONT_FAMILY_TTNORMS);
        FONT_TTNORMS_LIGHT = FontUtil.build(9, 0, FONT_FAMILY_TTNORMS_LIGHT);
        FONT_TTNORMS_BOLD = FontUtil.build(9, 1, FONT_FAMILY_TTNORMS_BOLD);
        FONT_TTNORMS_MEDIUM = FontUtil.build(9, 0, FONT_FAMILY_TTNORMS_MEDIUM);
    }

    public static Font build(int fontSize) {
        return FontUtil.build(fontSize, null);
    }

    public static Font build(int fontSize, String fontFamily) {
        fontFamily = StringUtils.defaultString((String)fontFamily, (String)FONT_FAMILY_DEFAULT);
        return FontUtil.build(fontSize, 0, fontFamily);
    }

    public static Font build(int fontSize, int fontStyle) {
        return FontUtil.build(fontSize, fontStyle, FONT_FAMILY_DEFAULT);
    }

    public static Font build(int fontSize, int fontStyle, String fontFamily) {
        fontFamily = StringUtils.defaultString((String)fontFamily, (String)FONT_FAMILY_DEFAULT);
        FontData fontData = new FontData(fontFamily, fontSize, fontStyle);
        return new Font((Device)Display.getCurrent(), fontData);
    }

    public static Font size(Font font, int fontSize) {
        FontData oldFontData = font.getFontData()[0];
        FontData newFontData = new FontData(oldFontData.getName(), fontSize, oldFontData.getStyle());
        return new Font((Device)Display.getCurrent(), newFontData);
    }

    public static Font style(Font font, int fontStyle) {
        FontData oldFontData = font.getFontData()[0];
        FontData newFontData = new FontData(oldFontData.getName(), oldFontData.getHeight(), fontStyle);
        return new Font((Device)Display.getCurrent(), newFontData);
    }

    public static Font family(Font font, String fontFamily) {
        FontData oldFontData = font.getFontData()[0];
        FontData newFontData = new FontData(fontFamily, oldFontData.getHeight(), oldFontData.getStyle());
        return new Font((Device)Display.getCurrent(), newFontData);
    }

    public static void loadFonts() throws IOException {
        for (String fontName : FONTS) {
            String fontPath = "/resources/fonts//" + fontName;
            InputStream fontStream = FontUtil.class.getResourceAsStream(fontPath);
            File tempFontFile = File.createTempFile("font", "");
            FileUtils.copyInputStreamToFile((InputStream)fontStream, (File)tempFontFile);
            Display.getCurrent().loadFont(tempFontFile.getAbsolutePath());
        }
    }
}

