/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.viewer;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class FocusCellOwnerDrawHighlighterForMultiSelection
extends FocusCellHighlighter {
    private ViewerCell focusedCell;

    public FocusCellOwnerDrawHighlighterForMultiSelection(ColumnViewer viewer) {
        super(viewer);
        this.hookListener(viewer);
    }

    private void markFocusedCell(Event event, ViewerCell cell) {
        Color foreground;
        Color background = cell.getControl().isFocusControl() ? this.getSelectedCellBackgroundColor(cell) : this.getSelectedCellBackgroundColorNoFocus(cell);
        Color color = foreground = cell.getControl().isFocusControl() ? this.getSelectedCellForegroundColor(cell) : this.getSelectedCellForegroundColorNoFocus(cell);
        if (foreground != null || background != null || this.onlyTextHighlighting(cell)) {
            GC gc = event.gc;
            if (background == null) {
                background = cell.getItem().getDisplay().getSystemColor(26);
            }
            if (foreground == null) {
                foreground = cell.getItem().getDisplay().getSystemColor(27);
            }
            gc.setBackground(background);
            gc.setForeground(foreground);
            if (this.onlyTextHighlighting(cell)) {
                Rectangle area = event.getBounds();
                Rectangle rect = cell.getTextBounds();
                if (rect != null) {
                    area.x = rect.x;
                }
                gc.fillRectangle(area);
            } else {
                gc.fillRectangle(event.getBounds());
            }
            if (Platform.getOS().equals("macosx")) {
                cell.setBackground(background);
            }
            event.detail &= 0xFFFFFFFD;
        }
    }

    private void hookListener(final ColumnViewer viewer) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 2) > 0) {
                    ViewerCell focusCell = FocusCellOwnerDrawHighlighterForMultiSelection.this.getFocusCell();
                    try {
                        Method m = ColumnViewer.class.getDeclaredMethod("getViewerRowFromItem", Widget.class);
                        boolean access = m.isAccessible();
                        if (!access) {
                            m.setAccessible(true);
                        }
                        ViewerRow row = (ViewerRow)m.invoke((Object)viewer, event.item);
                        m.setAccessible(access);
                        Assert.isNotNull((Object)row, (String)"Internal structure invalid. Item without associated row is not possible.");
                        ViewerCell cell = row.getCell(event.index);
                        if (focusCell != null && cell.equals((Object)focusCell)) {
                            FocusCellOwnerDrawHighlighterForMultiSelection.this.markFocusedCell(event, cell);
                        }
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError(e);
                    }
                }
            }
        };
        viewer.getControl().addListener(40, listener);
    }

    protected Color getSelectedCellBackgroundColor(ViewerCell cell) {
        return cell.getItem().getDisplay().getSystemColor(26);
    }

    protected Color getSelectedCellForegroundColor(ViewerCell cell) {
        return null;
    }

    protected Color getSelectedCellForegroundColorNoFocus(ViewerCell cell) {
        return null;
    }

    protected Color getSelectedCellBackgroundColorNoFocus(ViewerCell cell) {
        return null;
    }

    protected boolean onlyTextHighlighting(ViewerCell cell) {
        return false;
    }

    protected void focusCellChanged(ViewerCell newCell, ViewerCell oldCell) {
        int width;
        int x;
        Rectangle rect;
        if (oldCell != null && Platform.getOS().equals("macosx")) {
            oldCell.setBackground(this.getBackgroundLostFocusCell(oldCell));
        }
        super.focusCellChanged(newCell, oldCell);
        if (newCell != null) {
            rect = newCell.getBounds();
            x = newCell.getColumnIndex() == 0 ? 0 : rect.x;
            width = newCell.getColumnIndex() == 0 ? rect.x + rect.width : rect.width;
            newCell.getControl().redraw(x, rect.y - 1, width, rect.height + 1, true);
        }
        if (oldCell != null) {
            rect = oldCell.getBounds();
            x = oldCell.getColumnIndex() == 0 ? 0 : rect.x;
            width = oldCell.getColumnIndex() == 0 ? rect.x + rect.width : rect.width;
            oldCell.getControl().redraw(x, rect.y - 1, width, rect.height + 1, true);
        }
        this.focusedCell = newCell;
    }

    public ViewerCell getMarkedCell() {
        return this.focusedCell;
    }

    protected Color getBackgroundLostFocusCell(ViewerCell cell) {
        return null;
    }
}

