/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.parts;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.providers.HyperLinkColumnLabelProvider;
import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.analytics.constants.AnalyticsStringConstants;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.integration.analytics.utils.ColorUtil;
import com.kms.katalon.composer.integration.analytics.utils.TestOpsUtil;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.TestOpsTimeFormatter;
import com.kms.katalon.testops.core.model.AnalyticsAgent;
import com.kms.katalon.testops.core.model.AnalyticsJob;
import com.kms.katalon.testops.core.model.AnalyticsPlan;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsRunScheduler;
import com.kms.katalon.testops.core.model.exception.AnalyticsApiException;
import com.kms.katalon.testops.core.services.ITestOpsController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class PlanViewerPart {
    private Composite parent;
    private MPart part;
    private CTableViewer viewer;
    private Composite planPart;
    private Composite loadingPart;
    private StackLayout viewerLayout;
    private Composite errorPart;
    private Composite viewerPart;
    private Composite emptyPart;
    private Date timeNow;
    private TestOpsTimeFormatter timeFormatter;
    @Inject
    private ITestOpsController testOpsController;

    @PostConstruct
    public void createPartControl(Composite parent, MCompositePart mpart) {
        this.parent = parent;
        this.part = mpart;
        this.timeFormatter = new TestOpsTimeFormatter();
        GridLayout gridLayout = new GridLayout(1, false);
        parent.setLayout((Layout)gridLayout);
        this.createHeaderPart();
        this.viewerPart = new Composite(parent, 0);
        this.viewerLayout = new StackLayout();
        this.viewerPart.setLayout((Layout)this.viewerLayout);
        this.viewerPart.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createPlanPart();
        this.createErrorpart();
        this.createLoadingPart();
        this.createEmptyPart();
        this.refresh();
    }

    private void refresh() {
        this.viewerLayout.topControl = this.loadingPart;
        this.viewerPart.layout();
        Thread getExecutionsThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    List<AnalyticsPlan> plans = PlanViewerPart.this.getPlan();
                    UISynchronizeService.asyncExec(() -> PlanViewerPart.this.updateDataViewer(plans));
                }
                catch (AnalyticsApiException e) {
                    LoggerSingleton.logError((Throwable)e);
                    UISynchronizeService.asyncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).PlanViewerPart.this.viewerLayout.topControl = (this).PlanViewerPart.this.errorPart;
                            (this).PlanViewerPart.this.viewerPart.layout();
                        }
                    });
                }
            }
        });
        getExecutionsThread.start();
    }

    private void updateDataViewer(List<AnalyticsPlan> plans) {
        if (plans == null) {
            return;
        }
        if (plans.isEmpty()) {
            this.viewerLayout.topControl = this.emptyPart;
            this.viewerPart.layout();
            return;
        }
        this.timeNow = new Date();
        if (this.viewer == null) {
            this.createPlanPart();
        } else {
            this.viewer.getTable().removeAll();
            this.viewer.setInput(plans);
            this.viewer.refresh();
        }
        this.viewerLayout.topControl = this.planPart;
        this.viewerPart.layout();
    }

    private List<AnalyticsPlan> getPlan() throws AnalyticsApiException {
        AnalyticsSettingStore settingStore = AnalyticsSettingStore.getStore((String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        AnalyticsProject project = settingStore.getProject();
        return this.testOpsController.getPlans(project.getId());
    }

    private void createEmptyPart() {
        this.emptyPart = new Composite(this.viewerPart, 0);
        RowLayout rowLayout = new RowLayout();
        this.emptyPart.setLayout((Layout)rowLayout);
        Link link = new Link(this.emptyPart, 0);
        this.setFontStyle(link, 14, 0);
        link.setLayoutData((Object)new RowData());
        link.setText(ComposerIntegrationAnalyticsMessageConstants.LNK_PLAN_EMPTY);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)ComposerIntegrationAnalyticsMessageConstants.LNK_CREATE_PLAN_GUIDE);
            }
        });
    }

    private void createErrorpart() {
        this.errorPart = new Composite(this.viewerPart, 0);
        RowLayout rowLayout = new RowLayout();
        this.errorPart.setLayout((Layout)rowLayout);
        Label lblError = new Label(this.errorPart, 0);
        lblError.setLayoutData((Object)new RowData());
        this.setFontStyle(lblError, 16, 0);
        lblError.setText(ComposerIntegrationAnalyticsMessageConstants.MSG_ANALYTICS_CONNECTION_ERROR);
        lblError.setForeground(ColorUtil.LIGHT_RED);
    }

    private void createLoadingPart() {
        this.loadingPart = new Composite(this.viewerPart, 0);
        RowLayout rowLayout = new RowLayout();
        this.loadingPart.setLayout((Layout)rowLayout);
        Label lblLoading = new Label(this.loadingPart, 0);
        lblLoading.setLayoutData((Object)new RowData());
        this.setFontStyle(lblLoading, 16, 0);
        lblLoading.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_LOADING);
        lblLoading.setForeground(ColorUtil.LIGHT_GREEN);
    }

    private void createPlanPart() {
        this.planPart = new Composite(this.viewerPart, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        this.planPart.setLayout((Layout)gridLayout);
        this.viewer = new CTableViewer(this.planPart, 67584);
        TableLayout tableLayout = new TableLayout();
        this.viewer.getTable().setLayout((Layout)tableLayout);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        TableViewerColumn colStatus = new TableViewerColumn((TableViewer)this.viewer, 0);
        colStatus.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.PLAN_STATUS);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        colStatus.setLabelProvider((CellLabelProvider)new TypeCheckedStyleCellLabelProvider<AnalyticsPlan>(0){

            protected Image getImage(AnalyticsPlan element) {
                if (element.getLatestJob() == null) {
                    return null;
                }
                switch (element.getLatestJob().getStatus()) {
                    case SUCCESS: {
                        return ImageConstants.IMG_16_TESTOPS_EXECUTION_PASSED;
                    }
                    case FAILED: {
                        return ImageConstants.IMG_16_TESTOPS_EXECUTION_FAILED;
                    }
                    case QUEUED: {
                        return ImageConstants.IMG_16_TESTOPS_PLAN_QUEUED;
                    }
                    case ERROR: {
                        return ImageConstants.IMG_16_TESTOPS_PLAN_ERROR;
                    }
                    case CANCELED: {
                        return ImageConstants.IMG_16_TESTOPS_PLAN_CANCELED;
                    }
                    case RUNNING: {
                        return ImageConstants.IMG_16_TESTOPS_PLAN_RUNNING;
                    }
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (!(element instanceof AnalyticsPlan)) {
                    return null;
                }
                AnalyticsPlan plan = (AnalyticsPlan)element;
                if (plan.getLatestJob() == null) {
                    return null;
                }
                switch (plan.getLatestJob().getStatus()) {
                    case SUCCESS: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_EXECUTION_STATUS_PASSED;
                    }
                    case FAILED: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_EXECUTION_STATUS_FAILED;
                    }
                    case QUEUED: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_PLAN_STATUS_QUEUED;
                    }
                    case CANCELED: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_PLAN_STATUS_CANCELED;
                    }
                    case ERROR: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_PLAN_STATUS_ERROR;
                    }
                    case WAIT_FOR_TRIGGER: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_PLAN_STATUS_WAITTING;
                    }
                    case RUNNING: {
                        return ComposerIntegrationAnalyticsMessageConstants.LBL_PLAN_STATUS_RUNNING;
                    }
                }
                return null;
            }

            protected String getText(AnalyticsPlan element) {
                return null;
            }

            protected Class<AnalyticsPlan> getElementType() {
                return null;
            }

            public boolean useNativeToolTip(Object object) {
                return false;
            }
        });
        TableViewerColumn colName = new TableViewerColumn((TableViewer)this.viewer, 0);
        colName.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.PLAN_NAME);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(325));
        colName.setLabelProvider((CellLabelProvider)new HyperLinkColumnLabelProvider<AnalyticsPlan>(1){

            protected void handleMouseDown(MouseEvent e, ViewerCell cell) {
                if (!(cell.getElement() instanceof AnalyticsPlan)) {
                    return;
                }
                AnalyticsPlan plan = (AnalyticsPlan)cell.getElement();
                Program.launch((String)TestOpsUtil.getPlanUrl(plan));
            }

            protected Class<AnalyticsPlan> getElementType() {
                return null;
            }

            protected Image getImage(AnalyticsPlan element) {
                return null;
            }

            protected String getText(AnalyticsPlan element) {
                return element.getName();
            }

            public boolean useNativeToolTip(Object object) {
                return false;
            }

            public String getToolTipText(Object element) {
                if (!(element instanceof AnalyticsPlan)) {
                    return null;
                }
                AnalyticsPlan plan = (AnalyticsPlan)element;
                if (StringUtils.isBlank((CharSequence)plan.getName())) {
                    return null;
                }
                return plan.getName();
            }
        });
        TableViewerColumn colTestProject = new TableViewerColumn((TableViewer)this.viewer, 0);
        colTestProject.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.PLAN_TEST_PROJECT);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(325));
        colTestProject.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof AnalyticsPlan)) {
                    return null;
                }
                return ((AnalyticsPlan)element).getTestProject().getName();
            }

            public String getToolTipText(Object element) {
                if (!(element instanceof AnalyticsPlan)) {
                    return null;
                }
                AnalyticsPlan plan = (AnalyticsPlan)element;
                if (StringUtils.isBlank((CharSequence)plan.getTestProject().getName())) {
                    return null;
                }
                return plan.getTestProject().getName();
            }
        });
        TableViewerColumn colAgent = new TableViewerColumn((TableViewer)this.viewer, 0);
        colAgent.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.PLAN_AGENTS);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(150));
        colAgent.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof AnalyticsPlan)) {
                    return null;
                }
                return PlanViewerPart.this.getAgentNames((AnalyticsPlan)element);
            }

            public String getToolTipText(Object element) {
                if (!(element instanceof AnalyticsPlan)) {
                    return null;
                }
                String agentName = PlanViewerPart.this.getAgentNames((AnalyticsPlan)element);
                if (StringUtils.isBlank((CharSequence)agentName)) {
                    return null;
                }
                return agentName;
            }
        });
        TableViewerColumn colLastExec = new TableViewerColumn((TableViewer)this.viewer, 0);
        colLastExec.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.PLAN_LAST_EXECUTION);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(130));
        colLastExec.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Date lastExec = PlanViewerPart.this.getLastExecution(((AnalyticsPlan)element).getLatestJob());
                if (lastExec == null) {
                    return null;
                }
                return PlanViewerPart.this.timeFormatter.formatEvent(lastExec, PlanViewerPart.this.timeNow);
            }

            public String getToolTipText(Object element) {
                Date lastExec = PlanViewerPart.this.getLastExecution(((AnalyticsPlan)element).getLatestJob());
                if (lastExec == null) {
                    return null;
                }
                return PlanViewerPart.this.timeFormatter.formatDetail(lastExec);
            }
        });
        TableViewerColumn colNextRun = new TableViewerColumn((TableViewer)this.viewer, 0);
        colNextRun.getColumn().setText(ComposerIntegrationAnalyticsMessageConstants.PLAN_NEXT_RUN);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(130));
        colNextRun.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Date nextRun = PlanViewerPart.this.getNextRun(((AnalyticsPlan)element).getNextRunScheduler());
                if (nextRun == null) {
                    return null;
                }
                return PlanViewerPart.this.timeFormatter.formatEvent(nextRun, PlanViewerPart.this.timeNow);
            }

            public String getToolTipText(Object element) {
                Date nextRun = PlanViewerPart.this.getNextRun(((AnalyticsPlan)element).getNextRunScheduler());
                if (nextRun == null) {
                    return null;
                }
                return PlanViewerPart.this.timeFormatter.formatDetail(nextRun);
            }
        });
    }

    private void createHeaderPart() {
        Composite headerComposite = new Composite(this.parent, 0);
        GridLayout headerLayout = new GridLayout(2, true);
        headerComposite.setLayout((Layout)headerLayout);
        headerComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblExecution = new Label(headerComposite, 0);
        lblExecution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        lblExecution.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_PLANS);
        this.setFontStyle(lblExecution, 14, 1);
        Composite viewAllComposite = new Composite(headerComposite, 0);
        GridLayout viewAllLayout = new GridLayout(5, false);
        viewAllLayout.marginWidth = 0;
        viewAllLayout.marginHeight = 0;
        viewAllLayout.verticalSpacing = 0;
        viewAllLayout.horizontalSpacing = 0;
        viewAllComposite.setLayout((Layout)viewAllLayout);
        viewAllComposite.setLayoutData((Object)new GridData(3, 0x1000000, true, false));
        ToolBar tbRefresh = new ToolBar(viewAllComposite, 0x800000);
        tbRefresh.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        ToolItem btnRefresh = new ToolItem(tbRefresh, 8);
        btnRefresh.setToolTipText(AnalyticsStringConstants.REFRESH);
        btnRefresh.setImage(ImageConstants.IMG_16_TESTOPS_REFRESH_NEW);
        btnRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PlanViewerPart.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label imgTestOps = new Label(viewAllComposite, 0);
        imgTestOps.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        imgTestOps.setImage(ImageConstants.IMG_16_KATALON_TESTOPS);
        Link lnkViewAll = new Link(viewAllComposite, 0);
        lnkViewAll.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setFontStyle(lnkViewAll, 11, 0);
        String testOpsUrl = TestOpsUtil.getPlansPageURL();
        lnkViewAll.setText(" <a href=\"" + testOpsUrl + "\">" + ComposerIntegrationAnalyticsMessageConstants.LNK_VIEW_ALL_PLANS + "</a>");
        lnkViewAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)TestOpsUtil.getPlansPageURL());
            }
        });
    }

    private void setFontStyle(Label label, int fontSize, int style) {
        FontData[] fontData = label.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(fontSize);
            fontData[i].setStyle(style);
            ++i;
        }
        final Font newFont = new Font((Device)label.getDisplay(), fontData);
        label.setFont(newFont);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }

    private void setFontStyle(Link link, int fontSize, int style) {
        FontData[] fontData = link.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(fontSize);
            fontData[i].setStyle(style);
            ++i;
        }
        final Font newFont = new Font((Device)link.getDisplay(), fontData);
        link.setFont(newFont);
        link.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }

    private String getAgentNames(AnalyticsPlan plan) {
        AnalyticsAgent agent;
        int n;
        int n2;
        AnalyticsAgent[] analyticsAgentArray;
        String delimiter = ", ";
        StringBuffer names = new StringBuffer();
        if (ArrayUtils.isNotEmpty((Object[])plan.getAgents())) {
            analyticsAgentArray = plan.getAgents();
            n2 = analyticsAgentArray.length;
            n = 0;
            while (n < n2) {
                agent = analyticsAgentArray[n];
                names.append(agent.getName());
                names.append(delimiter);
                ++n;
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])plan.getK8sAgents())) {
            analyticsAgentArray = plan.getK8sAgents();
            n2 = analyticsAgentArray.length;
            n = 0;
            while (n < n2) {
                agent = analyticsAgentArray[n];
                names.append(agent.getName());
                names.append(delimiter);
                ++n;
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])plan.getCircleCIAgents())) {
            analyticsAgentArray = plan.getCircleCIAgents();
            n2 = analyticsAgentArray.length;
            n = 0;
            while (n < n2) {
                agent = analyticsAgentArray[n];
                names.append(agent.getName());
                names.append(delimiter);
                ++n;
            }
        }
        if (names.length() <= 0) {
            return "";
        }
        names.delete(names.length() - delimiter.length(), names.length() - 1);
        return names.toString();
    }

    private Date getNextRun(AnalyticsRunScheduler scheduler) {
        if (scheduler == null) {
            return null;
        }
        return scheduler.getNextTime();
    }

    private Date getLastExecution(AnalyticsJob job) {
        if (job == null || job.getExecution() == null) {
            return null;
        }
        return job.getExecution().getStartTime();
    }
}

