/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.collection.dialog;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.ImageConstants;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ExecutionProfileSelectionDialog
extends AbstractDialog {
    private CTableViewer tbvExecutionProfile;
    private List<ExecutionProfileEntity> profiles;
    private ExecutionProfileEntity selectedProfile;

    public ExecutionProfileSelectionDialog(Shell parentShell, List<ExecutionProfileEntity> profiles, ExecutionProfileEntity selectedProfile) {
        super(parentShell);
        this.profiles = profiles;
        this.selectedProfile = selectedProfile;
    }

    protected void registerControlModifyListeners() {
        this.tbvExecutionProfile.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExecutionProfileSelectionDialog.this.selectedProfile = (ExecutionProfileEntity)ExecutionProfileSelectionDialog.this.tbvExecutionProfile.getStructuredSelection().getFirstElement();
                ExecutionProfileSelectionDialog.this.validateSelectedProfile();
            }
        });
        this.tbvExecutionProfile.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ExecutionProfileSelectionDialog.this.getButton(0).isEnabled()) {
                    ExecutionProfileSelectionDialog.this.okPressed();
                }
            }
        });
    }

    private void validateSelectedProfile() {
        this.getButton(0).setEnabled(this.selectedProfile != null);
    }

    protected void setInput() {
        this.tbvExecutionProfile.setInput(this.profiles);
        if (this.selectedProfile == null) {
            this.selectedProfile = this.profiles.get(0);
        }
        this.tbvExecutionProfile.setSelection((ISelection)new StructuredSelection((Object)this.selectedProfile));
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        container.setLayout((Layout)tableLayout);
        this.tbvExecutionProfile = new CTableViewer(container, 2048);
        this.tbvExecutionProfile.getTable().setLayoutData((Object)new GridData(1808));
        TableViewerColumn tbvclmProfile = new TableViewerColumn((TableViewer)this.tbvExecutionProfile, 0);
        tbvclmProfile.setLabelProvider((CellLabelProvider)new ExecutionProfileLabelProvider());
        tableLayout.setColumnData((Widget)tbvclmProfile.getColumn(), (ColumnLayoutData)new ColumnWeightData(98, 380));
        this.tbvExecutionProfile.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        return container;
    }

    public void create() {
        super.create();
        this.validateSelectedProfile();
    }

    public ExecutionProfileEntity getSelectedProfile() {
        return this.selectedProfile;
    }

    public String getDialogTitle() {
        return ComposerExecutionMessageConstants.DIA_TITLE_EXECUTION_PROILE;
    }

    protected Point getInitialSize() {
        return new Point(400, 370);
    }

    private class ExecutionProfileLabelProvider
    extends TypeCheckedStyleCellLabelProvider<ExecutionProfileEntity> {
        public ExecutionProfileLabelProvider() {
            super(0);
        }

        protected Class<ExecutionProfileEntity> getElementType() {
            return ExecutionProfileEntity.class;
        }

        protected Image getImage(ExecutionProfileEntity element) {
            return ImageConstants.IMG_16_PROFILE;
        }

        protected String getText(ExecutionProfileEntity element) {
            return element.getName();
        }
    }
}

