/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.launcher;

import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import com.kms.katalon.execution.launcher.process.ProcessStdoutFileExporter;
import com.kms.katalon.execution.logging.IOutputStream;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;

public class IDELaunchProcess
implements ILaunchProcess {
    private ILaunch fLaunch;
    private ProcessStdoutFileExporter stdoutFileExporter;
    private IStreamListener stdoutStreamListener;
    private IStreamListener stderrStreamListener;

    private IStreamMonitor getStdoutStreamMonitor() {
        return this.getProcess().getStreamsProxy().getOutputStreamMonitor();
    }

    private IStreamMonitor getStderrStreamMonitor() {
        return this.getProcess().getStreamsProxy().getErrorStreamMonitor();
    }

    public IDELaunchProcess(ILaunch launch, boolean generateConsoleLog, File reportFolder) throws ExecutionException {
        this.fLaunch = launch;
        if (generateConsoleLog) {
            try {
                this.stdoutFileExporter = new ProcessStdoutFileExporter(reportFolder);
                this.stdoutFileExporter.start();
                this.buildStreamHandler();
            }
            catch (IOException | SecurityException e) {
                LogUtil.logError((String)"Failed to start ProcessStdoutFileExporter in IDELauncherProcess");
                LogUtil.logError((Throwable)e);
                throw new ExecutionException((Throwable)e);
            }
        }
    }

    protected void buildStreamHandler() {
        this.stdoutStreamListener = new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                if (StringUtils.isNotBlank((String)text)) {
                    IDELaunchProcess.this.stdoutFileExporter.recordStdoutLog(text);
                }
            }
        };
        this.getStdoutStreamMonitor().addListener(this.stdoutStreamListener);
        this.stderrStreamListener = new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                if (StringUtils.isNotBlank((String)text)) {
                    IDELaunchProcess.this.stdoutFileExporter.recordStderrLog(text);
                }
            }
        };
        this.getStderrStreamMonitor().addListener(this.stderrStreamListener);
    }

    public int getExitValue() {
        try {
            return this.getProcess().getExitValue();
        }
        catch (DebugException e) {
            throw new IllegalStateException(e);
        }
    }

    public void terminate() {
        try {
            IProcess process = this.getProcess();
            if (process != null && process.canTerminate()) {
                this.removeStreamListener();
                this.stopStdoutStream();
                this.getProcess().terminate();
            }
        }
        catch (DebugException e) {
            throw new IllegalThreadStateException(e.getMessage());
        }
    }

    public boolean isTerminated() {
        return this.getProcess() != null && this.getProcess().isTerminated();
    }

    private IProcess getProcess() {
        if (this.fLaunch != null && this.fLaunch.getProcesses() != null && this.fLaunch.getProcesses().length > 0) {
            return this.fLaunch.getProcesses()[0];
        }
        return null;
    }

    public IOutputStream getOutputStreamHandler() {
        this.removeStreamListener();
        this.stopStdoutStream();
        return null;
    }

    public IOutputStream getErrorStreamHandler() {
        this.removeStreamListener();
        this.stopStdoutStream();
        return null;
    }

    private void stopStdoutStream() {
        try {
            if (this.stdoutFileExporter != null) {
                this.stdoutFileExporter.close();
            }
        }
        catch (Exception e) {
            LogUtil.logError((String)"Failed to close stdoutFileExporter");
            LogUtil.logError((Throwable)e);
        }
    }

    private void removeStreamListener() {
        try {
            if (this.stdoutStreamListener != null) {
                this.getStdoutStreamMonitor().removeListener(this.stdoutStreamListener);
            }
            if (this.stderrStreamListener != null) {
                this.getStderrStreamMonitor().removeListener(this.stderrStreamListener);
            }
        }
        catch (Exception e) {
            LogUtil.logError((String)"Failed to remove listener");
            LogUtil.logError((Throwable)e);
        }
    }
}

