/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.part;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.ImageConstants;
import com.kms.katalon.composer.execution.constants.SeleniumExceptionConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.dialog.LogPropertyDialog;
import com.kms.katalon.composer.execution.launcher.IDEConsoleManager;
import com.kms.katalon.composer.execution.launcher.IDEObservableLauncher;
import com.kms.katalon.composer.execution.launcher.IDEObservableParentLauncher;
import com.kms.katalon.composer.execution.logviewer.FastLogRecordTreeView;
import com.kms.katalon.composer.execution.logviewer.FastTreeViewerFilterBuilder;
import com.kms.katalon.composer.execution.logviewer.LogViewerFormatUtils;
import com.kms.katalon.composer.execution.provider.LogTableViewer;
import com.kms.katalon.composer.execution.provider.LogViewerFilter;
import com.kms.katalon.composer.execution.trace.ArtifactStyleRangeMatcher;
import com.kms.katalon.composer.execution.trace.CheckpointStyleRangeMatcher;
import com.kms.katalon.composer.execution.trace.LogExceptionNavigator;
import com.kms.katalon.composer.execution.trace.StyleRangeMatcher;
import com.kms.katalon.composer.execution.trace.TestDataStyleRangeMatcher;
import com.kms.katalon.composer.execution.trace.TestObjectStyleRangeMatcher;
import com.kms.katalon.composer.execution.util.LauncherHelper;
import com.kms.katalon.composer.execution.util.TestCaseEditorUtil;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.event.EventEmitter;
import com.kms.katalon.core.logging.XMLLoggerParser;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.XmlLogRecordException;
import com.kms.katalon.core.reporting.newreport.NewLogRecordModelMapper;
import com.kms.katalon.core.testcase.BrokenTestCaseSummary;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.listener.LauncherEvent;
import com.kms.katalon.execution.launcher.listener.LauncherListener;
import com.kms.katalon.execution.launcher.listener.LauncherNotifiedObject;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.execution.logging.LogExceptionFilter;
import com.kms.katalon.execution.setting.WebUiExecutionSettingStore;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.report.core.models.common.ExecutedTestResult;
import com.kms.katalon.report.core.models.entities.ExecutedTestEntity;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.MaskedTextUtil;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.LogRecord;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Throttler;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class LogViewerPart
implements EventHandler,
LauncherListener {
    private static final String MESSAGE_PART_DELIMITER = "\n\n";
    private static final int AFTER_STATUS_MENU_INDEX = 1;
    private static final int INCREMENT = 10;
    @Inject
    private UISynchronize sync;
    @Inject
    private IEventBroker eventBroker;
    private Table table;
    private LogTableViewer tableViewer;
    private ProgressBar progressBar;
    private Label lblNumTestcases;
    private Label lblNumFailures;
    private Label lblNumPasses;
    private Label lblNumErrors;
    private Label lblNumSkips;
    private Composite parentComposite;
    private IDEObservableLauncher rootLauncherWatched;
    private List<IDEObservableLauncher> launchersWatched;
    private int selectedLauncherWatchedIndex;
    private boolean isBusy;
    private boolean loadingLogCanceled;
    private FastLogRecordTreeView treeViewer;
    private NewLogRecordModelMapper recordMapper = new NewLogRecordModelMapper();
    private FastTreeViewerFilterBuilder filterQueryBuilder = new FastTreeViewerFilterBuilder();
    private StyledText txtMessage;
    private ToolItem btnShowAllLogs;
    private ToolItem btnShowInfoLogs;
    private ToolItem btnShowPassedLogs;
    private ToolItem btnShowFailedLogs;
    private ToolItem btnShowErrorLogs;
    private ToolItem btnShowWarningLogs;
    private ToolItem btnShowNotRunLogs;
    private ToolItem tltmFilterFailedLogs;
    private List<XmlLogRecord> currentRecords;
    private Composite compositeTreeContainer;
    private LogExceptionNavigator logNavigator;
    private MPart fMPart;
    private ScopedPreferenceStore preferenceStore;
    private LogLoadingJob loadingJob;
    private static final List<StyleRangeMatcher> ARTIFACT_MATCHERS;
    private static final String[] commonSeleniumExceptions;
    private Listener mouseDownListener = new Listener(){

        public void handleEvent(org.eclipse.swt.widgets.Event event) {
            try {
                int offset = LogViewerPart.this.txtMessage.getOffsetAtLocation(new Point(event.x, event.y));
                StyleRange style = null;
                StyleRange[] styleRangeArray = LogViewerPart.this.txtMessage.getStyleRanges();
                int n = styleRangeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StyleRange range = styleRangeArray[n2];
                    if (range.start <= offset && range.start + range.length >= offset) {
                        style = range;
                        break;
                    }
                    ++n2;
                }
                if (style == null || !style.underline || style.underlineStyle != 4) {
                    return;
                }
                Object styleData = style.data;
                if (styleData instanceof XmlLogRecordException) {
                    XmlLogRecordException logException = (XmlLogRecordException)styleData;
                    LogViewerPart.this.navigateScriptByLogExpcetion(logException);
                    return;
                }
                if (styleData instanceof ArtifactStyleRangeMatcher) {
                    ArtifactStyleRangeMatcher matcher = (ArtifactStyleRangeMatcher)styleData;
                    matcher.onClick(LogViewerPart.this.txtMessage.getText(), style);
                }
                if (styleData instanceof String) {
                    String url = (String)styleData;
                    Program.launch((String)url);
                    Trackings.trackClickOnExceptionDocInLogViewer((String)url);
                }
                if (styleData instanceof BrokenTestCaseSummary) {
                    BrokenTestCaseSummary brokenTestCaseSummary = (BrokenTestCaseSummary)styleData;
                    if (brokenTestCaseSummary.getMhtml() == null) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.DIA_TITLE_UNABLE_TO_ACCESS_TIME_CAPSULE, (String)StringConstants.DIA_CONTENT_WHERE_TO_FIND_TIME_CAPSULE);
                    } else {
                        Trackings.trackTriggerFixingBrokenTestObjectFromLogViewer();
                        LogViewerPart.this.eventBroker.post("OBJECT_SPY/TEST_OBJECT_ADDED", (Object)new Object[]{brokenTestCaseSummary});
                    }
                }
            }
            catch (Exception exception) {}
        }
    };
    private LogPropertyDialog dialog;
    private Throttler throttler = null;

    static {
        commonSeleniumExceptions = new String[]{SeleniumExceptionConstants.NO_SUCH_ELEMENT, SeleniumExceptionConstants.NO_SUCH_WINDOW, SeleniumExceptionConstants.NO_SUCH_FRAME, SeleniumExceptionConstants.INVALID_SELECTOR, SeleniumExceptionConstants.ELEMENT_NOT_INTERACTABLE, SeleniumExceptionConstants.ELEMMENT_NOT_VISIBLE, SeleniumExceptionConstants.ELEMENT_NOT_SELECTABLE, SeleniumExceptionConstants.TIMEOUT, SeleniumExceptionConstants.STALE_ELEMENT_REFERENCE};
        ARTIFACT_MATCHERS = Arrays.asList(new TestObjectStyleRangeMatcher(), new TestDataStyleRangeMatcher(), new CheckpointStyleRangeMatcher());
    }

    private void safeExecute(UnsafeRunnable func) {
        try {
            func.run();
        }
        catch (Throwable error) {
            LoggerSingleton.logError((Throwable)error);
        }
    }

    private void initToolItemsStatus(MPart mpart) {
        for (MToolBarElement toolbarElement : mpart.getToolbar().getChildren()) {
            if (!(toolbarElement instanceof MDirectToolItem)) continue;
            MDirectToolItem toolItem = (MDirectToolItem)toolbarElement;
            switch (toolItem.getElementId()) {
                case "com.kms.katalon.composer.execution.directtoolitem.tree": {
                    toolItem.setSelected(this.preferenceStore.getBoolean("log.treeView"));
                    break;
                }
                case "com.kms.katalon.composer.execution.directtoolitem.pin": {
                    toolItem.setSelected(this.preferenceStore.getBoolean("log.pinView"));
                }
            }
        }
    }

    private void updateMenuStatus(MPart mpart) {
        boolean isShowLogAsTree = this.preferenceStore.getBoolean("log.treeView");
        for (MMenu menu : mpart.getMenus()) {
            if (!"com.kms.katalon.composer.execution.menu.treeview".equals(menu.getElementId())) {
                menu.setVisible(true);
                continue;
            }
            if (isShowLogAsTree) {
                menu.setVisible(true);
                for (MMenuElement childElement : menu.getChildren()) {
                    if (!(childElement instanceof MDirectMenuItem) || !"com.kms.katalon.composer.execution.handledmenuitem.wordWrap".equals(childElement.getElementId())) continue;
                    MDirectMenuItem wordWrapElement = (MDirectMenuItem)childElement;
                    wordWrapElement.setSelected(this.preferenceStore.getBoolean("log.wordWrap"));
                }
                continue;
            }
            menu.setVisible(false);
        }
    }

    @PostConstruct
    public void init(Composite parent, MPart mpart) {
        this.preferenceStore = PreferenceStoreManager.getPreferenceStore(LogViewerPart.class);
        this.fMPart = mpart;
        this.logNavigator = new LogExceptionNavigator();
        this.launchersWatched = new ArrayList<IDEObservableLauncher>();
        this.selectedLauncherWatchedIndex = -1;
        this.isBusy = false;
        this.currentRecords = Collections.synchronizedList(new ArrayList());
        this.parentComposite = parent;
        this.initLogRecordThrottler();
        this.initToolItemsStatus(mpart);
        this.createControls(parent);
        this.createLogViewerControl(parent);
        this.registerEventListeners();
        this.getChangingViewToolItem().setEnabled(true);
    }

    private void createLogViewerControl(Composite parent) {
        this.disposeChildrenFromIndex(parent, 1);
        boolean showLogsAsTree = this.preferenceStore.getBoolean("log.treeView");
        if (showLogsAsTree) {
            this.createTreeCompositeContainer(parent);
        } else {
            this.createTableComposite(parent);
        }
        parent.layout(true);
        this.updateMenuStatus(this.fMPart);
    }

    private void disposeChildrenFromIndex(Composite parent, int start) {
        parent.setRedraw(false);
        while (parent.getChildren().length > start) {
            parent.getChildren()[start].dispose();
        }
        parent.setRedraw(true);
    }

    private void registerEventListeners() {
        this.eventBroker.subscribe("JOB/COMPLETED", (EventHandler)this);
        this.eventBroker.subscribe("CONSOLE_LOG/RESET", (EventHandler)this);
        this.eventBroker.subscribe("CONSOLE_LOG/REFRESH", (EventHandler)this);
        this.eventBroker.subscribe("CONSOLE_LOG/UPDATE_PROGRESS_BAR", (EventHandler)this);
        this.eventBroker.subscribe("CONSOLE_LOG/CHANGE_VIEW_TYPE", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/RELOAD_INPUT", (EventHandler)this);
        this.eventBroker.subscribe("CONSOLE_LOG/WORD_WRAP", (EventHandler)this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages()[0].addPostSelectionListener("org.eclipse.ui.console.ConsoleView", new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                LogViewerPart.this.setSelectedConsoleView();
            }
        });
    }

    private void createTreeCompositeToolbar(Composite compositeTreeContainer) {
        ToolBar toolBar = new ToolBar(compositeTreeContainer, 0x820200);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        toolBar.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        ToolItem tltmCollapseAll = new ToolItem(toolBar, 0);
        tltmCollapseAll.setToolTipText(StringConstants.PA_COLLAPSE_ALL);
        tltmCollapseAll.setImage(ImageConstants.IMG_16_COLLAPSE_ALL);
        tltmCollapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogViewerPart.this.treeViewer.collapseAll();
            }
        });
        ToolItem tltmExpandAll = new ToolItem(toolBar, 0);
        tltmExpandAll.setToolTipText(StringConstants.PA_EXPAND_ALL);
        tltmExpandAll.setImage(ImageConstants.IMG_16_EXPAND_ALL);
        tltmExpandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogViewerPart.this.treeViewer.expandAll();
            }
        });
        ToolItem tltmShowPreviousFailure = new ToolItem(toolBar, 0);
        tltmShowPreviousFailure.setImage(ImageConstants.IMG_16_PREVIOUS_FAILURE);
        tltmShowPreviousFailure.setToolTipText(StringConstants.PA_PREV_FAILURE);
        tltmShowPreviousFailure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LogViewerPart.this.isLaunchersWatchedValid()) {
                    LogViewerPart.this.isBusy = true;
                    LogViewerPart.this.treeViewer.goToPrevFilteredNode();
                    LogViewerPart.this.isBusy = false;
                }
            }
        });
        ToolItem tltmShowNextFailure = new ToolItem(toolBar, 0);
        tltmShowNextFailure.setImage(ImageConstants.IMG_16_NEXT_FAILURE);
        tltmShowNextFailure.setToolTipText(StringConstants.PA_NEXT_FAILURE);
        tltmShowNextFailure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LogViewerPart.this.isLaunchersWatchedValid()) {
                    LogViewerPart.this.isBusy = true;
                    LogViewerPart.this.treeViewer.goToNextFilteredNode();
                    LogViewerPart.this.isBusy = false;
                }
            }
        });
        this.tltmFilterFailedLogs = new ToolItem(toolBar, 32);
        this.tltmFilterFailedLogs.setData(StringConstants.ID, (Object)"log.treeViewer.showFailures");
        this.tltmFilterFailedLogs.setToolTipText(ComposerExecutionMessageConstants.PA_TOOLTIP_SHOW_FAILED_STEPS_ONLY0);
        this.tltmFilterFailedLogs.setImage(ImageConstants.IMG_16_LOGVIEW_FAILED);
        this.tltmFilterFailedLogs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogViewerPart.this.treeViewer.toggleFilterQuery(LogViewerPart.this.tltmFilterFailedLogs.getSelection());
                LogViewerPart.this.performFilterLogs(LogViewerPart.this.tltmFilterFailedLogs, LogViewerPart.this.preferenceStore, null);
            }
        });
        this.updateTreeToolbarItems();
    }

    private boolean isLaunchersWatchedValid() {
        return this.launchersWatched != null && !this.launchersWatched.isEmpty() && this.selectedLauncherWatchedIndex > -1 && this.selectedLauncherWatchedIndex < this.launchersWatched.size();
    }

    public IDEObservableLauncher getLauncherWatched() {
        if (this.isLaunchersWatchedValid()) {
            return this.launchersWatched.get(this.selectedLauncherWatchedIndex);
        }
        return null;
    }

    private void createTreeCompositeDetails(SashForm sashForm) {
        Composite compositeTreeDetails = (Composite)ComponentBuilder.fillContainer((Composite)sashForm).build();
        this.treeViewer = new FastLogRecordTreeView(compositeTreeDetails, 2048);
        this.treeViewer.onBrowserLoaded(browser -> {
            if (this.isLaunchersWatchedValid()) {
                this.filterQueryBuilder.toggleShowFailedSteps(true);
                this.treeViewer.setFilterQuery(this.filterQueryBuilder.build());
                this.treeViewer.toggleFilterQuery(this.tltmFilterFailedLogs.getSelection());
                boolean isNonRunningLauncher = LauncherHelper.isNonRunningLauncher((ILauncher)this.getLauncherWatched());
                if (isNonRunningLauncher) {
                    this.treeViewer.scrollToTop();
                } else {
                    this.treeViewer.scrollToBottom();
                }
                this.loadingJob = new LogLoadingJob(isNonRunningLauncher);
                this.loadingJob.setUser(true);
                this.loadingJob.schedule();
            }
        });
        this.treeViewer.onOpenTestStep((EventEmitter.CustomEventListener<FastLogRecordTreeView.OpenTestStepInfo>)((EventEmitter.CustomEventListener)info -> {
            String testCaseId = info.testCaseId;
            int stepIndex = info.stepIndex;
            TestCaseEntity testCaseEntity = null;
            try {
                testCaseEntity = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseId);
            }
            catch (Exception exception) {
                MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)MessageFormat.format(ComposerExecutionMessageConstants.DIA_WARN_TEST_CASE_NOT_FOUND, testCaseId));
            }
            try {
                TestCaseEditorUtil.navigateToTestStep(testCaseEntity, stepIndex);
            }
            catch (Exception e) {
                MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)e.getMessage());
            }
        }));
        this.treeViewer.onItemSelected(item -> {
            if (item == null) {
                return;
            }
            this.safeExecute(() -> this.showTreeLogProperties(this.recordMapper.findEntity(executedTestEntity.id)));
        });
    }

    private void createTreeCompositeContainer(Composite parent) {
        this.compositeTreeContainer = new Composite(parent, 0);
        this.compositeTreeContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glComposite = new GridLayout(2, false);
        glComposite.horizontalSpacing = 0;
        glComposite.marginWidth = 0;
        glComposite.marginHeight = 0;
        this.compositeTreeContainer.setLayout((Layout)glComposite);
        this.createTreeCompositeToolbar(this.compositeTreeContainer);
        SashForm sashForm = new SashForm(this.compositeTreeContainer, 0);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createTreeCompositeDetails(sashForm);
        this.createTreeNodePropertiesComposite(sashForm);
        sashForm.setWeights(new int[]{1, 1});
        this.treeViewer.reset();
        this.recordMapper.reset();
    }

    private void showFailureTreeLogMessage(ExecutedTestEntity entity) throws Exception {
        String logTime = LogViewerFormatUtils.formatLogTime(entity.startTime);
        String elapsedTime = LogViewerFormatUtils.formatDuration(entity.startTime, entity.endTime);
        StringBuilder messageBuilder = new StringBuilder().append(logTime).append(" ").append(entity.message).append(MESSAGE_PART_DELIMITER).append("Elapsed time: ").append(elapsedTime).append(MESSAGE_PART_DELIMITER);
        XmlLogRecord result = this.recordMapper.findResultXMLRecord(entity.id);
        if (result != null) {
            if (entity.result == ExecutedTestResult.FAILED || entity.result == ExecutedTestResult.ERROR) {
                ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
                if (result.getExceptions() != null) {
                    for (XmlLogRecordException exceptionLogEntry : result.getExceptions()) {
                        TestCaseEntity testCase;
                        if (!LogExceptionFilter.isTraceableException((XmlLogRecordException)exceptionLogEntry)) continue;
                        StyleRange range = new StyleRange();
                        range.start = messageBuilder.length();
                        String exceptionLogString = exceptionLogEntry.toString();
                        if (LogExceptionFilter.isTestCaseScript((String)exceptionLogEntry.getClassName()) && (testCase = LogExceptionFilter.getTestCaseByLogException((XmlLogRecordException)exceptionLogEntry)) != null) {
                            String testCaseId = testCase.getIdForDisplay();
                            exceptionLogString = exceptionLogEntry.toString().replace(exceptionLogEntry.getClassName(), testCaseId);
                        }
                        messageBuilder.append(exceptionLogString).append(MESSAGE_PART_DELIMITER);
                        range.length = exceptionLogString.length();
                        range.underline = true;
                        range.data = exceptionLogEntry;
                        range.foreground = ColorUtil.getHyperlinkTextColor();
                        range.underlineStyle = 4;
                        styleRanges.add(range);
                    }
                }
                StringBuilder causedByStrBuilder = this.parseXmlLogRecordAndAppendSolutions(messageBuilder, result, entity.message, styleRanges);
                causedByStrBuilder.append((CharSequence)messageBuilder);
                this.writeMessage(true, MaskedTextUtil.maskedTextBasedOnKeyword((String)causedByStrBuilder.toString()));
                if (styleRanges.size() > 0) {
                    this.txtMessage.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
                }
            } else {
                messageBuilder.append(result != null ? result.getMessage() : entity.message);
                this.writeMessage(false, MaskedTextUtil.maskedTextBasedOnKeyword((String)messageBuilder.toString()));
            }
        } else {
            this.writeMessage(false, MaskedTextUtil.maskedTextBasedOnKeyword((String)messageBuilder.toString()));
        }
    }

    private StringBuilder parseXmlLogRecordAndAppendSolutions(StringBuilder messageBuilder, XmlLogRecord result, String message, List<StyleRange> styleRanges) {
        boolean threwWebElementNotFoundException;
        StringBuilder causedByStrBuilder = new StringBuilder();
        String causedBy = this.getCausedBySentence(result);
        causedByStrBuilder.append("=============== ROOT CAUSE =====================\n");
        causedByStrBuilder.append(causedBy + "\n");
        if (Arrays.asList(commonSeleniumExceptions).stream().filter(commonException -> causedBy.contains((CharSequence)commonException)).findAny().isPresent()) {
            String testObject = BrokenTestCaseSummary.Utils.extractFirstTestObject((String)result.getMessage());
            causedByStrBuilder.append("At object: " + testObject + "\n");
        }
        if (this.isTimeCapsuleValid(result, message, threwWebElementNotFoundException = causedBy.contains(BrokenTestCaseSummary.Constants.WEB_ELEMENT_NOT_FOUND_EXCEPTION))) {
            this.appendFixBrokenLocatorTrigger(styleRanges, causedByStrBuilder, result, message);
        } else {
            this.appendTroubleShootingLink(styleRanges, causedByStrBuilder);
        }
        causedByStrBuilder.append("================================================\n\n");
        messageBuilder.append(result.getMessage());
        return causedByStrBuilder;
    }

    private BrokenTestCaseSummary getMHTMLFromTimeCapsule(XmlLogRecord result, String message) {
        BrokenTestCaseSummary brokenTestCaseSummary = BrokenTestCaseSummary.Builder.buildFrom((XmlLogRecord)result, (String)message);
        try {
            String folderToStoreMhtml = RunConfiguration.getLogFolderPath();
            String testCaseId = brokenTestCaseSummary.getTestCase();
            if (StringUtils.isNotBlank((String)folderToStoreMhtml) && StringUtils.isNotBlank((String)testCaseId)) {
                brokenTestCaseSummary.searchAndSetMhtmlFile(folderToStoreMhtml, testCaseId);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return brokenTestCaseSummary;
    }

    private String getCausedBySentence(XmlLogRecord result) {
        String causedBy = "";
        causedBy = this.failedDueToOutdatedChromeDriver(result.getMessage()) || this.failureDueToOutdatedEdgeChromium(result.getMessage()) ? StringConstants.PA_MSG_DRIVER_OUTDATED : BrokenTestCaseSummary.Utils.getCausedBySentence((String)result.getMessage());
        return causedBy;
    }

    private boolean isTimeCapsuleValid(XmlLogRecord result, String message, boolean threwWebElementNotFoundException) {
        if (!this.isInstalledTimeCapsule() || !threwWebElementNotFoundException) {
            return false;
        }
        BrokenTestCaseSummary brokenTestObject = this.getMHTMLFromTimeCapsule(result, message);
        String mhtmlPath = brokenTestObject.getMhtml();
        if (mhtmlPath == null) {
            return false;
        }
        File mhtmlFile = new File(mhtmlPath);
        return mhtmlFile.exists();
    }

    private boolean isInstalledTimeCapsule() {
        WebUiExecutionSettingStore webUiSettingStore = WebUiExecutionSettingStore.getStore();
        boolean isTimeCapsuleEnabled = webUiSettingStore.getTimeCapsuleEnabled();
        return isTimeCapsuleEnabled;
    }

    private void appendFixBrokenLocatorTrigger(List<StyleRange> styleRanges, StringBuilder causedByStrBuilder, XmlLogRecord result, String message) {
        String text = "\n" + GlobalStringConstants.FIX_BROKEN_TEST_CASE_TEXT;
        StyleRange range = new StyleRange();
        range.start = causedByStrBuilder.length();
        range.length = text.length();
        range.underline = true;
        BrokenTestCaseSummary brokenTestCaseSummary = this.getMHTMLFromTimeCapsule(result, message);
        range.data = brokenTestCaseSummary;
        range.foreground = ColorUtil.getHyperlinkTextColor();
        range.underlineStyle = 4;
        causedByStrBuilder.append(text + "\n");
        styleRanges.add(range);
    }

    private void appendTroubleShootingLink(List<StyleRange> styleRanges, StringBuilder causedByStrBuilder) {
        causedByStrBuilder.append("\nFor trouble shooting, please visit: ");
        String visitDocs = "https://docs.katalon.com/katalon-studio/troubleshooting/troubleshoot-common-exceptions";
        StyleRange range = new StyleRange();
        range.start = causedByStrBuilder.length();
        range.length = visitDocs.length();
        range.underline = true;
        range.data = visitDocs;
        range.foreground = ColorUtil.getHyperlinkTextColor();
        range.underlineStyle = 4;
        causedByStrBuilder.append(visitDocs + "\n");
        styleRanges.add(range);
    }

    private boolean failedDueToOutdatedChromeDriver(String message) {
        return message.contains("This version of ChromeDriver only supports Chrome version");
    }

    private boolean failureDueToOutdatedEdgeChromium(String message) {
        return message.contains("This version of MSEdgeDriver only supports MSEdge version");
    }

    private void writeMessage(boolean error, String message) {
        Color color = error ? ColorUtil.getTextErrorColor() : ColorUtil.getDefaultTextColor();
        this.txtMessage.setForeground(color);
        this.txtMessage.setText(message);
    }

    private void showTreeLogProperties(ExecutedTestEntity entity) {
        this.safeExecute(() -> {
            if (entity == null) {
                return;
            }
            this.showFailureTreeLogMessage(entity);
            String message = this.txtMessage.getText();
            ARTIFACT_MATCHERS.forEach(matcher -> matcher.getStyleRanges(message).forEach(styleRange -> this.txtMessage.setStyleRange(styleRange)));
        });
    }

    private void navigateScriptByLogExpcetion(XmlLogRecordException logException) {
        if (LogExceptionFilter.isTestCaseScript((String)logException.getClassName())) {
            this.logNavigator.openTestCaseByLogException(logException);
        } else if (LogExceptionFilter.isCustomKeywordScript((String)logException.getClassName())) {
            this.logNavigator.openKeywordByLogException(logException);
        }
    }

    private void createTreeNodePropertiesComposite(SashForm sashForm) {
        this.txtMessage = new StyledText((Composite)sashForm, 2818);
        this.txtMessage.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.txtMessage.setEditable(false);
        this.txtMessage.addListener(3, this.mouseDownListener);
        this.txtMessage.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.setWrapTxtMessage();
    }

    private void createStatusComposite(Composite container) {
        Composite compositeStatus = new Composite(container, 0);
        compositeStatus.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeStatus = new GridLayout(2, true);
        glCompositeStatus.marginWidth = 0;
        compositeStatus.setLayout((Layout)glCompositeStatus);
        Composite composite = new Composite(compositeStatus, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(5, true));
        Composite compositeRuns = new Composite(composite, 0);
        compositeRuns.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositeRuns.setLayout((Layout)new GridLayout(2, false));
        Label lblRuns = new Label(compositeRuns, 0);
        lblRuns.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        lblRuns.setText(StringConstants.PA_LBL_RUNS);
        this.lblNumTestcases = new Label(compositeRuns, 0);
        this.lblNumTestcases.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite compositePasses = new Composite(composite, 0);
        compositePasses.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositePasses.setLayout((Layout)new GridLayout(2, false));
        Label lblPasses = new Label(compositePasses, 0);
        lblPasses.setText(StringConstants.PA_LBL_PASSES);
        lblPasses.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.lblNumPasses = new Label(compositePasses, 0);
        this.lblNumPasses.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite compositeFailures = new Composite(composite, 0);
        compositeFailures.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositeFailures.setLayout((Layout)new GridLayout(2, false));
        Label lblFailures = new Label(compositeFailures, 0);
        lblFailures.setText(StringConstants.PA_LBL_FAILURES);
        lblFailures.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.lblNumFailures = new Label(compositeFailures, 0);
        this.lblNumFailures.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite compositeIncompletes = new Composite(composite, 0);
        compositeIncompletes.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        compositeIncompletes.setLayout((Layout)new GridLayout(2, false));
        Label lblErrors = new Label(compositeIncompletes, 0);
        lblErrors.setText(StringConstants.PA_LBL_ERRORS);
        lblErrors.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.lblNumErrors = new Label(compositeIncompletes, 0);
        this.lblNumErrors.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite compositeSkips = new Composite(composite, 0);
        compositeSkips.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        compositeSkips.setLayout((Layout)new GridLayout(2, false));
        Label lblSkips = new Label(compositeSkips, 0);
        lblSkips.setText(ComposerExecutionMessageConstants.PA_LBL_SKIPS);
        lblSkips.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.lblNumSkips = new Label(compositeSkips, 0);
        this.lblNumSkips.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.progressBar = new ProgressBar(compositeStatus, 65536);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    private void createTableButtonComposite(Composite container) {
        ToolBar toolBar = new ToolBar(container, 0x820200);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        toolBar.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.btnShowAllLogs = new ToolItem(toolBar, 32);
        this.btnShowAllLogs.setData(StringConstants.ID, (Object)"log.showAll");
        this.btnShowAllLogs.setText(StringConstants.PA_TIP_ALL);
        this.btnShowAllLogs.setToolTipText(StringConstants.PA_TIP_ALL);
        this.btnShowAllLogs.setImage(ImageConstants.IMG_16_LOGVIEW_ALL);
        this.btnShowInfoLogs = new ToolItem(toolBar, 32);
        this.btnShowInfoLogs.setData(StringConstants.ID, (Object)"log.showInfo");
        this.btnShowInfoLogs.setText(StringConstants.PA_TIP_INFO);
        this.btnShowInfoLogs.setToolTipText(StringConstants.PA_TIP_INFO);
        this.btnShowInfoLogs.setImage(ImageConstants.IMG_16_LOGVIEW_INFO);
        this.btnShowPassedLogs = new ToolItem(toolBar, 32);
        this.btnShowPassedLogs.setData(StringConstants.ID, (Object)"log.showPasses");
        this.btnShowPassedLogs.setText(StringConstants.PA_TIP_PASSED);
        this.btnShowPassedLogs.setToolTipText(StringConstants.PA_TIP_PASSED);
        this.btnShowPassedLogs.setImage(ImageConstants.IMG_16_LOGVIEW_PASSED);
        this.btnShowFailedLogs = new ToolItem(toolBar, 32);
        this.btnShowFailedLogs.setData(StringConstants.ID, (Object)"log.showFailures");
        this.btnShowFailedLogs.setText(StringConstants.PA_TIP_FAILED);
        this.btnShowFailedLogs.setToolTipText(StringConstants.PA_TIP_FAILED);
        this.btnShowFailedLogs.setImage(ImageConstants.IMG_16_LOGVIEW_FAILED);
        this.btnShowErrorLogs = new ToolItem(toolBar, 32);
        this.btnShowErrorLogs.setData(StringConstants.ID, (Object)"log.showErrors");
        this.btnShowErrorLogs.setText(StringConstants.PA_TIP_ERROR);
        this.btnShowErrorLogs.setToolTipText(StringConstants.PA_TIP_ERROR);
        this.btnShowErrorLogs.setImage(ImageConstants.IMG_16_LOGVIEW_ERROR);
        this.btnShowWarningLogs = new ToolItem(toolBar, 32);
        this.btnShowWarningLogs.setData(StringConstants.ID, (Object)"log.showWarning");
        this.btnShowWarningLogs.setText(StringConstants.PA_TIP_WARNING);
        this.btnShowWarningLogs.setToolTipText(StringConstants.PA_TIP_WARNING);
        this.btnShowWarningLogs.setImage(ImageConstants.IMG_16_LOGVIEW_WARNING);
        this.btnShowNotRunLogs = new ToolItem(toolBar, 32);
        this.btnShowNotRunLogs.setData(StringConstants.ID, (Object)"log.showNotRun");
        this.btnShowNotRunLogs.setText(StringConstants.PA_TIP_NOT_RUN);
        this.btnShowNotRunLogs.setToolTipText(StringConstants.PA_TIP_NOT_RUN);
        this.btnShowNotRunLogs.setImage(ImageConstants.IMG_16_LOGVIEW_NOT_RUN);
        SelectionAdapter logFilterSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogViewerPart.this.performFilterTableLogs((ToolItem)e.getSource());
            }
        };
        this.btnShowAllLogs.addSelectionListener((SelectionListener)logFilterSelectionAdapter);
        this.btnShowInfoLogs.addSelectionListener((SelectionListener)logFilterSelectionAdapter);
        this.btnShowPassedLogs.addSelectionListener((SelectionListener)logFilterSelectionAdapter);
        this.btnShowFailedLogs.addSelectionListener((SelectionListener)logFilterSelectionAdapter);
        this.btnShowErrorLogs.addSelectionListener((SelectionListener)logFilterSelectionAdapter);
        this.btnShowWarningLogs.addSelectionListener((SelectionListener)logFilterSelectionAdapter);
        this.btnShowNotRunLogs.addSelectionListener((SelectionListener)logFilterSelectionAdapter);
        this.updateTableButtons();
    }

    private void performFilterTableLogs(ToolItem button) {
        this.performFilterLogs(button, this.preferenceStore, (ColumnViewer)this.tableViewer);
    }

    private void performFilterLogs(ToolItem button, ScopedPreferenceStore preferenceStore, ColumnViewer viewer) {
        String prefId = (String)button.getData(StringConstants.ID);
        if (StringUtils.isBlank((String)prefId)) {
            return;
        }
        this.updatePreferenceValue(preferenceStore, prefId, button.getSelection());
        if (viewer != null) {
            viewer.refresh();
        }
    }

    private void updatePreferenceValue(ScopedPreferenceStore preferenceStore, String preferenceKey, boolean value) {
        try {
            preferenceStore.setValue(preferenceKey, value);
            preferenceStore.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void updateTableButtons() {
        this.btnShowAllLogs.setSelection(this.preferenceStore.getBoolean("log.showAll"));
        this.btnShowInfoLogs.setSelection(this.preferenceStore.getBoolean("log.showInfo"));
        this.btnShowPassedLogs.setSelection(this.preferenceStore.getBoolean("log.showPasses"));
        this.btnShowFailedLogs.setSelection(this.preferenceStore.getBoolean("log.showFailures"));
        this.btnShowErrorLogs.setSelection(this.preferenceStore.getBoolean("log.showErrors"));
        this.btnShowWarningLogs.setSelection(this.preferenceStore.getBoolean("log.showWarning"));
        this.btnShowNotRunLogs.setSelection(this.preferenceStore.getBoolean("log.showNotRun"));
    }

    private void updateTreeToolbarItems() {
        this.tltmFilterFailedLogs.setSelection(this.preferenceStore.getBoolean("log.treeViewer.showFailures"));
    }

    private void createTableCompositeDetails(Composite container) {
        Composite compositeTable = new Composite(container, 2048);
        compositeTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new LogTableViewer(compositeTable, 65536, this.eventBroker);
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(ControlUtils.shouldLineVisble((Display)this.table.getDisplay()));
        TableViewerColumn tbViewerColumnLevel = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn tblclmnColumnLevel = tbViewerColumnLevel.getColumn();
        tblclmnColumnLevel.setText(StringConstants.PA_COL_LEVEL);
        TableViewerColumn tbViewerColumnTime = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn tblclmnColumnTime = tbViewerColumnTime.getColumn();
        tblclmnColumnTime.setText(StringConstants.TIME);
        TableViewerColumn tbViewerColumnMessage = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn tblclmnColumnMessage = tbViewerColumnMessage.getColumn();
        tblclmnColumnMessage.setText(StringConstants.MESSAGE);
        TableColumnLayout tableComColumnLayout = new TableColumnLayout();
        compositeTable.setLayout((Layout)tableComColumnLayout);
        tableComColumnLayout.setColumnData((Widget)tblclmnColumnTime, (ColumnLayoutData)new ColumnWeightData(0, 250));
        tableComColumnLayout.setColumnData((Widget)tblclmnColumnLevel, (ColumnLayoutData)new ColumnWeightData(0, 150));
        tableComColumnLayout.setColumnData((Widget)tblclmnColumnMessage, (ColumnLayoutData)new ColumnWeightData(99, 500));
        tbViewerColumnTime.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof XmlLogRecord) {
                    return XMLLoggerParser.getRecordDate((LogRecord)((LogRecord)element));
                }
                return StringConstants.EMPTY;
            }
        });
        tbViewerColumnLevel.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof XmlLogRecord) {
                    return ((XmlLogRecord)element).getLevel().getName();
                }
                return StringConstants.EMPTY;
            }
        });
        tbViewerColumnMessage.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof XmlLogRecord) {
                    return ((XmlLogRecord)element).getMessage();
                }
                return StringConstants.EMPTY;
            }
        });
        this.tableViewer.addFilter(new LogViewerFilter());
        this.table.addListener(40, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                GC gc = event.gc;
                event.detail &= 0xFFFFFFFD;
                gc.fillRectangle(event.x, event.y, event.width, event.height);
            }
        });
        Menu popupMenu = new Menu((Control)this.table);
        MenuItem newItem = new MenuItem(popupMenu, 64);
        newItem.setText(StringConstants.PA_LOG_CONTEXT_MENU_PROPERTIES);
        newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogViewerPart.this.showRecordProperties();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LogViewerPart.this.showRecordProperties();
            }
        });
        this.table.setMenu(popupMenu);
        this.tableViewer.setInput(new ArrayList());
        if (this.isLaunchersWatchedValid()) {
            this.isBusy = true;
            for (XmlLogRecord record : this.currentRecords) {
                this.tableViewer.add(record);
            }
            this.isBusy = false;
        }
    }

    private void createTableComposite(Composite parent) {
        Composite tableContainer = new Composite(parent, 0);
        tableContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glComposite = new GridLayout(2, false);
        glComposite.marginWidth = 0;
        glComposite.marginHeight = 0;
        tableContainer.setLayout((Layout)glComposite);
        this.createTableButtonComposite(tableContainer);
        this.createTableCompositeDetails(tableContainer);
    }

    private void showRecordProperties() {
        if (this.dialog != null && this.dialog.isOpen()) {
            return;
        }
        int index = this.table.getSelectionIndex();
        if (index == -1) {
            return;
        }
        TableItem selectedItem = this.table.getItem(index);
        XmlLogRecord selectedRecord = (XmlLogRecord)selectedItem.getData();
        this.dialog = new LogPropertyDialog(this.table.getDisplay().getActiveShell(), selectedRecord);
        this.dialog.open();
    }

    private void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setBackground(ColorUtil.getExtraLightGrayBackgroundColor());
        this.createStatusComposite(parent);
    }

    private void updateProgressBar() {
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!LogViewerPart.this.isLaunchersWatchedValid()) {
                    return;
                }
                ILauncherResult result = LogViewerPart.this.getLauncherWatched().getResult();
                if (result == null) {
                    return;
                }
                int numExecuted = result.getExecutedTestCases();
                LogViewerPart.this.progressBar.setSelection(numExecuted * 10);
                LogViewerPart.this.lblNumTestcases.setText(Integer.toString(numExecuted) + "/" + Integer.toString(result.getTotalTestCases()));
                LogViewerPart.this.lblNumPasses.setText(Integer.toString(result.getNumPasses()));
                LogViewerPart.this.lblNumFailures.setText(Integer.toString(result.getNumFailures()));
                LogViewerPart.this.lblNumErrors.setText(Integer.toString(result.getNumErrors()));
                LogViewerPart.this.lblNumSkips.setText(Integer.toString(result.getNumSkips()));
                LogViewerPart.this.lblNumTestcases.getParent().getParent().layout();
                if (numExecuted == result.getNumPasses() + result.getNumSkips()) {
                    LogViewerPart.this.progressBar.setState(0);
                } else {
                    LogViewerPart.this.progressBar.setState(1);
                }
            }
        });
    }

    private void resetProgressBar() {
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                LogViewerPart.this.progressBar.setSelection(0);
                IDEObservableLauncher launcherWatched = LogViewerPart.this.getLauncherWatched();
                int maxValue = launcherWatched != null ? launcherWatched.getResult().getTotalTestCases() : 1;
                LogViewerPart.this.progressBar.setMaximum(maxValue * 10);
                LogViewerPart.this.lblNumTestcases.setText(Integer.toString(LogViewerPart.this.progressBar.getSelection()) + "/" + Integer.toString(LogViewerPart.this.progressBar.getMaximum() / 10));
                LogViewerPart.this.lblNumPasses.setText(Integer.toString(0));
                LogViewerPart.this.lblNumFailures.setText(Integer.toString(0));
                LogViewerPart.this.lblNumFailures.setForeground(ColorUtil.getDefaultTextColor());
                LogViewerPart.this.lblNumErrors.setText(Integer.toString(0));
                LogViewerPart.this.lblNumErrors.setForeground(ColorUtil.getDefaultTextColor());
                LogViewerPart.this.lblNumSkips.setText(Integer.toString(0));
                LogViewerPart.this.lblNumSkips.setForeground(ColorUtil.getDefaultTextColor());
                LogViewerPart.this.lblNumTestcases.getParent().getParent().layout();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecords(List<XmlLogRecord> records) throws InterruptedException {
        if (this.loadingJob != null && this.loadingJob.getState() == 4) {
            return;
        }
        this.waitForNotBusy();
        this.isBusy = true;
        try {
            boolean showLogsAsTree = this.preferenceStore.getBoolean("log.treeView");
            if (showLogsAsTree) {
                ExecutedTestEntity lastEntity;
                Object[] newEntities = this.recordMapper.mapLogRecordParts(records);
                ExecutedTestEntity executedTestEntity = lastEntity = newEntities.length > 0 ? newEntities[newEntities.length - 1] : null;
                if (lastEntity != null) {
                    this.safeExecute(() -> this.showTreeLogProperties(this.recordMapper.findEntity(executedTestEntity.id)));
                }
                this.treeViewer.appendItems(newEntities);
                if (LauncherHelper.isNonRunningLauncher((ILauncher)this.getLauncherWatched()) && records.isEmpty()) {
                    this.treeViewer.appendItems(this.recordMapper.flushIncompleteLogRecords());
                }
            } else {
                for (XmlLogRecord record : records) {
                    this.tableViewer.add(record);
                }
            }
            List<XmlLogRecord> list = this.currentRecords;
            synchronized (list) {
                this.currentRecords.addAll(records);
            }
        }
        finally {
            this.isBusy = false;
        }
    }

    private synchronized void changeObservedLauncher(final Event event) throws Exception {
        final LogViewerPart launcherListener = this;
        new Thread(new Runnable(){

            private IDEObservableLauncher getWatchedLauncherFromEvent() {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (!(object instanceof String)) {
                    return null;
                }
                String launcherId = (String)object;
                return LauncherHelper.findLauncher(LauncherManager.getInstance().getAllLaunchers(), launcherId);
            }

            @Override
            public void run() {
                boolean isChildLauncher;
                if (LogViewerPart.this.parentComposite == null || LogViewerPart.this.parentComposite.isDisposed()) {
                    return;
                }
                LogViewerPart.this.waitForNotBusy();
                IDEObservableLauncher watchedLauncher = this.getWatchedLauncherFromEvent();
                if (watchedLauncher != null && LauncherHelper.isSameLauncher((ILauncher)watchedLauncher, (ILauncher)LogViewerPart.this.getLauncherWatched())) {
                    try {
                        LogViewerPart.this.addRecords(Collections.emptyList());
                    }
                    catch (InterruptedException interruptedException) {}
                    return;
                }
                boolean isSameRootLauncher = watchedLauncher != null && watchedLauncher.equals(LogViewerPart.this.rootLauncherWatched) && LogViewerPart.this.rootLauncherWatched instanceof IDEObservableParentLauncher;
                boolean bl = isChildLauncher = watchedLauncher != null && LauncherHelper.findLauncher((ILauncher)LogViewerPart.this.rootLauncherWatched, watchedLauncher.getId()) != null;
                if (isSameRootLauncher || isChildLauncher) {
                    LogViewerPart.this.launchersWatched = ((IDEObservableParentLauncher)LogViewerPart.this.rootLauncherWatched).getObservableLaunchers();
                    return;
                }
                LogViewerPart.this.currentRecords.clear();
                this.clearWatchedLaunchers(launcherListener);
                LogViewerPart.this.loadingLogCanceled = false;
                LogViewerPart.this.rootLauncherWatched = watchedLauncher;
                if (LogViewerPart.this.rootLauncherWatched == null) {
                    LogViewerPart.this.launchersWatched = new ArrayList<IDEObservableLauncher>();
                } else if (LogViewerPart.this.rootLauncherWatched instanceof IDEObservableParentLauncher) {
                    LogViewerPart.this.launchersWatched = ((IDEObservableParentLauncher)LogViewerPart.this.rootLauncherWatched).getObservableLaunchers();
                } else {
                    LogViewerPart.this.launchersWatched.add(LogViewerPart.this.rootLauncherWatched);
                }
                if (LogViewerPart.this.launchersWatched != null && !LogViewerPart.this.launchersWatched.isEmpty()) {
                    LogViewerPart.this.selectedLauncherWatchedIndex = 0;
                }
                LogViewerPart.this.refreshPart(launcherListener);
            }

            private void clearWatchedLaunchers(LauncherListener launcherListener2) {
                LogViewerPart.this.selectedLauncherWatchedIndex = -1;
                if (LogViewerPart.this.launchersWatched == null || LogViewerPart.this.launchersWatched.isEmpty()) {
                    return;
                }
                for (IDEObservableLauncher launcherWatched : LogViewerPart.this.launchersWatched) {
                    LogViewerPart.this.rootLauncherWatched.setObserved(false);
                    launcherWatched.removeListener(launcherListener2);
                }
                LogViewerPart.this.launchersWatched.clear();
            }
        }).start();
    }

    private void refreshPart(final LauncherListener launcherListener) {
        this.sync.syncExec(new Runnable(){

            @Override
            public void run() {
                if (LogViewerPart.this.parentComposite.isDisposed()) {
                    return;
                }
                LogViewerPart.this.resetProgressBar();
                if (LogViewerPart.this.isLaunchersWatchedValid()) {
                    IDEObservableLauncher launcherWatched = LogViewerPart.this.getLauncherWatched();
                    LogViewerPart.this.currentRecords.addAll(launcherWatched.getLogRecords());
                    LogViewerPart.this.rootLauncherWatched.setObserved(true);
                    launcherWatched.addListener(launcherListener);
                    LogViewerPart.this.setSelectedConsoleView();
                    LogViewerPart.this.updateProgressBar();
                }
                LogViewerPart.this.createLogViewerControl(LogViewerPart.this.parentComposite);
            }
        });
    }

    @PreDestroy
    public void destroy() {
        this.eventBroker.unsubscribe((EventHandler)this);
    }

    public void handleEvent(Event event) {
        try {
            String topic;
            switch (topic = event.getTopic()) {
                case "JOB/COMPLETED": {
                    this.changeObservedLauncher(event);
                    break;
                }
                case "CONSOLE_LOG/RESET": {
                    this.changeObservedLauncher(event);
                    break;
                }
                case "CONSOLE_LOG/CHANGE_VIEW_TYPE": {
                    this.startChangingLogViewerThread();
                    break;
                }
                case "CONSOLE_LOG/WORD_WRAP": {
                    this.setWrapTxtMessage();
                    break;
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private synchronized void startChangingLogViewerThread() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (LogViewerPart.this.parentComposite == null || LogViewerPart.this.parentComposite.isDisposed()) {
                    return;
                }
                LogViewerPart.this.waitForNotBusy();
                LogViewerPart.this.sync.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).LogViewerPart.this.parentComposite.isDisposed()) {
                            return;
                        }
                        LogViewerPart.this.resetProgressBar();
                        LogViewerPart.this.createLogViewerControl((this).LogViewerPart.this.parentComposite);
                        LogViewerPart.this.updateProgressBar();
                        (this).LogViewerPart.this.parentComposite.layout();
                    }
                });
            }
        }).start();
    }

    private MDirectToolItem getChangingViewToolItem() {
        for (MToolBarElement element : this.fMPart.getToolbar().getChildren()) {
            if (!"com.kms.katalon.composer.execution.directtoolitem.tree".equals(element.getElementId())) continue;
            return (MDirectToolItem)element;
        }
        return null;
    }

    private void waitForNotBusy() {
        while (this.isBusy || this.loadingJob != null && this.loadingJob.getState() == 4) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void setWrapTxtMessage() {
        boolean wrap = this.preferenceStore.getBoolean("log.wordWrap");
        if (this.txtMessage.getListeners(24).length == 0) {
            this.txtMessage.addListener(24, ControlUtils.getAutoHideStyledTextScrollbarListener);
            this.txtMessage.addListener(11, ControlUtils.getAutoHideStyledTextScrollbarListener);
        }
        this.txtMessage.setWordWrap(wrap);
        this.txtMessage.layout();
    }

    private void setSelectedConsoleView() {
        IDEObservableLauncher launcherWatched = this.getLauncherWatched();
        if (launcherWatched == null || launcherWatched.getLaunch() == null) {
            return;
        }
        IDEConsoleManager.openLaunchConsole(launcherWatched.getLaunch());
    }

    private void initLogRecordThrottler() {
        this.throttler = this.buildLogRecordThrottler();
    }

    private Throttler buildLogRecordThrottler() {
        return new Throttler(Display.getCurrent(), Duration.ofMillis(10L), () -> {
            IDEObservableLauncher launcherWatched = this.getLauncherWatched();
            if (launcherWatched == null) {
                return;
            }
            List<XmlLogRecord> logRecords = launcherWatched.getLogRecords();
            if (this.currentRecords.size() >= logRecords.size()) {
                return;
            }
            try {
                List<XmlLogRecord> list = logRecords;
                synchronized (list) {
                    this.addRecords(logRecords.subList(this.currentRecords.size(), logRecords.size()));
                }
            }
            catch (InterruptedException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        });
    }

    public void handleLauncherEvent(LauncherEvent event, LauncherNotifiedObject notifiedObject) {
        IDEObservableLauncher launcherWatched = this.getLauncherWatched();
        switch (event) {
            case UPDATE_RECORD: {
                if (launcherWatched == null || this.loadingLogCanceled) {
                    return;
                }
                this.throttler.throttledExec();
                break;
            }
            case UPDATE_RESULT: 
            case REUPDATE_RESULT: {
                if (launcherWatched == null || !StringUtils.defaultIfEmpty((String)launcherWatched.getId(), (String)"").equals(notifiedObject.getLauncherId())) break;
                this.updateProgressBar();
                break;
            }
        }
    }

    public List<IDEObservableLauncher> getLaunchersWatched() {
        return this.launchersWatched;
    }

    public void changeSelectedLaucherWatchedById(String launcherId) {
        if (StringUtils.isEmpty((String)launcherId)) {
            return;
        }
        int index = 0;
        while (index < this.launchersWatched.size()) {
            IDEObservableLauncher launcherWatched = this.launchersWatched.get(index);
            if (launcherId.equals(launcherWatched.getName()) && index != this.selectedLauncherWatchedIndex) {
                this.selectedLauncherWatchedIndex = index;
                this.currentRecords.clear();
                this.refreshPart(this);
                return;
            }
            ++index;
        }
    }

    private class LogLoadingJob
    extends Job {
        private boolean flushIncompleteRecords;

        public LogLoadingJob(boolean flushIncompleteRecords) {
            super(StringConstants.PA_LOADING_LOGS);
            this.flushIncompleteRecords = false;
            this.flushIncompleteRecords = flushIncompleteRecords;
        }

        public IStatus run(IProgressMonitor monitor) {
            int logSize;
            block3: {
                IStatus iStatus;
                try {
                    LogViewerPart.this.isBusy = true;
                    logSize = LogViewerPart.this.currentRecords.size();
                    monitor.beginTask(StringConstants.PA_LOADING_LOGS + "...", logSize);
                    LogViewerPart.this.sync.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ((LogLoadingJob)LogLoadingJob.this).LogViewerPart.this.compositeTreeContainer.setRedraw(false);
                            LogViewerPart.this.getChangingViewToolItem().setEnabled(false);
                        }
                    });
                    if (!monitor.isCanceled()) break block3;
                    LogViewerPart.this.loadingLogCanceled = true;
                    iStatus = Status.CANCEL_STATUS;
                }
                catch (Throwable throwable) {
                    LogViewerPart.this.sync.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ((LogLoadingJob)LogLoadingJob.this).LogViewerPart.this.compositeTreeContainer.setRedraw(true);
                            LogViewerPart.this.getChangingViewToolItem().setEnabled(true);
                        }
                    });
                    monitor.done();
                    LogViewerPart.this.isBusy = false;
                    throw throwable;
                }
                LogViewerPart.this.sync.syncExec(new /* invalid duplicate definition of identical inner class */);
                monitor.done();
                LogViewerPart.this.isBusy = false;
                return iStatus;
            }
            LogViewerPart.this.treeViewer.setItems(new ExecutedTestEntity[]{LogViewerPart.this.recordMapper.mapTheWholeLogRecords(LogViewerPart.this.currentRecords, this.flushIncompleteRecords)});
            monitor.worked(logSize);
            IStatus iStatus = Status.OK_STATUS;
            LogViewerPart.this.sync.syncExec(new /* invalid duplicate definition of identical inner class */);
            monitor.done();
            LogViewerPart.this.isBusy = false;
            return iStatus;
        }
    }

    private static interface UnsafeRunnable {
        public void run() throws Throwable;
    }
}

