/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractExecutionSettingPage
extends PreferencePageWithHelp {
    public static final short TIMEOUT_MIN_VALUE_IN_SEC = 1;
    public static final short TIMEOUT_MAX_VALUE_IN_SEC = 9999;
    public static final short TIMEOUT_MIN_VALUE_IN_MILISEC = 0;
    public static final int TIMEOUT_MAX_VALUE_IN_MILISEC = 9999999;
    public static final short DELAY_MIN_VALUE_IN_SEC = 0;
    public static final short DELAY_MAX_VALUE_IN_SEC = 9999;
    public static final short DELAY_MIN_VALUE_IN_MILISEC = 0;
    public static final int DELAY_MAX_VALUE_IN_MILISEC = 9999999;
    protected static final String[] ENABLE_DISABLE_ITEMS = new String[]{GlobalStringConstants.ENABLED, GlobalStringConstants.DISABLED};
    protected static final int INPUT_WIDTH = 60;
    protected Composite container;

    protected Control createContents(Composite parent) {
        this.container = this.createContainer(parent);
        this.createSettingsArea(this.container);
        try {
            this.initialize();
        }
        catch (IOException error) {
            LoggerSingleton.logError((Throwable)error);
        }
        this.registerListeners();
        return this.container;
    }

    protected Composite createContainer(Composite parent) {
        return (Composite)ComponentBuilder.gridContainer((Composite)parent).gridVerticalSpacing(10).marginRight(10).marginTop(10).marginBottom(10).noFill().build();
    }

    protected void createSettingsArea(Composite containter) {
    }

    protected void registerListeners() {
    }

    protected void initialize() throws IOException {
    }

    protected void addNumberVerification(Text txtInput, int min, int max) {
        this.addNumberVerification(txtInput, min, max, false, min);
    }

    protected void addNumberVerification(Text txtInput, int min, int max, boolean canBeBlank) {
        this.addNumberVerification(txtInput, min, max, canBeBlank, min);
    }

    protected void addNumberVerification(Text txtInput, int min, int max, boolean canBeBlank, int defaultValue) {
        this.addNumberVerification(txtInput, min, max, canBeBlank, String.valueOf(defaultValue));
    }

    protected void addNumberVerification(final Text txtInput, final int min, final int max, final boolean canBeBlank, final String defaultValue) {
        if (txtInput == null || txtInput.isDisposed()) {
            return;
        }
        txtInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AbstractExecutionSettingPage.this.handleInputChanged((Control)txtInput, event);
            }
        });
        txtInput.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String oldValue = ((Text)event.getSource()).getText();
                String enterValue = event.text;
                String newValue = oldValue.substring(0, event.start) + enterValue + oldValue.substring(event.end);
                if (StringUtils.isBlank((CharSequence)newValue)) {
                    event.doit = true;
                    return;
                }
                if (newValue.equals("-")) {
                    event.doit = true;
                    return;
                }
                if (!newValue.matches("-?\\d+")) {
                    event.doit = false;
                    return;
                }
                try {
                    int val = Integer.parseInt(newValue);
                    event.doit = val >= min && val <= max;
                }
                catch (NumberFormatException numberFormatException) {
                    event.doit = false;
                }
            }
        });
        txtInput.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                ((Text)event.getSource()).selectAll();
            }

            public void focusLost(FocusEvent event) {
                Text inputField = (Text)event.getSource();
                String value = inputField.getText();
                if (value.equals("-")) {
                    inputField.setText(defaultValue);
                }
                if (!canBeBlank && StringUtils.isBlank((CharSequence)value)) {
                    inputField.setText(String.valueOf(defaultValue));
                }
            }
        });
        txtInput.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                ((Text)event.getSource()).selectAll();
            }
        });
    }

    protected void addButtonDefaultSelectionListener(Button button) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExecutionSettingPage.this.updateApplyButton();
            }
        });
    }

    protected void handleInputChanged(Control input, ModifyEvent event) {
        this.updateApplyButton();
    }

    protected void applyDialogFont(Composite composite) {
        super.applyDialogFont(composite);
        this.handlePageLoad();
    }

    protected void handlePageLoad() {
        this.updateApplyButton();
    }

    protected void performDefaults() {
        try {
            this.resetSettings();
        }
        catch (Exception error) {
            this.handleError(error);
        }
        this.updateApplyButton();
    }

    protected void performApply() {
        this.performOk();
        this.updateApplyButton();
    }

    public boolean performOk() {
        try {
            if (this.isValid()) {
                this.saveSettings();
            }
            return true;
        }
        catch (Exception error) {
            this.handleError(error);
            return false;
        }
    }

    protected boolean saveSettings() throws Exception {
        return this.isValid();
    }

    protected void resetSettings() throws Exception {
    }

    protected void handleError(Throwable error) {
        LoggerSingleton.logError((Throwable)error);
        MultiStatusErrorDialog.showErrorDialog((Throwable)error, (String)ComposerExecutionMessageConstants.PAGE_ERROR_MSG_UNABLE_TO_UPDATE_SETTINGS, (String)error.getMessage());
    }

    protected void updateApplyButton() {
        Button applyButton = this.getApplyButton();
        if (applyButton != null && !applyButton.isDisposed()) {
            applyButton.setEnabled(this.hasChanged());
        }
    }

    public boolean isValid() {
        return super.isValid() && this.container != null;
    }

    protected boolean hasChanged() {
        return true;
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_EXECUTION;
    }
}

