/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.settings.AbstractExecutionSettingPage;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.execution.setting.WebUiExecutionSettingStore;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.collections.Pair;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class WebUIExecutionSettingPage
extends AbstractExecutionSettingPage {
    private WebUiExecutionSettingStore webUISettingStore;
    private ExecutionDefaultSettingStore defaultSettingStore = ExecutionDefaultSettingStore.getStore();
    private Combo cbDefaultSmartWait;
    private Combo cbDefaultTimeCapsule;
    private Combo cbDefaultSmartLocator;
    private Text txtDefaultPageLoadTimeout;
    private Text txtActionDelayInSecond;
    private Text txtActionDelayInMilisecond;
    private Text txtDefaultElementTimeout;
    private Text txtDefaultIEHangTimeout;
    private Button chckIgnorePageLoadTimeoutException;
    private Composite usePageLoadTimeoutGroup;
    private Composite actionDelayUnitGroup;
    private Button flutterAppTestingCheckbox;
    private Button canvasTextExtractionCheckbox;
    private Button closedShadowDOMTestingCheckbox;
    private Button enhancedWaitingCheckbox;

    public WebUIExecutionSettingPage() {
        this.webUISettingStore = WebUiExecutionSettingStore.getStore();
    }

    @Override
    protected void createSettingsArea(Composite container) {
        this.createCommonSettingGroup(container);
        this.createDefaultPageLoadTimeoutGroup(container);
        this.createDelayBetweenActionsGroup(container);
        this.createSmartWebInpsectionGroup(container);
        this.createSmartWaitSettingSection(container);
    }

    private void createSmartWaitSettingSection(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).gridVerticalSpacing(10).gridHorizontalSpacing(10).build();
        this.enhancedWaitingCheckbox = (Button)ComponentBuilder.checkBox((Composite)container).text("Use Enhanced Waiting && Checking").build();
        ComponentBuilder.helpButton((Composite)container, (String)DocumentationMessageConstants.ENHANCED_SMART_WAIT).build();
    }

    private void createCommonSettingGroup(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).gridVerticalSpacing(10).gridHorizontalSpacing(10).fillHorizontal().build();
        ComponentBuilder.label((Composite)container).text(ComposerExecutionMessageConstants.PREF_WEBUI_LBL_DEFAULT_SMART_WAIT).build();
        this.cbDefaultSmartWait = (Combo)ComponentBuilder.comboBox((Composite)container, (int)8).width(120).options(ENABLE_DISABLE_ITEMS).build();
        ComponentBuilder.label((Composite)container).text(ComposerExecutionMessageConstants.PREF_WEBUI_LBL_DEFAULT_SMART_LOCATOR).build();
        this.cbDefaultSmartLocator = (Combo)ComponentBuilder.comboBox((Composite)container, (int)8).width(120).options(ENABLE_DISABLE_ITEMS).build();
        ComponentBuilder.label((Composite)container).text(ComposerExecutionMessageConstants.PREF_WEBUI_LBL_DEFAULT_TIME_CAPSULE).build();
        this.cbDefaultTimeCapsule = (Combo)ComponentBuilder.comboBox((Composite)container, (int)8).width(120).options(ENABLE_DISABLE_ITEMS).build();
        ComponentBuilder.label((Composite)container).text(StringConstants.PREF_LBL_DEFAULT_IMPLICIT_TIMEOUT).build();
        this.txtDefaultElementTimeout = (Text)ComponentBuilder.text((Composite)container, (int)2048).width(136).build();
        ComponentBuilder.label((Composite)container).text(ComposerExecutionMessageConstants.PREF_LBL_DEFAULT_WAIT_FOR_IE_HANGING_TIMEOUT).build();
        this.txtDefaultIEHangTimeout = (Text)ComponentBuilder.text((Composite)container, (int)2048).width(136).build();
    }

    private void createDefaultPageLoadTimeoutGroup(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().build();
        ComponentBuilder.label((Composite)container).text(ComposerExecutionMessageConstants.PREF_LBL_DEFAULT_PAGE_LOAD_TIMEOUT).build();
        this.usePageLoadTimeoutGroup = (Composite)ComponentBuilder.group((Composite)container).gridLayout(2).onOptionChange((control, option) -> this.updateButtons()).fillHorizontal().build();
        ComponentBuilder.radio((Composite)this.usePageLoadTimeoutGroup).text(ComposerExecutionMessageConstants.PREF_LBL_ENABLE_DEFAULT_PAGE_LOAD_TIMEOUT).data((Object)false).colSpan(2).build();
        ComponentBuilder.radio((Composite)this.usePageLoadTimeoutGroup).text(ComposerExecutionMessageConstants.PREF_LBL_CUSTOM_PAGE_LOAD_TIMEOUT).data((Object)true).build();
        this.txtDefaultPageLoadTimeout = (Text)ComponentBuilder.text((Composite)this.usePageLoadTimeoutGroup, (int)2048).width(60).build();
        this.chckIgnorePageLoadTimeoutException = (Button)ComponentBuilder.checkBox((Composite)this.usePageLoadTimeoutGroup).text(ComposerExecutionMessageConstants.PREF_LBL_IGNORE_DEFAULT_PAGE_LOAD_TIMEOUT_EXCEPTION).groupIndent().colSpan(2).build();
    }

    private void createDelayBetweenActionsGroup(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().build();
        ComponentBuilder.label((Composite)container).text(ComposerExecutionMessageConstants.LBL_ACTION_DELAY).marginTop(10).build();
        this.actionDelayUnitGroup = (Composite)ComponentBuilder.group((Composite)container).gridLayout(2).onOptionChange((control, option) -> this.updateButtons()).fillHorizontal().build();
        ComponentBuilder.radio((Composite)this.actionDelayUnitGroup).text(ComposerExecutionMessageConstants.PREF_LBL_ACTION_DELAY_IN_SECONDS).data((Object)true).build();
        this.txtActionDelayInSecond = (Text)ComponentBuilder.text((Composite)this.actionDelayUnitGroup, (int)2048).placeholder("Ex: 1").width(60).build();
        ComponentBuilder.radio((Composite)this.actionDelayUnitGroup).text(ComposerExecutionMessageConstants.PREF_LBL_ACTION_DELAY_IN_MILISECONDS).data((Object)false).build();
        this.txtActionDelayInMilisecond = (Text)ComponentBuilder.text((Composite)this.actionDelayUnitGroup, (int)2048).placeholder("Ex: 100").width(60).build();
    }

    private void createSmartWebInpsectionGroup(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().build();
        ComponentBuilder.label((Composite)container).text("Enable smart web inspectors").marginTop(10).build();
        Group group = (Group)ComponentBuilder.group((Composite)container).gridLayout().fillHorizontal().build();
        this.flutterAppTestingCheckbox = (Button)ComponentBuilder.checkBox((Composite)group).text("Flutter web app").build();
        this.canvasTextExtractionCheckbox = (Button)ComponentBuilder.checkBox((Composite)group).text("Canvas text extraction").build();
        this.closedShadowDOMTestingCheckbox = (Button)ComponentBuilder.checkBox((Composite)group).text("Closed Shadow DOM").build();
        Composite infoLine = (Composite)ComponentBuilder.gridContainer((Composite)group, (int)2).build();
        ComponentBuilder.link((Composite)infoLine).text("*Available for Chrome and Edge Chromium. Recommend when using " + ComponentUtil.wrapLink((String)"Recorder Plus", (String)DocumentationMessageConstants.SMART_WEB_INSPECTORS)).applyInfoMessageStyle().build();
        ComponentBuilder.helpButton((Composite)infoLine, (String)DocumentationMessageConstants.SMART_WEB_INSPECTORS);
    }

    protected void updateButtons() {
        boolean usePageLoadTimeout = (Boolean)ComponentUtil.getRadioOption((Composite)this.usePageLoadTimeoutGroup);
        this.txtDefaultPageLoadTimeout.setEnabled(usePageLoadTimeout);
        this.chckIgnorePageLoadTimeoutException.setEnabled(usePageLoadTimeout);
        boolean useSecondUnit = (Boolean)ComponentUtil.getRadioOption((Composite)this.actionDelayUnitGroup);
        this.txtActionDelayInSecond.setEnabled(useSecondUnit);
        this.txtActionDelayInMilisecond.setEnabled(!useSecondUnit);
    }

    @Override
    protected void registerListeners() {
        this.addNumberVerification(this.txtActionDelayInSecond, 1, 9999);
        this.addNumberVerification(this.txtActionDelayInMilisecond, 0, 9999999);
        this.addNumberVerification(this.txtDefaultElementTimeout, 1, 9999);
        this.addNumberVerification(this.txtDefaultIEHangTimeout, 1, 9999);
        this.addNumberVerification(this.txtDefaultPageLoadTimeout, 1, 9999);
    }

    @Override
    protected void initialize() throws IOException {
        Boolean selectedSmartWaitMode = this.defaultSettingStore.getDefaultSmartWaitMode();
        Boolean selectedTimeCapsuleMode = this.webUISettingStore.getTimeCapsuleEnabled();
        Boolean selectedSmartLocatorMode = this.defaultSettingStore.getDefaultSmartLocatorEnabled();
        boolean isEnhancedWaitingEnabled = this.defaultSettingStore.getEnhancedWaitingEnabled();
        this.cbDefaultSmartWait.select(selectedSmartWaitMode != false ? 0 : 1);
        this.cbDefaultTimeCapsule.select(selectedTimeCapsuleMode != false ? 0 : 1);
        this.cbDefaultSmartLocator.select(selectedSmartLocatorMode != false ? 0 : 1);
        this.enhancedWaitingCheckbox.setSelection(isEnhancedWaitingEnabled);
        Boolean usePageLoadTimeout = this.webUISettingStore.getEnablePageLoadTimeout();
        ComponentUtil.setRadioOption((Composite)this.usePageLoadTimeoutGroup, (Object)usePageLoadTimeout);
        this.txtDefaultPageLoadTimeout.setText(String.valueOf(this.webUISettingStore.getPageLoadTimeout()));
        this.chckIgnorePageLoadTimeoutException.setSelection(this.webUISettingStore.getIgnorePageLoadTimeout());
        boolean useSecondUnit = this.webUISettingStore.getUseDelayActionTimeUnit().equals((Object)TimeUnit.SECONDS);
        ComponentUtil.setRadioOption((Composite)this.actionDelayUnitGroup, (Object)useSecondUnit);
        if (useSecondUnit) {
            this.txtActionDelayInSecond.setText(String.valueOf(this.webUISettingStore.getActionDelay()));
        } else {
            this.txtActionDelayInMilisecond.setText(String.valueOf(this.webUISettingStore.getActionDelay()));
        }
        int timeout = this.webUISettingStore.safelyGetElementTimeout();
        this.txtDefaultElementTimeout.setText(Integer.toString(timeout));
        this.txtDefaultIEHangTimeout.setText(Integer.toString(this.webUISettingStore.getIEHangTimeout()));
        this.flutterAppTestingCheckbox.setSelection(this.webUISettingStore.isEnableFlutterAppTesting());
        this.canvasTextExtractionCheckbox.setSelection(this.webUISettingStore.isEnableCanvasTextExtraction());
        this.closedShadowDOMTestingCheckbox.setSelection(this.webUISettingStore.isEnableClosedShadowDOMTesting());
        this.updateButtons();
    }

    @Override
    protected void resetSettings() throws Exception {
        this.cbDefaultSmartWait.select(0);
        this.cbDefaultTimeCapsule.select(0);
        this.cbDefaultSmartLocator.select(0);
        this.enhancedWaitingCheckbox.setSelection(true);
        ComponentUtil.setRadioOption((Composite)this.usePageLoadTimeoutGroup, (Object)false);
        this.txtDefaultPageLoadTimeout.setText(String.valueOf(30));
        this.chckIgnorePageLoadTimeoutException.setSelection(false);
        this.txtActionDelayInSecond.setText(String.valueOf(0));
        this.txtDefaultElementTimeout.setText(String.valueOf(10));
        this.txtDefaultIEHangTimeout.setText(String.valueOf(600));
        this.txtActionDelayInSecond.setText(String.valueOf(0));
        this.txtActionDelayInMilisecond.setText(String.valueOf(0));
        this.webUISettingStore.setDefaultCapturedTestObjectAttributeLocators();
        this.webUISettingStore.setDefaultRecorderExclusionPattern();
        this.webUISettingStore.setDefaultCapturedTestObjectXpathLocators();
        this.webUISettingStore.setDefaultCapturedTestObjectSelectorMethods();
        this.flutterAppTestingCheckbox.setSelection(false);
        this.canvasTextExtractionCheckbox.setSelection(false);
        this.closedShadowDOMTestingCheckbox.setSelection(false);
        this.updateButtons();
    }

    @Override
    protected boolean saveSettings() throws Exception {
        this.defaultSettingStore.setDefaultSmartWaitMode(this.cbDefaultSmartWait.getSelectionIndex() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false));
        Trackings.trackSmartWaitConfiguration((boolean)this.defaultSettingStore.getDefaultSmartWaitMode());
        this.defaultSettingStore.setEnhancedWaitingEnabled(this.enhancedWaitingCheckbox.getSelection());
        this.webUISettingStore.setEnableTimeCapsule((this.cbDefaultTimeCapsule.getSelectionIndex() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false)).booleanValue());
        boolean enableSmartWait = this.cbDefaultSmartLocator.getSelectionIndex() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.defaultSettingStore.setEnableDefaultSmartLocator(enableSmartWait);
        List mePairs = this.webUISettingStore.getMethodsPriorityOrder();
        for (Pair pair : mePairs) {
            if (pair.getLeft() != SelectorMethod.SMART_LOCATOR) continue;
            pair.setRight((Object)enableSmartWait);
            break;
        }
        this.webUISettingStore.setMethodsPritorityOrder(mePairs);
        this.webUISettingStore.setElementTimeout(Integer.parseInt(this.txtDefaultElementTimeout.getText()));
        this.webUISettingStore.setIEHangTimeout(Integer.parseInt(this.txtDefaultIEHangTimeout.getText()));
        this.webUISettingStore.setEnablePageLoadTimeout(((Boolean)ComponentUtil.getRadioOption((Composite)this.usePageLoadTimeoutGroup)).booleanValue());
        this.webUISettingStore.setPageLoadTimeout(Integer.parseInt(this.txtDefaultPageLoadTimeout.getText()));
        this.webUISettingStore.setIgnorePageLoadTimeout(this.chckIgnorePageLoadTimeoutException.getSelection());
        TimeUnit chosenTimeUnit = null;
        String secText = this.txtActionDelayInSecond.getText();
        String milisecText = this.txtActionDelayInMilisecond.getText();
        secText = "".equals(secText) ? String.valueOf(0) : secText;
        milisecText = "".equals(milisecText) ? String.valueOf(0) : milisecText;
        boolean useSecondUnit = (Boolean)ComponentUtil.getRadioOption((Composite)this.actionDelayUnitGroup);
        chosenTimeUnit = useSecondUnit ? TimeUnit.SECONDS : TimeUnit.MILLISECONDS;
        this.webUISettingStore.setUseDelayActionTimeUnit(chosenTimeUnit);
        this.webUISettingStore.setActionDelay(Integer.parseInt(chosenTimeUnit.equals((Object)TimeUnit.SECONDS) ? secText : milisecText));
        this.webUISettingStore.setEnableFlutterAppTesting(this.flutterAppTestingCheckbox.getSelection());
        this.webUISettingStore.setEnableCanvasTextExtraction(this.canvasTextExtractionCheckbox.getSelection());
        this.webUISettingStore.setEnableClosedShadowDOMTesting(this.closedShadowDOMTestingCheckbox.getSelection());
        return true;
    }
}

