/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.execution.components.KeywordsSelectionComposite;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.settings.AbstractExecutionSettingPage;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.execution.setting.WindowsExecutionSettingStore;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class WindowsExecutionSettingPage
extends AbstractExecutionSettingPage {
    private WindowsExecutionSettingStore settingStore = WindowsExecutionSettingStore.getStore();
    private Text txtDefaultElementTimeout;
    private Text txtActionDelayInMillis;
    private KeywordsSelectionComposite actionDelayAffectedKeywordsSelector;

    @Override
    protected void createSettingsArea(Composite container) {
        this.createDefaultElementTimeoutGroup(container);
    }

    private void createDefaultElementTimeoutGroup(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).gridVerticalSpacing(10).gridHorizontalSpacing(10).fillHorizontal().build();
        ComponentBuilder.label((Composite)container).text(StringConstants.PREF_LBL_DEFAULT_IMPLICIT_TIMEOUT).build();
        this.txtDefaultElementTimeout = (Text)ComponentBuilder.text((Composite)container, (int)2048).width(60).build();
        ComponentBuilder.label((Composite)container).text(StringConstants.PREF_LBL_DELAY_BETWEEN_ACTIONS_MILLISECS).build();
        this.txtActionDelayInMillis = (Text)ComponentBuilder.text((Composite)container, (int)2048).width(60).build();
        Composite keywordsContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().build();
        this.actionDelayAffectedKeywordsSelector = new KeywordsSelectionComposite(keywordsContainer, 0, new KeywordsSelectionComposite.KeywordsSelectionModel());
        this.actionDelayAffectedKeywordsSelector.setLayoutData(new GridData(4, 4, true, true));
    }

    @Override
    protected void registerListeners() {
        this.addNumberVerification(this.txtDefaultElementTimeout, 1, 9999);
        this.addNumberVerification(this.txtActionDelayInMillis, 0, 9999999);
    }

    @Override
    protected void initialize() throws IOException {
        this.txtDefaultElementTimeout.setText(Integer.toString(this.settingStore.getElementTimeout()));
        this.txtActionDelayInMillis.setText(Integer.toString(this.settingStore.getActionDelayInMillis()));
        KeywordsSelectionComposite.KeywordsSelectionModel model = new KeywordsSelectionComposite.KeywordsSelectionModel(this.getAllWindowsKeywords(), Arrays.asList(WindowsExecutionSettingStore.DEFAULT_ACTION_DELAY_AFFECTED_KEYWORDS), this.settingStore.getActionDelayAffectedKeywords());
        this.actionDelayAffectedKeywordsSelector.setModel(model);
    }

    @Override
    protected void resetSettings() throws Exception {
        this.txtDefaultElementTimeout.setText(Integer.toString(60));
        this.txtActionDelayInMillis.setText(Integer.toString(0));
        KeywordsSelectionComposite.KeywordsSelectionModel defaultModel = new KeywordsSelectionComposite.KeywordsSelectionModel(this.getAllWindowsKeywords(), Arrays.asList(WindowsExecutionSettingStore.DEFAULT_ACTION_DELAY_AFFECTED_KEYWORDS), Arrays.asList(WindowsExecutionSettingStore.DEFAULT_ACTION_DELAY_AFFECTED_KEYWORDS));
        this.actionDelayAffectedKeywordsSelector.setModel(defaultModel);
    }

    @Override
    protected boolean saveSettings() throws Exception {
        this.settingStore.setElementTimeout(Integer.parseInt(this.txtDefaultElementTimeout.getText()));
        this.settingStore.setActionDelayInMillis(Integer.parseInt(this.txtActionDelayInMillis.getText()));
        if (!this.actionDelayAffectedKeywordsSelector.getKeywords().equals(this.settingStore.getActionDelayAffectedKeywords())) {
            this.settingStore.setActionDelayAffectedKeywords(this.actionDelayAffectedKeywordsSelector.getKeywords());
        }
        return true;
    }

    private String[] getAllWindowsKeywords() {
        return KeywordController.getInstance().getBuiltInKeywords("WindowsBuiltinKeywords", true).stream().map(v -> v.getName()).collect(Collectors.toList()).toArray(new String[0]);
    }
}

