/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.trace;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.components.services.PartServiceSingleton;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.logging.XmlLogRecordException;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.execution.logging.LogExceptionFilter;
import com.kms.katalon.groovy.util.GroovyUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class LogExceptionNavigator {
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private EModelService modelService = ModelServiceSingleton.getInstance().getModelService();
    private MApplication application = ApplicationSingleton.getInstance().getApplication();
    private EPartService partService = PartServiceSingleton.getInstance().getPartService();

    public TestCaseCompositePart openTestCaseComposite(TestCaseEntity testCase) {
        MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        if (stack == null) {
            return null;
        }
        String testCaseCompositePartId = EntityPartUtil.getTestCaseCompositePartId((String)testCase.getId());
        MCompositePart mcompositePart = (MCompositePart)this.modelService.find(testCaseCompositePartId, (MUIElement)stack);
        if (mcompositePart == null) {
            this.eventBroker.send("TESTCASE/OPEN", (Object)testCase);
            mcompositePart = (MCompositePart)this.modelService.find(testCaseCompositePartId, (MUIElement)stack);
        }
        this.partService.showPart((MPart)mcompositePart, EPartService.PartState.ACTIVATE);
        TestCaseCompositePart testCaseCompositePart = (TestCaseCompositePart)mcompositePart.getObject();
        return testCaseCompositePart;
    }

    public MPart getTestCaseGroovyEditor(TestCaseEntity testCase) {
        TestCaseCompositePart testCaseCompositePart = this.openTestCaseComposite(testCase);
        if (testCaseCompositePart == null) {
            return null;
        }
        testCaseCompositePart.setSelectedPart(testCaseCompositePart.getChildCompatibilityPart());
        MPart groovyEditor = testCaseCompositePart.getChildCompatibilityPart();
        return groovyEditor;
    }

    public void openTestCaseByLogException(XmlLogRecordException logException) {
        block5: {
            try {
                TestCaseEntity testCase = LogExceptionFilter.getTestCaseByLogException((XmlLogRecordException)logException);
                if (testCase == null) {
                    MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)StringConstants.TRACE_WARN_MSG_TEST_CASE_NOT_FOUND);
                    return;
                }
                this.eventBroker.send("TESTCASE/OPEN", (Object)testCase);
                MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
                if (stack == null) break block5;
                String testCaseCompositePartId = EntityPartUtil.getTestCaseCompositePartId((String)testCase.getId());
                MCompositePart mcompositePart = (MCompositePart)this.modelService.find(testCaseCompositePartId, (MUIElement)stack);
                TestCaseCompositePart testCaseCompositePart = (TestCaseCompositePart)mcompositePart.getObject();
                testCaseCompositePart.setSelectedPart(testCaseCompositePart.getChildCompatibilityPart());
                CompatibilityEditor groovyEditor = (CompatibilityEditor)testCaseCompositePart.getChildCompatibilityPart().getObject();
                AbstractTextEditor editor = (AbstractTextEditor)groovyEditor.getEditor();
                try {
                    IDocument document = editor.getDocumentProvider().getDocument((Object)groovyEditor.getEditor().getEditorInput());
                    editor.selectAndReveal(document.getLineOffset(logException.getLineNumber() - 1), document.getLineLength(logException.getLineNumber() - 1));
                }
                catch (Exception exception) {
                    MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)("Line " + Integer.toString(logException.getLineNumber()) + StringConstants.TRACE_WARN_MSG_NOT_FOUND));
                    return;
                }
            }
            catch (Exception e) {
                MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)StringConstants.TRACE_WARN_MSG_UNABLE_TO_OPEN_TEST_CASE);
                LoggerSingleton.getInstance().getLogger().error((Throwable)e);
            }
        }
    }

    public void openKeywordByLogException(XmlLogRecordException logException) {
        try {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            IFolder keywordRootFolder = GroovyUtil.getCustomKeywordSourceFolder((ProjectEntity)project);
            String fullClassName = logException.getClassName();
            int classIndex = fullClassName.lastIndexOf(".");
            String className = fullClassName;
            IFile customKeywordScriptFile = null;
            if (classIndex > 0) {
                String packageName = fullClassName.substring(0, classIndex);
                className = fullClassName.substring(classIndex + 1, fullClassName.length());
                IFolder keywordPackageFolder = keywordRootFolder.getFolder(packageName.replace(".", "/"));
                customKeywordScriptFile = keywordPackageFolder.getFile(className + ".groovy");
            } else {
                className = fullClassName;
                customKeywordScriptFile = keywordRootFolder.getFile(className + ".groovy");
            }
            if (customKeywordScriptFile != null) {
                AbstractTextEditor editor = (AbstractTextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)customKeywordScriptFile);
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                editor.selectAndReveal(document.getLineOffset(logException.getLineNumber() - 1), document.getLineLength(logException.getLineNumber() - 1));
            }
        }
        catch (Exception exception) {
            MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)StringConstants.TRACE_WARN_MSG_UNABLE_TO_OPEN_KEYWORD_FILE);
        }
    }
}

