/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.handlers;

import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.AbstractDeleteReferredEntityHandler;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.dialogs.TestSuiteReferencesDialog;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeleteTestSuiteHandler
extends AbstractDeleteReferredEntityHandler {
    private static TestSuiteController testSuiteController = TestSuiteController.getInstance();

    public Class<? extends ITreeEntity> entityType() {
        return TestSuiteTreeEntity.class;
    }

    public boolean execute(ITreeEntity treeEntity, IProgressMonitor monitor) {
        try {
            if (treeEntity == null || !(treeEntity instanceof TestSuiteTreeEntity)) {
                return false;
            }
            String taskName = "Deleting " + treeEntity.getTypeName() + " '" + treeEntity.getText() + "'...";
            monitor.beginTask(taskName, 1);
            TestSuiteEntity testSuite = (TestSuiteEntity)treeEntity.getObject();
            this.performDeleteTestSuite(testSuite);
            this.eventBroker.post("EXPLORER/DELETED_SELECTED_ITEM", (Object)testSuite.getIdForDisplay());
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)ComposerTestsuiteMessageConstants.HAND_ERROR_MSG_UNABLE_TO_DEL_TEST_SUITE);
            return false;
        }
        finally {
            monitor.done();
        }
    }

    protected boolean performDeleteTestSuite(TestSuiteEntity testSuite) throws Exception {
        if (testSuite == null) {
            return false;
        }
        if (!this.isDeleteReferenceConfirmed(testSuite)) {
            return false;
        }
        UISynchronizeService.syncExec(() -> EntityPartUtil.closePart((IEntity)testSuite));
        testSuiteController.deleteTestSuite(testSuite);
        return true;
    }

    private boolean isDeleteReferenceConfirmed(final TestSuiteEntity testSuite) throws DALException {
        final List affectedTestSuites = testSuiteController.getTestSuiteCollectionReferences(testSuite);
        if (affectedTestSuites.isEmpty()) {
            return true;
        }
        if (this.isDefaultResponse()) {
            this.sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    TestSuiteReferencesDialog dialog = new TestSuiteReferencesDialog(DeleteTestSuiteHandler.this.getActiveShell(), testSuite.getIdForDisplay(), affectedTestSuites, DeleteTestSuiteHandler.this.needYesNoToAllButtons());
                    DeleteTestSuiteHandler.this.setResponse(dialog.open());
                }
            });
        }
        if (this.isCancelResponse()) {
            return false;
        }
        if (this.isYesResponse()) {
            testSuiteController.removeTestSuiteCollectionReferences(testSuite, affectedTestSuites);
        }
        return true;
    }

    private Shell getActiveShell() {
        return Display.getCurrent().getActiveShell();
    }
}

