/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.handlers;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.dialogs.NewTestSuiteDialog;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NewTestSuiteHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private FolderTreeEntity testSuiteTreeRoot;
    private String newDefaultName = ComposerTestsuiteMessageConstants.HAND_DEFAULT_NAME_NEW_TEST_SUITE;
    private String getNameTestSuite = "";
    private int DEFAULT_NUM_RETRIES = 3;

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        try {
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            ITreeEntity parentTreeEntity = NewTestSuiteHandler.findParentTreeEntity(selectedObjects);
            if (parentTreeEntity == null) {
                if (this.testSuiteTreeRoot == null) {
                    return;
                }
                parentTreeEntity = this.testSuiteTreeRoot;
            }
            if (parentTreeEntity == null) {
                return;
            }
            FolderEntity parentFolderEntity = (FolderEntity)parentTreeEntity.getObject();
            TestSuiteController tsController = TestSuiteController.getInstance();
            if (parentFolderEntity.getFolderType() == FolderEntity.FolderType.TESTSUITE && !this.featureController.isQuotaUnlimited(ProductFeature.TEST_SUITE_CREATIONS_LIMIT)) {
                try {
                    ProjectEntity currentProject = parentFolderEntity.getProject();
                    List tsList = tsController.getAllTestSuites(currentProject);
                    if (this.featureController.isLimitReached(ProductFeature.TEST_SUITE_CREATIONS_LIMIT, tsList.size())) {
                        String dialogTitle = ComposerComponentsImplMessageConstants.DIA_KSE_FEATURE_RESTRICT_UNLIMITED_TEST_SUITE_CREATIONS;
                        String dialogMessage = ComposerComponentsImplMessageConstants.MSG_KSE_FEATURE_RESTRICT_UNLIMITED_TEST_SUITE_CREATIONS;
                        this.productFeatureDialog.showNotAvailableFeature(ProductFeature.TEST_SUITE_CREATIONS_LIMIT, dialogTitle, dialogMessage);
                        return;
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    return;
                }
            }
            String suggestedName = tsController.getAvailableTestSuiteName(parentFolderEntity, this.newDefaultName);
            parentShell = ShellManager.getMainShell();
            NewTestSuiteDialog dialog = new NewTestSuiteDialog(parentShell, parentFolderEntity, suggestedName);
            if (dialog.open() != 0) {
                return;
            }
            TestSuiteEntity testSuite = tsController.saveNewTestSuite((TestSuiteEntity)dialog.getEntity());
            if (this.featureController.canUse(ProductFeature.RERUN_IMMEDIATELY)) {
                testSuite.setRerunImmediately(true);
                testSuite.setNumberOfRerun(this.DEFAULT_NUM_RETRIES);
            }
            if (testSuite == null) {
                MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)ComposerTestsuiteMessageConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_TEST_SUITE);
                return;
            }
            Trackings.trackCreatingObject((String)"testSuite", (Object[])new Object[0]);
            UserProfile userProfile = UserProfileHelper.getCurrentProfile();
            userProfile.setDoneCreateFirstTestSuite(true);
            UserProfileHelper.saveProfile((UserProfile)userProfile);
            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new TestSuiteTreeEntity(testSuite, parentTreeEntity));
            this.eventBroker.send("TESTSUITE/OPEN", (Object)testSuite);
            this.getNameTestSuite = testSuite.getId();
        }
        catch (FilePathTooLongException e) {
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)ComposerTestsuiteMessageConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_TEST_SUITE);
        }
    }

    public static ITreeEntity findParentTreeEntity(Object[] selectedObjects) throws Exception {
        if (selectedObjects != null) {
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object entity = objectArray[n2];
                if (entity instanceof ITreeEntity) {
                    Object entityObject = ((ITreeEntity)entity).getObject();
                    if (entityObject instanceof FolderEntity) {
                        FolderEntity folder = (FolderEntity)entityObject;
                        if (folder.getFolderType() == FolderEntity.FolderType.TESTSUITE) {
                            return (ITreeEntity)entity;
                        }
                    } else if (entityObject instanceof TestSuiteEntity) {
                        return ((ITreeEntity)entity).getParent();
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Inject
    @Optional
    private void catchTestSuiteFolderTreeEntitiesRoot(@UIEventTopic(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            for (Object o : treeEntities) {
                FolderEntity folder;
                Object entityObject = ((ITreeEntity)o).getObject();
                if (!(entityObject instanceof FolderEntity) || (folder = (FolderEntity)entityObject).getFolderType() != FolderEntity.FolderType.TESTSUITE) continue;
                this.testSuiteTreeRoot = (FolderTreeEntity)o;
                return;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Inject
    @Optional
    private void execute(@UIEventTopic(value="TESTSUITE/NEW") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        this.execute(Display.getCurrent().getActiveShell());
    }

    @Inject
    @Optional
    private void executeNewAndAdd(@UIEventTopic(value="TESTSUITE_TESTCASE/NEW") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        this.execute(Display.getCurrent().getActiveShell());
        TestCaseEntity testCase = (TestCaseEntity)eventData;
        EventBrokerSingleton.getInstance().getEventBroker().post("ADD_TESTCASE_TESTCASE", (Object)new Object[]{testCase, this.getNameTestSuite});
    }
}

