/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.handlers;

import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.ImageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.parts.FilteringTestSuiteCompositePart;
import com.kms.katalon.composer.testsuite.parts.FilteringTestSuitePart;
import com.kms.katalon.composer.testsuite.parts.TestSuiteAnalyticsPart;
import com.kms.katalon.composer.testsuite.parts.TestSuiteCompositePart;
import com.kms.katalon.composer.testsuite.parts.TestSuiteIntegrationPart;
import com.kms.katalon.composer.testsuite.parts.TestSuitePart;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenTestSuiteHandler {
    private static final String NEW_TEST_SUITE_TPL_LOC = "resources/template/new_test_suite.tpl";
    private static final String DEFAULT_CONTAINER_DATA = ComposerTestsuiteMessageConstants.HAND_DEFAULT_CONTAINER_DATA;
    private static final String TEST_SUITE_BUNDLE_URI = "bundleclass://com.kms.katalon.composer.testsuite/";
    private static final String REPORT_BUNDLE_ID = "bundleclass://com.kms.katalon.composer.report/";
    private static final String TEST_SUITE_MAIN_PART_URI = "bundleclass://com.kms.katalon.composer.testsuite/" + TestSuitePart.class.getName();
    private static final String FILTERING_TEST_SUITE_MAIN_PART_URI = "bundleclass://com.kms.katalon.composer.testsuite/" + FilteringTestSuitePart.class.getName();
    private static final String FILTERING_TEST_SUITE_COMPOSITE_PART_URI = "bundleclass://com.kms.katalon.composer.testsuite/" + FilteringTestSuiteCompositePart.class.getName();
    private static final String TEST_SUITE_COMPOSITE_PART_URI = "bundleclass://com.kms.katalon.composer.testsuite/" + TestSuiteCompositePart.class.getName();
    private static final String TEST_SUITE_INTEGRATION_PART_URI = "bundleclass://com.kms.katalon.composer.testsuite/" + TestSuiteIntegrationPart.class.getName();
    private static final String TEST_SUITE_RESULT_PART_URI = "bundleclass://com.kms.katalon.composer.report/com.kms.katalon.composer.report.parts.ReportPart";
    private static final String TEST_SUITE_ANALYTICS_PART_URI = "bundleclass://com.kms.katalon.composer.testsuite/" + TestSuiteAnalyticsPart.class.getName();
    @Inject
    private MApplication application;
    @Inject
    private EPartService partService;
    @Inject
    private EModelService modelService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IEclipseContext context;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof TestSuiteEntity) {
                    OpenTestSuiteHandler.this.excute((TestSuiteEntity)object);
                }
            }
        });
    }

    @Inject
    @Optional
    private void excute(@UIEventTopic(value="TESTSUITE/OPEN") TestSuiteEntity testSuite) {
        if (testSuite instanceof FilteringTestSuiteEntity) {
            this.openFilteringTestSuiteEntity((FilteringTestSuiteEntity)testSuite);
        } else {
            this.openManualTestSuiteEntity(testSuite);
        }
    }

    private void openFilteringTestSuiteEntity(FilteringTestSuiteEntity testSuite) {
        MCompositePart testSuiteCompositePart = null;
        try {
            if (testSuite != null) {
                if (!this.featureController.canUse(ProductFeature.DYNAMIC_TEST_SUITE)) {
                    this.productFeatureDialog.showNotAvailableFeature(ProductFeature.DYNAMIC_TEST_SUITE);
                    return;
                }
                MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
                if (stack != null) {
                    String testSuiteResultPartId;
                    MPart testSuiteResultPart;
                    String testSuiteIntegrationPartId;
                    MPart testSuiteIntegrationPart;
                    String testSuiteScriptPartId;
                    MPart testSuiteScriptPart;
                    String testSuiteMainPartId;
                    MPart testSuiteMainPart;
                    String subPartStackId;
                    MPartStack subPartStack;
                    String testSuiteCompositePartId = EntityPartUtil.getTestSuiteCompositePartId((String)testSuite.getId());
                    testSuiteCompositePart = (MCompositePart)this.modelService.find(testSuiteCompositePartId, (MUIElement)stack);
                    if (testSuiteCompositePart == null) {
                        testSuiteCompositePart = (MCompositePart)this.modelService.createModelElement(MCompositePart.class);
                        testSuiteCompositePart.setElementId(testSuiteCompositePartId);
                        testSuiteCompositePart.setLabel(testSuite.getName());
                        testSuiteCompositePart.setCloseable(true);
                        testSuiteCompositePart.setContributionURI(FILTERING_TEST_SUITE_COMPOSITE_PART_URI);
                        testSuiteCompositePart.setContainerData(DEFAULT_CONTAINER_DATA);
                        testSuiteCompositePart.setIconURI(ImageConstants.URL_16_FILTERING_TEST_SUITE);
                        testSuiteCompositePart.setObject((Object)testSuite);
                        testSuiteCompositePart.setTooltip(testSuite.getIdForDisplay());
                        stack.getChildren().add(testSuiteCompositePart);
                    }
                    if ((subPartStack = (MPartStack)this.modelService.find(subPartStackId = testSuiteCompositePartId + ".partStack", (MUIElement)testSuiteCompositePart)) == null) {
                        subPartStack = (MPartStack)this.modelService.createModelElement(MPartStack.class);
                        subPartStack.setElementId(subPartStackId);
                        subPartStack.setContainerData(DEFAULT_CONTAINER_DATA);
                        testSuiteCompositePart.getChildren().add(subPartStack);
                    }
                    if ((testSuiteMainPart = (MPart)this.modelService.find(testSuiteMainPartId = testSuiteCompositePartId + ".partStack.testSuitePart", (MUIElement)subPartStack)) == null) {
                        testSuiteMainPart = (MPart)this.modelService.createModelElement(MPart.class);
                        testSuiteMainPart.setElementId(testSuiteMainPartId);
                        testSuiteMainPart.setContributionURI(FILTERING_TEST_SUITE_MAIN_PART_URI);
                        testSuiteMainPart.setContainerData(DEFAULT_CONTAINER_DATA);
                        testSuiteMainPart.getTags().add("NoMove");
                        testSuiteMainPart.setLabel(ComposerTestsuiteMessageConstants.PA_TAB_MAIN);
                        this.context.set(FilteringTestSuiteEntity.class, (Object)testSuite);
                        subPartStack.getChildren().add(testSuiteMainPart);
                    }
                    if ((testSuiteScriptPart = (MPart)this.modelService.find(testSuiteScriptPartId = testSuiteCompositePartId + ".partStack.editor", (MUIElement)subPartStack)) == null) {
                        File scriptFile = TestSuiteController.getInstance().getTestSuiteScriptFile((TestSuiteEntity)testSuite);
                        if (scriptFile == null || !scriptFile.exists()) {
                            scriptFile = this.createTestSuiteScriptFile((TestSuiteEntity)testSuite);
                        }
                        testSuiteScriptPart = GroovyEditorUtil.createEditorPart((ProjectEntity)testSuite.getProject(), (String)PathUtil.absoluteToRelativePath((String)scriptFile.getAbsolutePath(), (String)testSuite.getProject().getFolderLocation()), (EPartService)this.partService);
                        testSuiteScriptPart.setElementId(testSuiteScriptPartId);
                        testSuiteScriptPart.getTags().add("NoMove");
                        testSuiteScriptPart.setLabel(ComposerTestsuiteMessageConstants.PA_TAB_SCRIPT);
                        subPartStack.getChildren().add(testSuiteScriptPart);
                    }
                    if ((testSuiteIntegrationPart = (MPart)this.modelService.find(testSuiteIntegrationPartId = testSuiteCompositePartId + ".partStack.integration", (MUIElement)subPartStack)) == null) {
                        testSuiteIntegrationPart = (MPart)this.modelService.createModelElement(MPart.class);
                        testSuiteIntegrationPart.setElementId(testSuiteIntegrationPartId);
                        testSuiteIntegrationPart.setContributionURI(TEST_SUITE_INTEGRATION_PART_URI);
                        testSuiteIntegrationPart.setContainerData(DEFAULT_CONTAINER_DATA);
                        testSuiteIntegrationPart.getTags().add("NoMove");
                        this.context.set(TestSuiteEntity.class, (Object)testSuite);
                        subPartStack.getChildren().add(testSuiteIntegrationPart);
                    }
                    if ((testSuiteResultPart = (MPart)this.modelService.find(testSuiteResultPartId = testSuiteCompositePartId + ".partStack.result", (MUIElement)subPartStack)) == null) {
                        testSuiteResultPart = (MPart)this.modelService.createModelElement(MPart.class);
                        testSuiteResultPart.setElementId(testSuiteResultPartId);
                        testSuiteResultPart.setContributionURI(TEST_SUITE_RESULT_PART_URI);
                        testSuiteResultPart.setContainerData(DEFAULT_CONTAINER_DATA);
                        testSuiteResultPart.getTags().add("NoMove");
                        subPartStack.getChildren().add(testSuiteResultPart);
                    }
                    this.partService.activate((MPart)testSuiteCompositePart);
                    this.partService.activate(testSuiteMainPart);
                    this.partService.activate(testSuiteScriptPart);
                    this.partService.activate(testSuiteIntegrationPart);
                    ReportEntity report = ReportController.getInstance().getLastRunReportEntity((TestSuiteEntity)testSuite);
                    this.context.set(ReportEntity.class, (Object)report);
                    this.partService.activate(testSuiteResultPart);
                    subPartStack.setSelectedElement((MUIElement)testSuiteMainPart);
                    stack.setSelectedElement((MUIElement)testSuiteCompositePart);
                    FilteringTestSuiteCompositePart testSuiteParentCompositePart = (FilteringTestSuiteCompositePart)testSuiteCompositePart.getObject();
                    testSuiteParentCompositePart.setOriginalTestSuite(testSuite);
                    if (!testSuiteParentCompositePart.isInitialized()) {
                        testSuiteParentCompositePart.initComponent();
                    }
                    Trackings.trackOpenObject((String)"dynamicQueryingTestSuite", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            if (testSuiteCompositePart != null && testSuiteCompositePart.isVisible()) {
                this.partService.hidePart(testSuiteCompositePart, true);
            }
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)ComposerTestsuiteMessageConstants.HAND_ERROR_MSG_CANNOT_OPEN_TEST_SUITE);
        }
    }

    private void openManualTestSuiteEntity(TestSuiteEntity testSuite) {
        MCompositePart testSuiteCompositePart = null;
        try {
            MPartStack stack;
            if (testSuite != null && (stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application)) != null) {
                String testSuiteAnalyticsPartId;
                MPart testSuiteAnalyticsPart;
                String testSuiteResultPartId;
                MPart testSuiteResultPart;
                String testSuiteIntegrationPartId;
                MPart testSuiteIntegrationPart;
                String testSuiteScriptPartId;
                MPart testSuiteScriptPart;
                String testSuiteMainPartId;
                MPart testSuiteMainPart;
                String subPartStackId;
                MPartStack subPartStack;
                String testSuiteCompositePartId = EntityPartUtil.getTestSuiteCompositePartId((String)testSuite.getId());
                testSuiteCompositePart = (MCompositePart)this.modelService.find(testSuiteCompositePartId, (MUIElement)stack);
                if (testSuiteCompositePart == null) {
                    testSuiteCompositePart = (MCompositePart)this.modelService.createModelElement(MCompositePart.class);
                    testSuiteCompositePart.setElementId(testSuiteCompositePartId);
                    testSuiteCompositePart.setLabel(testSuite.getName());
                    testSuiteCompositePart.setCloseable(true);
                    testSuiteCompositePart.setContributionURI(TEST_SUITE_COMPOSITE_PART_URI);
                    testSuiteCompositePart.setContainerData(DEFAULT_CONTAINER_DATA);
                    testSuiteCompositePart.setIconURI(ImageConstants.URL_16_TEST_SUITE);
                    testSuiteCompositePart.setObject((Object)testSuite);
                    testSuiteCompositePart.setTooltip(testSuite.getIdForDisplay());
                    stack.getChildren().add(testSuiteCompositePart);
                }
                if ((subPartStack = (MPartStack)this.modelService.find(subPartStackId = testSuiteCompositePartId + ".partStack", (MUIElement)testSuiteCompositePart)) == null) {
                    subPartStack = (MPartStack)this.modelService.createModelElement(MPartStack.class);
                    subPartStack.setElementId(subPartStackId);
                    subPartStack.setContainerData(DEFAULT_CONTAINER_DATA);
                    testSuiteCompositePart.getChildren().add(subPartStack);
                }
                if ((testSuiteMainPart = (MPart)this.modelService.find(testSuiteMainPartId = testSuiteCompositePartId + ".partStack.testSuitePart", (MUIElement)subPartStack)) == null) {
                    testSuiteMainPart = (MPart)this.modelService.createModelElement(MPart.class);
                    testSuiteMainPart.setElementId(testSuiteMainPartId);
                    testSuiteMainPart.setContributionURI(TEST_SUITE_MAIN_PART_URI);
                    testSuiteMainPart.setContainerData(DEFAULT_CONTAINER_DATA);
                    testSuiteMainPart.getTags().add("NoMove");
                    this.context.set(TestSuiteEntity.class, (Object)testSuite);
                    subPartStack.getChildren().add(testSuiteMainPart);
                }
                if ((testSuiteScriptPart = (MPart)this.modelService.find(testSuiteScriptPartId = testSuiteCompositePartId + ".partStack.editor", (MUIElement)subPartStack)) == null) {
                    File scriptFile = TestSuiteController.getInstance().getTestSuiteScriptFile(testSuite);
                    if (scriptFile == null || !scriptFile.exists()) {
                        scriptFile = this.createTestSuiteScriptFile(testSuite);
                    }
                    testSuiteScriptPart = GroovyEditorUtil.createEditorPart((ProjectEntity)testSuite.getProject(), (String)PathUtil.absoluteToRelativePath((String)scriptFile.getAbsolutePath(), (String)testSuite.getProject().getFolderLocation()), (EPartService)this.partService);
                    testSuiteScriptPart.setElementId(testSuiteScriptPartId);
                    testSuiteScriptPart.getTags().add("NoMove");
                    testSuiteScriptPart.setLabel(ComposerTestsuiteMessageConstants.PA_TAB_SCRIPT);
                    subPartStack.getChildren().add(testSuiteScriptPart);
                }
                if ((testSuiteIntegrationPart = (MPart)this.modelService.find(testSuiteIntegrationPartId = testSuiteCompositePartId + ".partStack.integration", (MUIElement)subPartStack)) == null) {
                    testSuiteIntegrationPart = (MPart)this.modelService.createModelElement(MPart.class);
                    testSuiteIntegrationPart.setElementId(testSuiteIntegrationPartId);
                    testSuiteIntegrationPart.setContributionURI(TEST_SUITE_INTEGRATION_PART_URI);
                    testSuiteIntegrationPart.setContainerData(DEFAULT_CONTAINER_DATA);
                    testSuiteIntegrationPart.getTags().add("NoMove");
                    this.context.set(TestSuiteEntity.class, (Object)testSuite);
                    subPartStack.getChildren().add(testSuiteIntegrationPart);
                }
                if ((testSuiteResultPart = (MPart)this.modelService.find(testSuiteResultPartId = testSuiteCompositePartId + ".partStack.result", (MUIElement)subPartStack)) == null) {
                    testSuiteResultPart = (MPart)this.modelService.createModelElement(MPart.class);
                    testSuiteResultPart.setElementId(testSuiteResultPartId);
                    testSuiteResultPart.setContributionURI(TEST_SUITE_RESULT_PART_URI);
                    testSuiteResultPart.setContainerData(DEFAULT_CONTAINER_DATA);
                    testSuiteResultPart.getTags().add("NoMove");
                    subPartStack.getChildren().add(testSuiteResultPart);
                }
                if ((testSuiteAnalyticsPart = (MPart)this.modelService.find(testSuiteAnalyticsPartId = testSuiteCompositePartId + ".partStack.analytics", (MUIElement)subPartStack)) == null) {
                    testSuiteAnalyticsPart = (MPart)this.modelService.createModelElement(MPart.class);
                    testSuiteAnalyticsPart.setElementId(testSuiteAnalyticsPartId);
                    testSuiteAnalyticsPart.setContributionURI(TEST_SUITE_ANALYTICS_PART_URI);
                    testSuiteAnalyticsPart.setContainerData(DEFAULT_CONTAINER_DATA);
                    testSuiteAnalyticsPart.getTags().add("NoMove");
                    subPartStack.getChildren().add(testSuiteAnalyticsPart);
                }
                this.partService.activate((MPart)testSuiteCompositePart);
                this.partService.activate(testSuiteMainPart);
                this.partService.activate(testSuiteScriptPart);
                this.partService.activate(testSuiteIntegrationPart);
                this.partService.activate(testSuiteAnalyticsPart);
                ReportEntity report = ReportController.getInstance().getLastRunReportEntity(testSuite);
                this.context.set(ReportEntity.class, (Object)report);
                this.partService.activate(testSuiteResultPart);
                subPartStack.setSelectedElement((MUIElement)testSuiteMainPart);
                stack.setSelectedElement((MUIElement)testSuiteCompositePart);
                TestSuiteCompositePart testSuiteParentCompositePart = (TestSuiteCompositePart)testSuiteCompositePart.getObject();
                if (!testSuiteParentCompositePart.isInitialized()) {
                    testSuiteParentCompositePart.initComponent();
                }
                Trackings.trackOpenObject((String)"testSuite", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            if (testSuiteCompositePart != null && testSuiteCompositePart.isVisible()) {
                this.partService.hidePart(testSuiteCompositePart, true);
            }
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)ComposerTestsuiteMessageConstants.HAND_ERROR_MSG_CANNOT_OPEN_TEST_SUITE);
        }
    }

    private File createTestSuiteScriptFile(TestSuiteEntity testSuite) throws DALException, IOException {
        File newTestSuiteScriptFile = TestSuiteController.getInstance().newTestSuiteScriptFile(testSuite);
        FileUtils.writeStringToFile((File)newTestSuiteScriptFile, (String)this.getFileContent(NEW_TEST_SUITE_TPL_LOC), (String)"UTF-8", (boolean)true);
        return newTestSuiteScriptFile;
    }

    private String getFileContent(String filePath) {
        URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(OpenTestSuiteHandler.class), (IPath)new Path(filePath), null);
        try {
            return StringUtils.join((Iterable)IOUtils.readLines((InputStream)new BufferedInputStream(url.openStream())), (String)"\n");
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }
}

