/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RefreshTestSuiteHandler {
    @Inject
    IEventBroker eventBroker;

    @PostConstruct
    public void registerEventHandler(IEventBroker eventBroker) {
        eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                if (ProjectController.getInstance().getCurrentProject() == null) {
                    return;
                }
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof TestSuiteTreeEntity) {
                    try {
                        RefreshTestSuiteHandler.this.excute((TestSuiteTreeEntity)object);
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                }
            }
        });
    }

    private void excute(TestSuiteTreeEntity testSuiteTreeEntity) throws Exception {
        if (testSuiteTreeEntity.getObject() == null) {
            ITreeEntity parentEntity = testSuiteTreeEntity.getParent();
            if (parentEntity != null && parentEntity instanceof FolderTreeEntity) {
                this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)parentEntity);
            } else {
                FolderEntity folder = FolderController.getInstance().getTestCaseRoot(ProjectController.getInstance().getCurrentProject());
                this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)new FolderTreeEntity(folder, null));
            }
        } else {
            TestSuiteEntity testSuite = testSuiteTreeEntity.getObject();
            FolderController.getInstance().refreshFolder(testSuite.getParentFolder());
        }
    }
}

