/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.parts;

import com.kms.katalon.composer.components.controls.HelpToolBarForCompositePart;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPartEvent;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.ImageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.parts.ParentTestSuiteCompositePart;
import com.kms.katalon.composer.testsuite.parts.TestSuiteAnalyticsPart;
import com.kms.katalon.composer.testsuite.parts.TestSuiteIntegrationPart;
import com.kms.katalon.composer.testsuite.parts.TestSuitePart;
import com.kms.katalon.composer.testsuite.parts.TestSuiteResultPart;
import com.kms.katalon.composer.testsuite.parts.TestSuiteScriptPart;
import com.kms.katalon.composer.testsuite.util.TestSuiteEntityUtil;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TestSuiteCompositePart
implements EventHandler,
ParentTestSuiteCompositePart,
IComposerPartEvent {
    private MCompositePart compositePart;
    private MPartStack subPartStack;
    private CTabFolder tabFolder;
    private TestSuitePart childTestSuiteMainPart;
    private TestSuiteIntegrationPart childTestSuiteIntegrationPart;
    private HelpToolBarForCompositePart helpPart;
    private boolean isInitialized;
    private static final int COMPOSITE_SIZE = 1;
    private static final int SUB_PARTSTACK_SIZE = 5;
    private static final int CHILD_TESTSUITE_MAIN_PART_INDEX = 0;
    private static final int CHILD_TESTSUITE_SCRIPT_PART_INDEX = 1;
    private static final int CHILD_TESTSUITE_INTEGRATION_PART_INDEX = 2;
    private static final int CHILD_TESTSUITE_RESULT_PART_INDEX = 3;
    private static final int CHILD_TESTSUITE_ANALYTICS_PART_INDEX = 4;
    public static final String MAIN_TAB_TITLE = ComposerTestsuiteMessageConstants.PA_TAB_MAIN;
    public static final String INTEGRATION_TAB_TITLE = ComposerTestsuiteMessageConstants.PA_TAB_INTEGRATION;
    private static boolean isConfirmationDialogShowed = false;
    private TestSuiteEntity originalTestSuite;
    private TestSuiteEntity testSuite;
    private Composite parent;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    protected EModelService modelService;
    @Inject
    protected MApplication application;
    @Inject
    private MDirtyable dirty;
    @Inject
    private EPartService partService;
    private TestSuiteScriptPart scriptPart;
    private TestSuiteResultPart resultPart;
    private TestSuiteAnalyticsPart analyticsPart;

    public MDirtyable getDirty() {
        return this.dirty;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @PostConstruct
    public void init(Composite parent, MCompositePart compositePart) {
        this.parent = parent;
        this.compositePart = compositePart;
        this.dirty.setDirty(false);
        this.isInitialized = false;
        this.helpPart = new HelpToolBarForCompositePart((MPart)compositePart, this.partService){

            protected String getDocumentationUrlForPartObject(Object partObject) {
                if (partObject instanceof TestSuitePart) {
                    return DocumentationMessageConstants.TEST_SUITE_MAIN;
                }
                if (partObject instanceof TestSuiteIntegrationPart) {
                    return DocumentationMessageConstants.TEST_SUITE_INTEGRATION;
                }
                return null;
            }
        };
        this.changeOriginalTestSuite((TestSuiteEntity)compositePart.getObject());
        this.initListeners();
    }

    public void initComponent() {
        if (this.compositePart.getChildren().size() != 1 || !(this.compositePart.getChildren().get(0) instanceof MPartStack)) {
            return;
        }
        this.subPartStack = (MPartStack)this.compositePart.getChildren().get(0);
        if (this.subPartStack.getChildren().size() == 5) {
            for (MStackElement stackElement : this.subPartStack.getChildren()) {
                Object part;
                if (!(stackElement instanceof MPart) || Objects.isNull(part = ((MPart)stackElement).getObject())) continue;
                System.out.println("[Name]: " + part.getClass().getName());
                if (part instanceof TestSuitePart) {
                    this.childTestSuiteMainPart = (TestSuitePart)part;
                    continue;
                }
                if (part instanceof TestSuiteIntegrationPart) {
                    this.childTestSuiteIntegrationPart = (TestSuiteIntegrationPart)part;
                    continue;
                }
                if (part instanceof TestSuiteAnalyticsPart) {
                    this.analyticsPart = (TestSuiteAnalyticsPart)part;
                    continue;
                }
                if (part instanceof CompatibilityEditor) {
                    this.scriptPart = new TestSuiteScriptPart(this, (CompatibilityEditor)part);
                    continue;
                }
                if (!StringUtils.equals((String)part.getClass().getName(), (String)"com.kms.katalon.composer.report.parts.ReportPart")) continue;
                this.resultPart = new TestSuiteResultPart(part);
            }
        }
        this.initTabFolder();
        this.loadTestSuite();
        this.isInitialized = true;
        this.scriptPart.initEditorAction();
    }

    private void initTabFolder() {
        if (this.subPartStack.getWidget() instanceof CTabFolder) {
            this.tabFolder = (CTabFolder)this.subPartStack.getWidget();
            this.tabFolder.setTabPosition(1024);
            this.tabFolder.setBorderVisible(false);
            this.tabFolder.setMaximizeVisible(false);
            this.tabFolder.setMinimizeVisible(false);
            if (this.tabFolder.getItemCount() == 5) {
                CTabItem testSuiteMainPart = this.tabFolder.getItem(0);
                testSuiteMainPart.setText(MAIN_TAB_TITLE);
                testSuiteMainPart.setImage(ImageConstants.IMG_16_MAIN);
                testSuiteMainPart.setShowClose(false);
                CTabItem testSuiteScriptPart = this.tabFolder.getItem(1);
                testSuiteScriptPart.setText(ComposerTestsuiteMessageConstants.PA_TAB_SCRIPT);
                testSuiteScriptPart.setImage(ImageConstants.IMG_16_SCRIPT);
                testSuiteScriptPart.setShowClose(false);
                CTabItem testSuiteIntegrationPart = this.tabFolder.getItem(2);
                testSuiteIntegrationPart.setText(INTEGRATION_TAB_TITLE);
                testSuiteIntegrationPart.setImage(ImageConstants.IMG_16_INTEGRATION);
                testSuiteIntegrationPart.setShowClose(false);
                CTabItem testSuiteResultPart = this.tabFolder.getItem(3);
                testSuiteResultPart.setText(ComposerTestsuiteMessageConstants.PA_TAB_RESULT);
                testSuiteResultPart.setImage(ImageConstants.IMG_16_REPORT);
                testSuiteResultPart.setShowClose(false);
                CTabItem testSuiteAnalyticsPart = this.tabFolder.getItem(4);
                testSuiteAnalyticsPart.setText(ComposerTestsuiteMessageConstants.PA_TAB_ANALYTICS);
                testSuiteAnalyticsPart.setImage(ImageConstants.IMG_ANALYTICS);
                testSuiteAnalyticsPart.setShowClose(false);
            }
            this.tabFolder.layout();
        }
    }

    private void loadTestSuite() {
        this.childTestSuiteMainPart.loadTestSuite(this.testSuite);
        this.childTestSuiteIntegrationPart.loadInput();
        if (this.analyticsPart != null) {
            this.analyticsPart.setTestSuite(this.testSuite);
        }
    }

    private void initListeners() {
        this.eventBroker.subscribe("TESTSUITE/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", (EventHandler)this);
        this.eventBroker.subscribe("TESTSUITE/FINISHED", (EventHandler)this);
    }

    public MPart getChildMainPart() {
        return this.childTestSuiteMainPart != null ? this.childTestSuiteMainPart.getMPart() : null;
    }

    public MPart getChildIntegrationPart() {
        return this.childTestSuiteIntegrationPart != null ? this.childTestSuiteIntegrationPart.getMPart() : null;
    }

    public List<MPart> getChildParts() {
        ArrayList<MPart> childrenParts = new ArrayList<MPart>();
        childrenParts.add(this.getChildMainPart());
        childrenParts.add(this.getChildIntegrationPart());
        childrenParts.add(this.scriptPart.getMPart());
        return childrenParts;
    }

    public void setSelectedPart(MPart partToSelect) {
        if (this.subPartStack.getChildren().contains(partToSelect)) {
            this.subPartStack.setSelectedElement((MUIElement)partToSelect);
        }
    }

    private void changeOriginalTestSuite(TestSuiteEntity testSuite) {
        this.originalTestSuite = testSuite;
        this.cloneTestSuite();
    }

    private void cloneTestSuite() {
        this.testSuite = this.originalTestSuite.clone();
        this.testSuite.setTestSuiteGuid(this.originalTestSuite.getTestSuiteGuid());
    }

    public void dispose() {
        MPartStack mStackPart = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        mStackPart.getChildren().remove(this.compositePart);
        this.eventBroker.unsubscribe((EventHandler)this);
        this.childTestSuiteMainPart.dispose();
    }

    public void setDirty(boolean isDirty) {
        this.dirty.setDirty(isDirty);
        for (MPart childPart : this.getChildParts()) {
            childPart.setDirty(false);
        }
        if (isDirty) {
            this.initTabFolder();
        }
    }

    @Persist
    public void onSave() {
        try {
            this.save();
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.ERROR_TITLE, (String)ComposerTestsuiteMessageConstants.PA_ERROR_MSG_UNABLE_TO_SAVE_PART);
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private boolean prepareForSaving() {
        return this.childTestSuiteMainPart.prepareForSaving();
    }

    private void afterSaving() {
        this.childTestSuiteMainPart.afterSaving();
        this.childTestSuiteIntegrationPart.onSaveSuccess(this.testSuite);
    }

    public void save() throws Exception {
        if (!this.prepareForSaving()) {
            return;
        }
        Map<String, IntegratedEntity> editingIntegrated = this.childTestSuiteIntegrationPart.getEditingIntegrated();
        editingIntegrated.entrySet().forEach(entry -> this.testSuite.updateIntegratedEntity((IntegratedEntity)entry.getValue()));
        TestSuiteEntity temp = new TestSuiteEntity();
        TestSuiteEntityUtil.copyTestSuiteProperties(this.originalTestSuite, temp);
        String oldIdForDisplay = this.originalTestSuite.getIdForDisplay();
        TestSuiteEntityUtil.copyTestSuiteProperties(this.testSuite, this.originalTestSuite);
        try {
            this.scriptPart.save();
            TestSuiteController.getInstance().updateTestSuite(this.originalTestSuite);
            TestSuiteTreeEntity testSuiteTreeEntity = TreeEntityUtil.getTestSuiteTreeEntity((TestSuiteEntity)this.originalTestSuite, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)testSuiteTreeEntity);
            if (!StringUtils.equalsIgnoreCase((String)temp.getName(), (String)this.originalTestSuite.getName())) {
                this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, this.originalTestSuite.getIdForDisplay()});
            }
            this.eventBroker.post("TESTSUITE/UPDATED", (Object)new Object[]{this.testSuite.getId(), this.originalTestSuite});
            if (this.parent.isDisposed()) {
                return;
            }
            this.updateTestSuitePart(this.originalTestSuite);
            this.afterSaving();
            this.trackingTestSuite();
            Trackings.trackEditObject((String)"testSuite", (String)"");
        }
        catch (Exception e) {
            TestSuiteEntityUtil.copyTestSuiteProperties(temp, this.originalTestSuite);
            this.childTestSuiteIntegrationPart.onSaveFailure(e);
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
    }

    private void updateTestSuitePart(TestSuiteEntity testSuite) {
        int index = this.tabFolder.getSelectionIndex();
        String newElementId = EntityPartUtil.getTestSuiteCompositePartId((String)testSuite.getId());
        if (!newElementId.equals(this.compositePart.getElementId())) {
            this.compositePart.setLabel(testSuite.getName());
            this.compositePart.setElementId(newElementId);
            if (this.compositePart.getChildren().size() == 1 && this.compositePart.getChildren().get(0) instanceof MPartStack) {
                MPartStack partStack = (MPartStack)this.compositePart.getChildren().get(0);
                partStack.setElementId(newElementId + ".partStack");
                this.renewTestSuiteScriptPart(testSuite, newElementId, partStack);
                this.childTestSuiteMainPart.getMPart().setElementId(newElementId + ".partStack.testSuitePart");
                this.childTestSuiteIntegrationPart.getMPart().setElementId(newElementId + ".partStack.integration");
            }
        }
        this.tabFolder.setSelection(index);
        this.changeOriginalTestSuite(testSuite);
        this.setDirty(false);
        this.loadTestSuite();
    }

    private void renewTestSuiteScriptPart(TestSuiteEntity testSuite, String newElementId, MPartStack partStack) {
        try {
            File scriptFile = TestSuiteController.getInstance().getTestSuiteScriptFile(testSuite);
            MPart testSuiteScriptPart = GroovyEditorUtil.createEditorPart((ProjectEntity)testSuite.getProject(), (String)PathUtil.absoluteToRelativePath((String)scriptFile.getAbsolutePath(), (String)testSuite.getProject().getFolderLocation()), (EPartService)this.partService);
            testSuiteScriptPart.setElementId(newElementId + ".partStack.editor");
            testSuiteScriptPart.getTags().add("NoMove");
            testSuiteScriptPart.setLabel(ComposerTestsuiteMessageConstants.PA_TAB_SCRIPT);
            partStack.getChildren().add(1, testSuiteScriptPart);
            this.partService.activate(testSuiteScriptPart);
            CTabItem testSuiteScriptItem = this.tabFolder.getItem(1);
            testSuiteScriptItem.setText(ComposerTestsuiteMessageConstants.PA_TAB_SCRIPT);
            testSuiteScriptItem.setImage(ImageConstants.IMG_16_SCRIPT);
            testSuiteScriptItem.setShowClose(false);
            this.scriptPart = new TestSuiteScriptPart(this, (CompatibilityEditor)testSuiteScriptPart.getObject());
            this.scriptPart.initEditorAction();
        }
        catch (DALException | CoreException throwable) {}
    }

    public void handleEvent(Event event) {
        block18: {
            Object object;
            if (event.getTopic().equals("EXPLORER/REFRESH_SELECTED_ITEM")) {
                try {
                    FolderEntity folder;
                    Object object2 = event.getProperty("org.eclipse.e4.data");
                    if (object2 == null || !(object2 instanceof ITreeEntity)) break block18;
                    if (object2 instanceof TestSuiteTreeEntity) {
                        TestSuiteTreeEntity testSuiteTreeEntity = (TestSuiteTreeEntity)object2;
                        TestSuiteEntity testSuite = testSuiteTreeEntity.getObject();
                        if (testSuite != null && testSuite.getId().equals(this.originalTestSuite.getId())) {
                            if (TestSuiteController.getInstance().getTestSuite(testSuite.getId()) != null) {
                                if (this.dirty.isDirty()) {
                                    this.verifyTestSuiteChanged();
                                } else {
                                    this.updateTestSuitePart(testSuite);
                                }
                            } else {
                                this.dispose();
                            }
                        }
                    } else if (object2 instanceof FolderTreeEntity && (folder = (FolderEntity)((ITreeEntity)object2).getObject()) != null && FolderController.getInstance().isFolderAncestorOfEntity(folder, (IEntity)this.originalTestSuite) && TestSuiteController.getInstance().getTestSuite(this.originalTestSuite.getId()) == null) {
                        this.dispose();
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            } else if (event.getTopic().equals("TESTSUITE/UPDATED")) {
                String elementId;
                Object object3 = event.getProperty("org.eclipse.e4.data");
                if (object3 != null && object3 instanceof Object[] && (elementId = EntityPartUtil.getTestSuiteCompositePartId((String)((String)((Object[])object3)[0]))).equalsIgnoreCase(this.compositePart.getElementId())) {
                    TestSuiteEntity testSuite = (TestSuiteEntity)((Object[])object3)[1];
                    this.updateTestSuitePart(testSuite);
                }
            } else if (event.getTopic().equals("TESTSUITE/FINISHED") && (object = event.getProperty("org.eclipse.e4.data")) != null && object instanceof TestSuiteEntity) {
                TestSuiteEntity eventTestSuite = (TestSuiteEntity)object;
                try {
                    ReportEntity report = ReportController.getInstance().getLastRunReportEntity(eventTestSuite);
                    this.resultPart.updateReport(report);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e, (String)"Error on retrieving ReportEntity");
                }
            }
        }
    }

    @PreDestroy
    public void onClose() {
        EventUtil.post((String)"PROPERTIES/ENTITY", null);
        this.compositePart.getChildren().clear();
        this.eventBroker.unsubscribe((EventHandler)this);
        this.helpPart.dispose();
        this.interuptUIThreads();
    }

    @Focus
    public void setFocus() {
        this.verifyTestSuiteChanged();
    }

    private void interuptUIThreads() {
        this.childTestSuiteMainPart.interuptUIThreads();
    }

    @Override
    public TestSuiteEntity getTestSuiteClone() {
        return this.testSuite;
    }

    @Override
    public TestSuiteEntity getOriginalTestSuite() {
        return this.originalTestSuite;
    }

    private void verifyTestSuiteChanged() {
        try {
            if (this.originalTestSuite != null) {
                TestSuiteEntity testSuiteInFile = TestSuiteController.getInstance().getTestSuite(this.originalTestSuite.getId());
                if (testSuiteInFile != null) {
                    if (!testSuiteInFile.equals((Object)this.originalTestSuite) && !isConfirmationDialogShowed && MessageDialog.openConfirm(null, (String)ComposerTestsuiteMessageConstants.PA_CONFIRM_TITLE_FILE_CHANGED, (String)MessageFormat.format(ComposerTestsuiteMessageConstants.PA_CONFIRM_MSG_RELOAD_FILE, this.originalTestSuite.getLocation()))) {
                        this.updateTestSuitePart(testSuiteInFile);
                    }
                } else {
                    this.dispose();
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void openAddTestCaseDialog() {
        this.setSelectedPart(this.getChildMainPart());
        this.childTestSuiteMainPart.openAddTestCaseDialog();
    }

    public String getEntityId() {
        return this.getOriginalTestSuite().getIdForDisplay();
    }

    @Inject
    @Optional
    public void onSelect(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        if (this.originalTestSuite == null) {
            return;
        }
        MPart part = EventUtil.getPart((Event)event);
        if (part == null || !StringUtils.startsWith((String)part.getElementId(), (String)EntityPartUtil.getTestSuiteCompositePartId((String)this.originalTestSuite.getId()))) {
            return;
        }
        EventUtil.post((String)"PROPERTIES/ENTITY", (Object)this.originalTestSuite);
    }

    @Inject
    @Optional
    public void onChangeEntityProperties(@UIEventTopic(value="PROPERTIES/ENTITY_UPDATED") Event event) {
        Object eventData = EventUtil.getData((Event)event);
        if (!(eventData instanceof TestSuiteEntity)) {
            return;
        }
        TestSuiteEntity updatedEntity = (TestSuiteEntity)eventData;
        if (!StringUtils.equals((String)updatedEntity.getIdForDisplay(), (String)this.getEntityId())) {
            return;
        }
        this.originalTestSuite.setTag(updatedEntity.getTag());
        this.originalTestSuite.setDescription(updatedEntity.getDescription());
    }

    public boolean isDirty() {
        return this.compositePart.isDirty();
    }

    private void trackingTestSuite() {
        int numberOfAIAPITestCase = 0;
        for (TestSuiteTestCaseLink tcl : this.originalTestSuite.getTestSuiteTestCaseLinks()) {
            try {
                TestCaseEntity tc = TestCaseController.getInstance().getTestCaseByDisplayId(tcl.getTestCaseId());
                if (!tc.isAPITestGenerationTestCase()) continue;
                ++numberOfAIAPITestCase;
            }
            catch (ControllerException controllerException) {}
        }
        Trackings.trackSaveTestSuite((int)numberOfAIAPITestCase);
    }
}

