/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.support;

import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testsuite.editors.TestCaseCellEditor;
import com.kms.katalon.composer.testsuite.parts.TestSuitePartTestCaseView;
import com.kms.katalon.composer.testsuite.providers.TestCaseTableViewer;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class TestCaseIdColumnEditingSupport
extends EditingSupport {
    private TestCaseTableViewer viewer;
    private TestSuitePartTestCaseView eventBroker;
    private static final String FIELD_NAME = "testCaseId";

    public TestCaseIdColumnEditingSupport(ColumnViewer viewer, TestSuitePartTestCaseView eventBroker) {
        super(viewer);
        this.viewer = (TestCaseTableViewer)viewer;
        this.eventBroker = eventBroker;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element != null || element instanceof TestSuiteTestCaseLink) {
            TestSuiteTestCaseLink link = (TestSuiteTestCaseLink)element;
            return new TestCaseCellEditor((Composite)this.viewer.getTable(), link.getTestCaseId(), link.getTestCaseId());
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element != null && element instanceof TestSuiteTestCaseLink) {
            return ((TestSuiteTestCaseLink)element).getTestCaseId();
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (element != null && element instanceof TestSuiteTestCaseLink && value != null && value instanceof TestCaseTreeEntity) {
            try {
                boolean saveData;
                String oldTestCaseId;
                TestSuiteTestCaseLink testCaseLink = (TestSuiteTestCaseLink)element;
                TestCaseEntity testCaseEntity = ((TestCaseTreeEntity)value).getObject();
                if (testCaseEntity == null) {
                    return;
                }
                String testCaseId = testCaseEntity.getIdForDisplay();
                if (testCaseId.equals(oldTestCaseId = testCaseLink.getTestCaseId())) {
                    return;
                }
                if (this.viewer.containTestCasePk(testCaseEntity.getId())) {
                    MessageDialog.openWarning(null, (String)"Warning", (String)("Test case '" + testCaseId + "' has already existed in this test suite."));
                    return;
                }
                ((TestSuiteTestCaseLink)element).setTestCaseId(testCaseId);
                boolean bl = saveData = testCaseLink.getTestDataLinks().size() > 0 && MessageDialog.openQuestion(null, (String)"Confirmation", (String)"Do you want to keep the current test data information?");
                if (!saveData) {
                    this.clearData(testCaseLink, testCaseEntity);
                } else {
                    this.saveData(testCaseLink, testCaseEntity, oldTestCaseId);
                }
                this.viewer.update(element, new String[]{FIELD_NAME});
                this.viewer.updatePk((TestSuiteTestCaseLink)element);
                this.eventBroker.setDirty(true);
                this.viewer.setSelection((ISelection)new StructuredSelection(element));
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private void saveData(TestSuiteTestCaseLink testCaseLink, TestCaseEntity testCaseEntity, String oldTestCaseId) {
        if (this.isVariableChanges(testCaseLink, testCaseEntity)) {
            List variableLinks = testCaseLink.getVariableLinks();
            ArrayList existingVariables = new ArrayList(variableLinks);
            variableLinks.clear();
            String testCaseId = testCaseLink.getTestCaseId();
            for (VariableEntity variable : testCaseEntity.getVariables()) {
                VariableLink variableLink = new VariableLink();
                variableLink.setVariableId(variable.getId());
                String newVariableName = this.getVariableName(testCaseId, variableLink);
                for (VariableLink exisitingVariable : existingVariables) {
                    if (!StringUtils.equals((String)newVariableName, (String)this.getVariableName(oldTestCaseId, exisitingVariable))) continue;
                    variableLink.setTestDataLinkId(exisitingVariable.getTestDataLinkId());
                    variableLink.setType(exisitingVariable.getType());
                    variableLink.setValue(exisitingVariable.getValue());
                    break;
                }
                variableLinks.add(variableLink);
            }
        }
    }

    private void clearData(TestSuiteTestCaseLink testCaseLink, TestCaseEntity testCaseEntity) {
        testCaseLink.getTestDataLinks().clear();
        testCaseLink.getVariableLinks().clear();
        if (this.isVariableChanges(testCaseLink, testCaseEntity)) {
            for (VariableEntity variable : testCaseEntity.getVariables()) {
                VariableLink variableLink = new VariableLink();
                variableLink.setVariableId(variable.getId());
                testCaseLink.getVariableLinks().add(variableLink);
            }
        }
    }

    private String getVariableName(String testCaseId, VariableLink element) {
        try {
            VariableEntity variable = TestSuiteController.getInstance().getVariable(testCaseId, element);
            return variable != null ? variable.getName() : "";
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }

    private boolean isVariableChanges(TestSuiteTestCaseLink testCaseLink, TestCaseEntity testCaseEntity) {
        if (testCaseLink.getVariableLinks().size() != testCaseEntity.getVariables().size()) {
            return true;
        }
        int index = 0;
        while (index < testCaseLink.getVariableLinks().size()) {
            VariableEntity testCaseVariable = (VariableEntity)testCaseEntity.getVariables().get(index);
            if (!testCaseVariable.getId().equals(((VariableLink)testCaseLink.getVariableLinks().get(index)).getVariableId())) {
                return true;
            }
            ++index;
        }
        return false;
    }
}

