/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.classpath;

import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.classpath.BuildPathEntry;
import com.kms.katalon.execution.classpath.IBuildPath;
import com.kms.katalon.execution.classpath.ProjectBuildPath;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.JavaRuntime;
import org.osgi.framework.Bundle;

public class ClassPathResolver {
    private static final String LIB_BIN_FOLDER = "lib";
    private static final String KEYWORD_BIN_FOLDER = "keyword";
    private static final String GROOVY_SOURCE_BIN_FOLDER = "groovy";
    private static final String BIN_FOLDER = "bin";
    private static final String[] CANDIDATES_JAVA_FILES = new String[]{"java", "java.exe"};
    private static final String EVN_KATALON_JAVA_HOME = "KATALON_JAVA_HOME";
    private static final String[] CANDIDATE_JAVA_LOCATIONS = new String[]{"bin" + File.separatorChar, "jre" + File.separatorChar + "bin" + File.separatorChar};

    private ClassPathResolver() {
    }

    private static List<IBuildPath> getPlatformBuildPaths() throws IOException {
        File configurationFolder = ClassPathResolver.getConfigurationFolder();
        File resourceLib = new File(configurationFolder, "resources/lib");
        if (!resourceLib.exists()) {
            return Collections.emptyList();
        }
        ArrayList<IBuildPath> pfBuildPaths = new ArrayList<IBuildPath>();
        File[] fileArray = resourceLib.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File jarFile = fileArray[n2];
            pfBuildPaths.add(new BuildPathEntry(jarFile.getAbsolutePath()));
            ++n2;
        }
        return pfBuildPaths;
    }

    public static File getConfigurationFolder() throws IOException {
        return new File(FileLocator.resolve((URL)Platform.getConfigurationLocation().getURL()).getFile());
    }

    private static List<String> getPlatformBuildPathLocs() throws IOException {
        ArrayList<String> pfBuildPathLocs = new ArrayList<String>();
        for (IBuildPath jarFileBuildPath : ClassPathResolver.getPlatformBuildPaths()) {
            pfBuildPathLocs.add(jarFileBuildPath.getBuildPathLocation());
        }
        return pfBuildPathLocs;
    }

    public static String[] getClassPaths(ProjectEntity project) throws IOException, ControllerException {
        ProjectBuildPath prjBuildpath = new ProjectBuildPath(project);
        List<String> classPathLocs = prjBuildpath.getClassPaths();
        classPathLocs.addAll(ClassPathResolver.getPlatformBuildPathLocs());
        String binFolderRelativePath = project.getFolderLocation() + File.separator + BIN_FOLDER + File.separator;
        classPathLocs.add(binFolderRelativePath + KEYWORD_BIN_FOLDER);
        classPathLocs.add(binFolderRelativePath + LIB_BIN_FOLDER);
        classPathLocs.add(binFolderRelativePath + GROOVY_SOURCE_BIN_FOLDER);
        return classPathLocs.toArray(new String[classPathLocs.size()]);
    }

    public static String getBundleLocation(Bundle bundle) throws IOException {
        return FileLocator.getBundleFile((Bundle)bundle).getAbsolutePath();
    }

    public static String getInstalledJRE(boolean useJavaHome) {
        File vmInstallLocation = JavaRuntime.getDefaultVMInstall().getInstallLocation();
        if (useJavaHome) {
            String javaHome = System.getenv(EVN_KATALON_JAVA_HOME);
            LogUtil.logInfo((String)("INFO: KATALON_JAVA_HOME: " + javaHome));
            if (StringUtils.isNotEmpty((CharSequence)javaHome)) {
                vmInstallLocation = new File(javaHome);
            }
        }
        int i = 0;
        while (i < CANDIDATES_JAVA_FILES.length) {
            int j = 0;
            while (j < CANDIDATE_JAVA_LOCATIONS.length) {
                File javaFile = new File(vmInstallLocation, CANDIDATE_JAVA_LOCATIONS[j] + CANDIDATES_JAVA_FILES[i]);
                if (javaFile.isFile()) {
                    return javaFile.getAbsolutePath();
                }
                ++j;
            }
            ++i;
        }
        return "java";
    }
}

