/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.generator;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testcase.WSVerificationTestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import groovy.lang.GroovyObject;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFolder;

public class TestCaseScriptGenerator {
    private static final String TEMPLATE_CLASS_NAME = "com.kms.katalon.execution.generator.TestCaseScriptTemplate";
    private static final String METHOD_GENERATE_TEST_CASE_SCRIPT_NAME = "generateTestCaseScriptFile";
    private static final String TEMP_TEST_CASE_FILE_NAME = "TempTestCase";
    private TestCaseEntity testCase;
    private IRunConfiguration runConfig;

    public TestCaseScriptGenerator(TestCaseEntity testCase, IRunConfiguration runConfig) {
        this.testCase = testCase;
        this.runConfig = runConfig;
    }

    public File generateScriptFile() throws Exception {
        IFolder folder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)this.testCase.getProject());
        File file = new File(folder.getRawLocation().toFile().getAbsoluteFile().getAbsolutePath(), TEMP_TEST_CASE_FILE_NAME + System.currentTimeMillis() + ".groovy");
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        Class<?> clazz = Class.forName(TEMPLATE_CLASS_NAME);
        GroovyObject object = (GroovyObject)clazz.newInstance();
        object.invokeMethod(METHOD_GENERATE_TEST_CASE_SCRIPT_NAME, (Object)new Object[]{file, this.testCase, this.createTestCaseBinding(), this.runConfig});
        folder.refreshLocal(1, null);
        return file;
    }

    public String createTestCaseBinding() throws Exception {
        StringBuilder bindingBuilder = new StringBuilder();
        StringBuilder syntaxErrorCollector = new StringBuilder();
        String testCaseId = this.testCase.getRelativePathForUI().replace(File.separator, "/");
        bindingBuilder.append("new TestCaseBinding('" + testCaseId + "',");
        StringBuilder variableBinding = new StringBuilder();
        if (this.testCase instanceof WSVerificationTestCaseEntity) {
            variableBinding.append("[");
            List variables = this.testCase.getVariables();
            if (variables.size() > 0) {
                int i = 0;
                while (i < variables.size()) {
                    if (i >= 1) {
                        variableBinding.append(", ");
                    }
                    VariableEntity variable = (VariableEntity)variables.get(i);
                    variableBinding.append(String.format("'%s': %s", variable.getName(), variable.getDefaultValue()));
                    ++i;
                }
            } else {
                variableBinding.append(":");
            }
            variableBinding.append("]");
        } else {
            variableBinding.append("[:]");
        }
        bindingBuilder.append((CharSequence)variableBinding).append(")");
        if (syntaxErrorCollector.toString().isEmpty()) {
            return bindingBuilder.toString();
        }
        throw new RuntimeException(syntaxErrorCollector.toString());
    }
}

