/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.generator;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseBindingExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.generator.TestCaseBindingStringBuilder;
import com.kms.katalon.execution.generator.TestCaseBindingStringBuilderV2;
import com.kms.katalon.execution.util.SyntaxUtil;
import com.kms.katalon.groovy.util.GroovyUtil;
import groovy.lang.GroovyObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFolder;

public class TestSuiteScriptGenerator {
    private static final String TEMPLATE_CLASS_NAME = "com.kms.katalon.execution.generator.TestSuiteScriptTemplate";
    private static final String GENERATED_TEST_SUITE_SCRIPT_METHOD_NAME = "generateTestSuiteScriptFile";
    private static final String TEMP_TEST_SUITE_FILE_NAME = "TempTestSuite";
    private TestSuiteEntity testSuite;
    private IRunConfiguration config;
    private TestSuiteExecutedEntity testSuiteExecuted;
    private StringBuilder syntaxErrorCollector;

    public TestSuiteScriptGenerator(TestSuiteEntity testSuite, IRunConfiguration config, TestSuiteExecutedEntity testSuiteExecutedEntity) {
        this.testSuite = testSuite;
        this.config = config;
        this.testSuiteExecuted = testSuiteExecutedEntity;
    }

    public File generateScriptFile() throws Exception {
        return this.generateScriptFile("");
    }

    public File generateScriptFile(String tcBindings) throws Exception {
        IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)this.testSuite.getProject());
        File file = new File(libFolder.getRawLocation().toString(), TEMP_TEST_SUITE_FILE_NAME + System.currentTimeMillis() + ".groovy");
        file.createNewFile();
        GroovyObject object = (GroovyObject)Class.forName(TEMPLATE_CLASS_NAME).newInstance();
        object.invokeMethod(GENERATED_TEST_SUITE_SCRIPT_METHOD_NAME, (Object)new Object[]{file, this.testSuite, this.createTestCaseBindings(tcBindings), this.config, this.testSuiteExecuted});
        libFolder.refreshLocal(1, null);
        return file;
    }

    public String generateScriptAsString() throws Exception {
        GroovyObject object = (GroovyObject)Class.forName(TEMPLATE_CLASS_NAME).newInstance();
        Object[] objectArray = new Object[4];
        objectArray[1] = this.testSuite;
        objectArray[2] = this.createTestCaseBindings();
        objectArray[3] = this.config;
        return (String)object.invokeMethod(GENERATED_TEST_SUITE_SCRIPT_METHOD_NAME, (Object)objectArray);
    }

    public File createTestCaseBindings() throws Exception {
        return this.createTestCaseBindings("");
    }

    private File createTestCaseBindings(String tcBindings) throws Exception {
        File testCaseBindingFile = new File(this.config.getExecutionSetting().getFolderPath(), "testCaseBinding");
        testCaseBindingFile.createNewFile();
        if (!tcBindings.isEmpty()) {
            FileUtils.write((File)testCaseBindingFile, (CharSequence)tcBindings, (String)"UTF-8", (boolean)false);
            return testCaseBindingFile;
        }
        this.syntaxErrorCollector = new StringBuilder();
        List lstTestCaseRun = TestSuiteController.getInstance().getTestSuiteTestCaseRun(this.testSuite);
        for (IExecutedEntity testCaseExecuted : this.testSuiteExecuted.getExecutedItems()) {
            String testCaseId = testCaseExecuted.getSourceId();
            TestSuiteTestCaseLink testCaseLink = null;
            if (this.testSuite instanceof FilteringTestSuiteEntity) {
                testCaseLink = new TestSuiteTestCaseLink();
                testCaseLink.setTestCaseId(testCaseId);
                testCaseLink.setIsRun(true);
                testCaseLink.setUsingDataBindingAtTestSuiteLevel(false);
            } else {
                testCaseLink = this.getTestCaseLink(testCaseId, lstTestCaseRun);
                lstTestCaseRun.remove(testCaseLink);
            }
            if (testCaseLink == null) {
                throw new IllegalArgumentException("Test case: '" + testCaseId + "' not found");
            }
            List<String> testCaseBinding = this.getTestCaseBindingString(testCaseLink, testCaseExecuted);
            FileUtils.writeLines((File)testCaseBindingFile, (String)"UTF-8", testCaseBinding, (boolean)true);
        }
        if (this.syntaxErrorCollector.toString().isEmpty()) {
            return testCaseBindingFile;
        }
        throw new IllegalArgumentException(this.syntaxErrorCollector.toString());
    }

    private TestSuiteTestCaseLink getTestCaseLink(String testCaseId, List<TestSuiteTestCaseLink> distinctTestCaseLink) {
        for (TestSuiteTestCaseLink testCaseLink : distinctTestCaseLink) {
            if (!testCaseLink.getTestCaseId().equals(testCaseId)) continue;
            return testCaseLink;
        }
        return null;
    }

    private List<String> getTestCaseBindingString(TestSuiteTestCaseLink testCaseLink, IExecutedEntity testCaseExecutedEntity) throws Exception {
        ArrayList<String> testCaseBindingStrings = new ArrayList<String>();
        if (!testCaseLink.isUsingDataBindingAtTestSuiteLevel()) {
            TestCaseBindingExecutedEntity testCaseBindingExecutedEntity = (TestCaseBindingExecutedEntity)testCaseExecutedEntity;
            TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseBindingExecutedEntity.getEntity().getIdForDisplay());
            int iterationIdx = 0;
            while (iterationIdx < testCaseBindingExecutedEntity.getTestCaseExecutedEntity().getLoopTimes()) {
                TestCaseBindingStringBuilderV2 builder = new TestCaseBindingStringBuilderV2(iterationIdx, testCaseBindingExecutedEntity);
                for (VariableLink variableLink : testCase.getVariableLinks()) {
                    builder.append(variableLink, testCaseBindingExecutedEntity.getTestDataMap());
                }
                if (!builder.hasErrors()) {
                    testCaseBindingStrings.add(builder.build());
                } else {
                    this.syntaxErrorCollector.append(builder.getErrorMessage()).append(SyntaxUtil.LINE_SEPARATOR);
                }
                ++iterationIdx;
            }
        } else {
            int iterationIdx = 0;
            while (iterationIdx < ((TestCaseExecutedEntity)testCaseExecutedEntity).getLoopTimes()) {
                TestCaseBindingStringBuilder builder = new TestCaseBindingStringBuilder(iterationIdx, testCaseExecutedEntity);
                for (VariableLink variableLink : testCaseLink.getVariableLinks()) {
                    builder.append(variableLink, this.testSuiteExecuted.getTestDataMap());
                }
                if (builder.hasErrors()) {
                    this.syntaxErrorCollector.append(builder.getErrorMessage()).append(SyntaxUtil.LINE_SEPARATOR);
                    break;
                }
                builder.setIterationVariableName(testCaseLink.getIterationNameVariable());
                testCaseBindingStrings.add(builder.build());
                ++iterationIdx;
            }
        }
        return testCaseBindingStrings;
    }
}

