/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.handler;

import com.kms.katalon.execution.collector.ExecutionPropertiesCollector;
import com.kms.katalon.execution.configuration.contributor.IExecutionPropertiesContributor;
import com.kms.katalon.logging.LogUtil;
import jakarta.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

public class EvaluateExecutionPropertiesContributionHandler {
    private static final String IEXECUTIONPROPERTIES_ATTRIBUTE_NAME = "execution";
    private static final String IEXECUTIONPROPERTIES_CONTRIBUTOR_ID = "com.kms.katalon.execution.executionProperties";

    @Inject
    public void execute(IExtensionRegistry registry) {
        this.evaluate(registry);
    }

    private void evaluate(IExtensionRegistry registry) {
        IConfigurationElement[] config = registry.getConfigurationElementsFor(IEXECUTIONPROPERTIES_CONTRIBUTOR_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension(IEXECUTIONPROPERTIES_ATTRIBUTE_NAME);
                this.executeExtension(o);
                ++n2;
            }
        }
        catch (CoreException ex) {
            LogUtil.logError((Throwable)ex);
        }
    }

    private void executeExtension(final Object o) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable e) {
            }

            public void run() throws Exception {
                if (o instanceof IExecutionPropertiesContributor) {
                    IExecutionPropertiesContributor contributor = (IExecutionPropertiesContributor)o;
                    ExecutionPropertiesCollector.getInstance().addContributor(contributor);
                }
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }
}

