/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.configuration.core.interfaces.IHostConfiguration;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.execution.launcher.ProcessLauncher;
import com.kms.katalon.execution.launcher.listener.LauncherEvent;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.result.ExecutionEntityResult;
import com.kms.katalon.execution.launcher.result.LauncherResult;
import com.kms.katalon.execution.logging.ILogCollection;
import com.kms.katalon.execution.logging.LogEvaluator;
import com.kms.katalon.execution.logging.SocketWatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public abstract class LoggableLauncher
extends ProcessLauncher
implements ILogCollection,
LogEvaluator {
    private static final int DF_WATCHER_DELAY_TIME = 1;
    private static final String TEST_CASE_CURRENT_RETRY_COUNT = "currentRetryCount";
    private List<XmlLogRecord> logRecords = Collections.synchronizedList(new ArrayList());
    private Stack<XmlLogRecord> startRecords = new Stack();
    private int logDepth;
    private LogLevel currentTestCaseResult;
    private TestStatus.TestStatusValue lastStatusValue = null;
    protected boolean loggingFinished = false;

    public LoggableLauncher(LauncherManager manager, IRunConfiguration runConfig) {
        super(manager, runConfig);
    }

    @Override
    protected void onStartExecution() {
        this.logDepth = 0;
        IHostConfiguration hostConfig = this.getRunConfig().getHostConfiguration();
        this.watchers.add(new SocketWatcher(hostConfig.getHostPort(), 1, this));
        this.currentTestCaseResult = LogLevel.NOT_RUN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addLogRecords(List<XmlLogRecord> records) {
        LauncherResult launcherResult = (LauncherResult)this.getResult();
        block17: for (XmlLogRecord record : records) {
            List<XmlLogRecord> list = this.logRecords;
            synchronized (list) {
                this.logRecords.add(record);
            }
            this.onUpdateRecord(record);
            LogLevel logLevel = LogLevel.valueOf((String)record.getLevel().getName());
            if (logLevel == null) continue;
            switch (logLevel) {
                case START: {
                    this.startRecords.push(record);
                    ++this.logDepth;
                    if (!this.isLogUnderTestCaseMainLevel(this.runConfig, this.logDepth) || !this.isStartTestCaseLog(this.startRecords.peek())) continue block17;
                    if (this.needReupdateLastStatus(record)) {
                        launcherResult.updateStartTime();
                        break;
                    }
                    launcherResult.addStartTime();
                    break;
                }
                case END: {
                    if (this.isLogUnderTestCaseMainLevel(this.runConfig, this.logDepth) && this.isStartTestCaseLog(this.startRecords.peek())) {
                        boolean needReupdateLastStatus = this.needReupdateLastStatus(record);
                        if (needReupdateLastStatus) {
                            launcherResult.updateEndTime();
                            switch (this.lastStatusValue) {
                                case FAILED: {
                                    launcherResult.decreaseFailures();
                                    break;
                                }
                                case ERROR: {
                                    launcherResult.decreaseErrors();
                                    break;
                                }
                            }
                        } else {
                            launcherResult.addEndTime();
                        }
                        switch (this.currentTestCaseResult) {
                            case PASSED: {
                                launcherResult.increasePasses();
                                break;
                            }
                            case ERROR: {
                                launcherResult.increaseErrors();
                                break;
                            }
                            case FAILED: {
                                launcherResult.increaseFailures();
                                break;
                            }
                            case INCOMPLETE: {
                                launcherResult.increaseIncompletes();
                                break;
                            }
                            default: {
                                launcherResult.increaseSkips();
                            }
                        }
                        TestStatus.TestStatusValue statusValue = TestStatus.TestStatusValue.valueOf((String)this.currentTestCaseResult.name());
                        if (needReupdateLastStatus) {
                            launcherResult.increaseRetryErrorsAndFailures();
                            this.onReupdateLastResult(this.lastStatusValue, statusValue);
                        } else {
                            this.onUpdateResult(statusValue);
                        }
                        this.lastStatusValue = statusValue;
                        XmlLogRecord testCaseRecord = this.startRecords.peek();
                        String name = (String)testCaseRecord.getProperties().get("name");
                        ExecutionEntityResult result = new ExecutionEntityResult();
                        result.setName(name);
                        result.setTestStatusValue(statusValue);
                        this.notifyProccess((Object)LauncherEvent.UPDATE_RECORD, this.executedEntity, result);
                        this.currentTestCaseResult = LogLevel.NOT_RUN;
                    }
                    --this.logDepth;
                    this.startRecords.pop();
                    if (this.logDepth != 0) continue block17;
                    this.watchdog.stop();
                    this.loggingFinished = true;
                    break;
                }
                default: {
                    if (!LogLevel.getResultLogs().contains(logLevel) || !this.isLogUnderTestCaseMainLevel(this.runConfig, this.logDepth) || !this.isStartTestCaseLog(this.startRecords.peek())) continue block17;
                    this.currentTestCaseResult = logLevel;
                }
            }
        }
    }

    private void onReupdateLastResult(TestStatus.TestStatusValue lastStatus, TestStatus.TestStatusValue currentStatus) {
        HashMap<String, String> propertiesForReupdating = new HashMap<String, String>();
        propertiesForReupdating.put("lastStatus", lastStatus.toString());
        propertiesForReupdating.put("currentStatus", currentStatus.toString());
        propertiesForReupdating.put("launcherId", this.getId());
        this.notifyLauncherChanged(LauncherEvent.REUPDATE_RESULT, propertiesForReupdating);
    }

    private boolean needReupdateLastStatus(XmlLogRecord xmlLogRecord) {
        int currentRetryCount;
        Object currentRetryCountObject = xmlLogRecord.getProperties().get(TEST_CASE_CURRENT_RETRY_COUNT);
        if (currentRetryCountObject instanceof String && (currentRetryCount = Integer.parseInt((String)currentRetryCountObject)) > 0) {
            return this.lastStatusValue != null;
        }
        return false;
    }

    protected void onUpdateRecord(XmlLogRecord record) {
        this.notifyLauncherChanged(LauncherEvent.UPDATE_RECORD, record);
    }

    @Override
    public List<XmlLogRecord> getLogRecords() {
        return this.logRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearRecords() {
        List<XmlLogRecord> list = this.logRecords;
        synchronized (list) {
            this.logRecords.clear();
        }
    }

    @Override
    protected void onStartExecutionComplete() {
        super.onStartExecutionComplete();
    }

    @Override
    protected void postExecutionComplete() {
        super.postExecutionComplete();
    }

    @Override
    public void finish() {
        this.loggingFinished = true;
    }
}

