/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher.manager;

import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.util.FailedTestThreshold;
import com.kms.katalon.execution.launcher.IConsoleLauncher;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.ProcessLauncher;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class LauncherManager {
    private static LauncherManager _instance;
    private List<ILauncher> runningLaunchers = Collections.synchronizedList(new ArrayList());
    private List<ILauncher> waitingLaunchers = Collections.synchronizedList(new ArrayList());
    private List<ILauncher> terminatedLaunchers = Collections.synchronizedList(new ArrayList());
    private int failedThreshold = this.findThreshold();

    protected LauncherManager() {
    }

    public static LauncherManager getInstance() {
        if (_instance == null) {
            _instance = new LauncherManager();
        }
        return _instance;
    }

    public static void refresh() {
        _instance = null;
    }

    public void addLauncher(ILauncher launcher) {
        this.addLauncherToWaitingList(launcher);
        this.schedule();
    }

    protected void addLauncherToRunningList(ILauncher launcher) {
        this.runningLaunchers.add(launcher);
        launcher.setStatus(LauncherStatus.RUNNING);
    }

    private void removeLauncherFromRunningList(ILauncher launcher) {
        this.runningLaunchers.remove(launcher);
    }

    private void addLauncherToWaitingList(ILauncher launcher) {
        this.waitingLaunchers.add(launcher);
        launcher.setStatus(LauncherStatus.WAITING);
    }

    protected void removeLauncherFromWaitingList(ILauncher launcher) {
        this.waitingLaunchers.remove(launcher);
    }

    private void addLauncherToTerminatedList(ILauncher launcher) {
        this.removeAllTerminatedBut(5);
        this.terminatedLaunchers.add(0, launcher);
    }

    public void removeAllTerminated() {
        for (ILauncher launcher : this.terminatedLaunchers) {
            launcher.clean();
        }
        this.terminatedLaunchers.clear();
        LogUtil.logInfo((String)"All launchers terminated");
    }

    public void removeAllTerminatedBut(int n) {
        if (this.terminatedLaunchers.size() < n - 1) {
            return;
        }
        int i = this.terminatedLaunchers.size() - 1;
        while (i >= n - 1) {
            this.terminatedLaunchers.get(i).clean();
            this.terminatedLaunchers.remove(i);
            --i;
        }
    }

    public List<ILauncher> getAllLaunchers() {
        ArrayList<ILauncher> launchers = new ArrayList<ILauncher>();
        launchers.addAll(this.runningLaunchers);
        launchers.addAll(this.waitingLaunchers);
        launchers.addAll(this.terminatedLaunchers);
        return launchers;
    }

    public ILauncher getLauncher(String id) {
        for (ILauncher currentLauncher : this.getAllLaunchers()) {
            if (!currentLauncher.getId().equals(id)) continue;
            return currentLauncher;
        }
        return null;
    }

    public List<ILauncher> getSortedLaunchers() {
        List<ILauncher> launchers = this.getAllLaunchers();
        Collections.sort(launchers, new Comparator<ILauncher>(){

            @Override
            public int compare(ILauncher launcher1, ILauncher launcher2) {
                try {
                    String lcFolderName1 = launcher1.getId();
                    String lcFolderName2 = launcher2.getId();
                    Date lcDate1 = ReportController.getInstance().getDateFromReportFolderName(lcFolderName1);
                    Date lcDate2 = ReportController.getInstance().getDateFromReportFolderName(lcFolderName2);
                    return lcDate1.after(lcDate2) ? 1 : -1;
                }
                catch (Exception exception) {
                    return 1;
                }
            }
        });
        return launchers;
    }

    public boolean isAnyLauncherRunning() {
        return this.runningLaunchers.size() + this.waitingLaunchers.size() != 0;
    }

    public boolean isAnyLauncherTerminated() {
        return this.terminatedLaunchers.size() != 0;
    }

    protected boolean isLauncherReadyToRun(ILauncher launcher) {
        return true;
    }

    public void stopLauncher(ILauncher launcher) {
        if (launcher.getStatus() == LauncherStatus.RUNNING) {
            launcher.stop();
        } else if (launcher.getStatus() == LauncherStatus.WAITING) {
            this.stopWaiting(launcher);
        }
    }

    public synchronized void stopAllLauncher() {
        while (this.waitingLaunchers.size() > 0) {
            this.stopWaiting(this.waitingLaunchers.get(0));
        }
        int index = 0;
        while (this.runningLaunchers.size() > index) {
            if (this.runningLaunchers.get(index).getStatus() != LauncherStatus.TERMINATED) {
                this.runningLaunchers.get(index).stop();
                continue;
            }
            ++index;
        }
    }

    public synchronized void stopRunningAndSchedule(ILauncher launcher) throws InterruptedException {
        this.removeLauncherFromRunningList(launcher);
        this.addLauncherToTerminatedList(launcher);
        this.updateFailedThreshold(launcher);
        this.schedule();
    }

    private void stopWaiting(ILauncher launcher) {
        launcher.stop();
        this.removeLauncherFromWaitingList(launcher);
        this.addLauncherToTerminatedList(launcher);
    }

    protected void schedule() {
        int index = 0;
        while (index < this.waitingLaunchers.size()) {
            ILauncher launcher = this.waitingLaunchers.get(index);
            if (this.isLauncherReadyToRun(launcher)) {
                ProcessLauncher processLauncher;
                this.removeLauncherFromWaitingList(launcher);
                this.addLauncherToRunningList(launcher);
                this.updateRunConfigForFailedThreshold(launcher);
                if (launcher instanceof ProcessLauncher && (processLauncher = (ProcessLauncher)launcher).getRunConfig().shouldReloadDriverConnectorsBeforeLaunch()) {
                    processLauncher.rebuildRunConfigDriverConnector();
                }
                try {
                    launcher.start();
                }
                catch (IOException iOException) {}
                continue;
            }
            ++index;
        }
    }

    public ILauncher getLauncherInRunningList(String launcherId) throws Exception {
        for (ILauncher runningLauncher : this.runningLaunchers) {
            if (!runningLauncher.getId().equals(launcherId)) continue;
            return runningLauncher;
        }
        return null;
    }

    public List<ILauncher> getRunningLaunchers() {
        return this.runningLaunchers;
    }

    public List<ILauncher> getWaitingLaunchers() {
        return this.waitingLaunchers;
    }

    public String getStatus(int consoleWidth) {
        return "\n" + StringUtils.repeat((String)"-", (int)consoleWidth) + "\n" + this.getChildrenLauncherStatus(consoleWidth) + "\n" + StringUtils.repeat((String)"-", (int)consoleWidth) + "\n";
    }

    protected String getChildrenLauncherStatus(int consoleWidth) {
        StringBuilder launcherMessageStatus = new StringBuilder();
        for (ILauncher launcher : this.getSortedLaunchers()) {
            if (!(launcher instanceof IConsoleLauncher)) continue;
            if (StringUtils.isNotEmpty((String)launcherMessageStatus.toString())) {
                launcherMessageStatus.append("\n");
            }
            IConsoleLauncher consoleLauncher = (IConsoleLauncher)launcher;
            launcherMessageStatus.append(consoleLauncher.getStatusMessage(consoleWidth));
        }
        return launcherMessageStatus.toString();
    }

    protected void updateRunConfigForFailedThreshold(ILauncher launcher) {
    }

    protected void updateFailedThreshold(ILauncher launcher) {
        if (this.hasFailedThreshold()) {
            this.failedThreshold -= launcher.getRemainingFailedThreshold();
            if (this.failedThreshold <= 0) {
                this.removeAllWaitingLaunchers();
            }
        }
    }

    public void removeAllWaitingLaunchers() {
        while (this.waitingLaunchers.size() > 0) {
            this.stopWaiting(this.waitingLaunchers.get(0));
        }
    }

    private int findThreshold() {
        FailedTestThreshold failedTestThreshold = FailedTestThreshold.getInstance();
        if (failedTestThreshold.isThresholdAvailable()) {
            return failedTestThreshold.getThreshold();
        }
        return -1;
    }

    private boolean hasFailedThreshold() {
        return this.findThreshold() > 0;
    }

    public int getFailedThreshold() {
        return this.failedThreshold;
    }
}

