/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher.process;

import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import com.kms.katalon.execution.launcher.process.ProcessStdoutFileExporter;
import com.kms.katalon.execution.logging.IOutputStream;
import com.kms.katalon.execution.logging.LaunchOutputStreamHandler;
import com.kms.katalon.execution.util.ProcessUtils;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;

public class ConsoleProcess
implements ILaunchProcess {
    private Process fSystemProcess;
    protected LaunchOutputStreamHandler fOutputStreamHandler;
    protected LaunchOutputStreamHandler fErrorStreamHandler;
    private ProcessStdoutFileExporter stdoutFileExporter;

    public ConsoleProcess(Process systemProcess, boolean generateConsoleLog, File reportFolder) throws ExecutionException {
        this.fSystemProcess = systemProcess;
        if (generateConsoleLog) {
            try {
                this.stdoutFileExporter = new ProcessStdoutFileExporter(reportFolder);
                this.stdoutFileExporter.start();
            }
            catch (IOException | SecurityException e) {
                LogUtil.logError((String)"Failed to start ProcessStdoutFileExporter in ConsoleProcess");
                LogUtil.logError((Throwable)e);
                throw new ExecutionException((Throwable)e);
            }
        }
        this.buildStreamHandler(systemProcess);
    }

    protected ProcessStdoutFileExporter getProcessStdoutFileExporter() {
        return this.stdoutFileExporter;
    }

    protected void buildStreamHandler(Process systemProcess) {
        this.fOutputStreamHandler = LaunchOutputStreamHandler.outputHandlerFrom(systemProcess.getInputStream(), this.createLogConsumer(line -> this.stdoutFileExporter.recordStdoutLog((String)line)));
        this.fOutputStreamHandler.start();
        this.fErrorStreamHandler = LaunchOutputStreamHandler.errorHandlerFrom(systemProcess.getErrorStream(), this.createLogConsumer(line -> this.stdoutFileExporter.recordStderrLog((String)line)));
        this.fErrorStreamHandler.start();
    }

    protected Consumer<String> createLogConsumer(Consumer<String> logAction) {
        return this.stdoutFileExporter != null ? logAction : null;
    }

    @Override
    public int getExitValue() {
        return this.fSystemProcess.exitValue();
    }

    @Override
    public void terminate() {
        this.stopStdoutStream();
        ProcessUtils.forceKillProcessTree(this.fSystemProcess);
    }

    @Override
    public boolean isTerminated() {
        try {
            this.getExitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    @Override
    public IOutputStream getOutputStreamHandler() {
        this.stopStdoutStream();
        return this.fOutputStreamHandler;
    }

    @Override
    public IOutputStream getErrorStreamHandler() {
        this.stopStdoutStream();
        return this.fErrorStreamHandler;
    }

    private void stopStdoutStream() {
        try {
            if (this.stdoutFileExporter != null) {
                this.stdoutFileExporter.close();
            }
        }
        catch (Exception e) {
            LogUtil.logError((String)"Failed to close stdoutFileExporter");
            LogUtil.logError((Throwable)e);
        }
    }
}

