/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.logging;

import com.kms.katalon.execution.logging.IOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;

public class LaunchOutputStreamHandler
extends Thread
implements IOutputStream {
    private InputStream is;
    private PrintStream os;
    private boolean printAllowed;
    private Consumer<String> streamingConsumer;

    private LaunchOutputStreamHandler(InputStream is, PrintStream os, boolean printAllowed, Consumer<String> streamingConsumer) {
        this.is = is;
        this.os = os;
        this.printAllowed = printAllowed;
        this.streamingConsumer = streamingConsumer;
    }

    @Override
    public void run() {
        block7: {
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                try {
                    isr = new InputStreamReader(this.is, "UTF-8");
                    br = new BufferedReader(isr);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if (this.printAllowed) {
                            this.println(line);
                        }
                        if (this.streamingConsumer == null) continue;
                        this.streamingConsumer.accept(line + System.lineSeparator());
                    }
                }
                catch (IOException iOException) {
                    IOUtils.closeQuietly(br);
                    IOUtils.closeQuietly(isr);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(isr);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)br);
            IOUtils.closeQuietly((Reader)isr);
        }
    }

    @Override
    public synchronized void println(String line) {
        this.os.println(line);
    }

    @Override
    public void close() throws IOException {
    }

    public static LaunchOutputStreamHandler outputHandlerFrom(InputStream is, Consumer<String> streamConsumed) {
        return new LaunchOutputStreamHandler(is, System.out, true, streamConsumed);
    }

    public static LaunchOutputStreamHandler outputHandlerFrom(InputStream is, boolean printAllowed, Consumer<String> streamConsumed) {
        return new LaunchOutputStreamHandler(is, System.out, printAllowed, streamConsumed);
    }

    public static LaunchOutputStreamHandler errorHandlerFrom(InputStream is, Consumer<String> streamConsumed) {
        return new LaunchOutputStreamHandler(is, System.err, true, streamConsumed);
    }

    public static LaunchOutputStreamHandler errorHandlerFrom(InputStream is, boolean printAllowed, Consumer<String> streamConsumed) {
        return new LaunchOutputStreamHandler(is, System.err, printAllowed, streamConsumed);
    }
}

