/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webservice;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.exception.KatalonRuntimeException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.WSVerificationTestCaseEntity;
import com.kms.katalon.execution.configuration.VariableEvaluationRunConfiguration;
import com.kms.katalon.execution.entity.WSVerificationTestCaseExecutedEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyShell;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.util.Map;

public class VariableEvaluator {
    private static final String EVALUATION_SCRIPT_TEMPLATE_CLASS = "com.kms.katalon.execution.generator.VariableEvaluationScriptTemplate";
    private static final String GENERATE_EVALUATION_SCRIPT_METHOD = "generateEvaluationScript";
    private static final String TEST_CASE_ID_PREFIX = "Variable-Eval_";

    public Map<String, Object> evaluate(Map<String, String> variables, ExecutionProfileEntity executionProfile, Map<String, Object> overridingGlobalVariables) throws Exception {
        WSVerificationTestCaseEntity testCaseEntity = this.createTestCaseEntity();
        VariableEvaluationRunConfiguration runConfig = new VariableEvaluationRunConfiguration();
        runConfig.setExecutionProfile(executionProfile);
        runConfig.setOverridingGlobalVariables(overridingGlobalVariables);
        runConfig.build((FileEntity)testCaseEntity, new WSVerificationTestCaseExecutedEntity(testCaseEntity));
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        GroovyUtil.updateProjectClassLoaderAsync((ProjectEntity)project);
        URLClassLoader classLoader = GroovyUtil.getProjectClassLoader((ProjectEntity)project);
        String evaluationScript = this.generateEvaluationScript(variables, runConfig);
        GroovyShell groovyShell = new GroovyShell((ClassLoader)classLoader);
        try {
            return (Map)groovyShell.evaluate(evaluationScript);
        }
        catch (NoClassDefFoundError e) {
            throw new KatalonRuntimeException("NoClassDefFoundError: internal/GlobalVariable", (Throwable)e);
        }
    }

    private String generateEvaluationScript(Map<String, String> variables, IRunConfiguration runConfig) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> clazz = Class.forName(EVALUATION_SCRIPT_TEMPLATE_CLASS);
        GroovyObject object = (GroovyObject)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return (String)object.invokeMethod(GENERATE_EVALUATION_SCRIPT_METHOD, (Object)new Object[]{variables, runConfig});
    }

    private WSVerificationTestCaseEntity createTestCaseEntity() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        WSVerificationTestCaseEntity testCaseEntity = new WSVerificationTestCaseEntity();
        testCaseEntity.setId(TEST_CASE_ID_PREFIX + System.currentTimeMillis());
        testCaseEntity.setProject(project);
        testCaseEntity.setScript("");
        return testCaseEntity;
    }
}

