/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.builder.core;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.reficio.ws.SoapBuilderException;
import org.reficio.ws.SoapContext;
import org.reficio.ws.builder.SoapBuilder;
import org.reficio.ws.builder.SoapOperation;
import org.reficio.ws.builder.SoapOperationBuilder;
import org.reficio.ws.builder.SoapOperationFinder;
import org.reficio.ws.builder.core.SoapOperationFinderImpl;
import org.reficio.ws.builder.core.SoapOperationImpl;
import org.reficio.ws.legacy.SoapLegacyFacade;

class SoapBuilderImpl
implements SoapBuilder {
    private final SoapLegacyFacade soapFacade;
    private final Binding binding;
    private final SoapContext context;
    private final List<String> serviceUrls;

    SoapBuilderImpl(SoapLegacyFacade soapFacade, Binding binding, SoapContext context) {
        this.soapFacade = soapFacade;
        this.binding = binding;
        this.context = context;
        this.serviceUrls = new ArrayList<String>();
        this.initializeServiceUrls();
    }

    private void initializeServiceUrls() {
        for (Service service : this.soapFacade.getServices()) {
            for (Port port : service.getPorts().values()) {
                String address = SoapLegacyFacade.getSoapEndpoint((Port)port);
                if (address == null) continue;
                this.serviceUrls.add(address);
            }
        }
    }

    public BindingOperation getBindingOperation(SoapOperation op) {
        BindingOperation operation = this.binding.getBindingOperation(op.getOperationName(), op.getOperationInputName(), op.getOperationOutputName());
        if (operation == null) {
            throw new SoapBuilderException("Operation not found");
        }
        return operation;
    }

    @Override
    public List<SoapOperation> getOperations() {
        ArrayList<SoapOperation> operationNames = new ArrayList<SoapOperation>();
        for (BindingOperation operation : this.binding.getBindingOperations()) {
            operationNames.add(SoapOperationImpl.create(this, this.binding, operation));
        }
        return operationNames;
    }

    @Override
    public SoapContext getContext() {
        return this.context;
    }

    @Override
    public SoapOperationBuilder getOperationBuilder(SoapOperation operation) {
        BindingOperation bindingOperation = this.getBindingOperation(operation);
        return SoapOperationImpl.create(this, this.binding, bindingOperation);
    }

    @Override
    public SoapOperationFinder operation() {
        return new SoapOperationFinderImpl(this, this.binding);
    }

    @Override
    public String buildInputMessage(SoapOperation operation) {
        return this.buildInputMessage(operation, this.context);
    }

    @Override
    public String buildInputMessage(SoapOperation operation, SoapContext context) {
        try {
            return this.soapFacade.buildSoapMessageFromInput(this.binding, this.getBindingOperation(operation), context);
        }
        catch (Exception e) {
            throw new SoapBuilderException((Throwable)e);
        }
    }

    @Override
    public String buildOutputMessage(SoapOperation operation) {
        return this.buildOutputMessage(operation, this.context);
    }

    @Override
    public String buildOutputMessage(SoapOperation operation, SoapContext context) {
        try {
            return this.soapFacade.buildSoapMessageFromOutput(this.binding, this.getBindingOperation(operation), context);
        }
        catch (Exception e) {
            throw new SoapBuilderException((Throwable)e);
        }
    }

    @Override
    public String buildFault(String code, String message) {
        return this.soapFacade.buildFault(code, message, this.binding, this.context);
    }

    @Override
    public String buildFault(String code, String message, SoapContext context) {
        return this.soapFacade.buildFault(code, message, this.binding, context);
    }

    @Override
    public String buildEmptyFault() {
        return this.soapFacade.buildEmptyFault(this.binding, this.context);
    }

    @Override
    public String buildEmptyFault(SoapContext context) {
        return this.soapFacade.buildEmptyFault(this.binding, context);
    }

    @Override
    public String buildEmptyMessage() {
        return this.soapFacade.buildEmptyMessage(this.binding, this.context);
    }

    @Override
    public String buildEmptyMessage(SoapContext context) {
        return this.soapFacade.buildEmptyMessage(this.binding, context);
    }

    @Override
    public QName getBindingName() {
        return this.binding.getQName();
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public List<String> getServiceUrls() {
        return new ArrayList<String>(this.serviceUrls);
    }

    @Override
    public void validateInputMessage(SoapOperation operation, String message) {
        BindingOperation bindingOperation = this.getBindingOperation(operation);
        this.soapFacade.validateSoapRequestMessage(this.binding, bindingOperation, message, false);
    }

    @Override
    public void validateInputMessage(SoapOperation operation, String message, boolean strict) {
        BindingOperation bindingOperation = this.getBindingOperation(operation);
        this.soapFacade.validateSoapRequestMessage(this.binding, bindingOperation, message, strict);
    }

    @Override
    public void validateOutputMessage(SoapOperation operation, String message) {
        BindingOperation bindingOperation = this.getBindingOperation(operation);
        this.soapFacade.validateSoapResponseMessage(this.binding, bindingOperation, message, false);
    }

    @Override
    public void validateOutputMessage(SoapOperation operation, String message, boolean strict) {
        BindingOperation bindingOperation = this.getBindingOperation(operation);
        this.soapFacade.validateSoapResponseMessage(this.binding, bindingOperation, message, strict);
    }

    @Override
    public boolean isRpc() {
        return SoapLegacyFacade.isRpc((Binding)this.binding);
    }

    @Override
    public boolean isInputSoapEncoded(SoapOperation operation) {
        return this.soapFacade.isInputSoapEncoded(this.getBindingOperation(operation));
    }

    @Override
    public boolean isOutputSoapEncoded(SoapOperation operation) {
        return this.soapFacade.isOutputSoapEncoded(this.getBindingOperation(operation));
    }
}

