/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.genai.ApiClient;
import com.google.genai.Models;
import com.google.genai.ResponseStream;
import com.google.genai.Transformers;
import com.google.genai.types.Content;
import com.google.genai.types.EditImageConfig;
import com.google.genai.types.EditImageResponse;
import com.google.genai.types.EmbedContentConfig;
import com.google.genai.types.EmbedContentResponse;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.GenerateContentResponse;
import com.google.genai.types.GenerateImagesConfig;
import com.google.genai.types.GenerateImagesResponse;
import com.google.genai.types.GenerateVideosConfig;
import com.google.genai.types.GenerateVideosOperation;
import com.google.genai.types.Image;
import com.google.genai.types.ReferenceImage;
import com.google.genai.types.UpscaleImageConfig;
import com.google.genai.types.UpscaleImageResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class AsyncModels {
    Models models;

    public AsyncModels(ApiClient apiClient) {
        this.models = new Models(apiClient);
    }

    public CompletableFuture<GenerateVideosOperation> generateVideos(String model, String prompt, Image image, GenerateVideosConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.generateVideos(model, prompt, image, config));
    }

    public CompletableFuture<GenerateContentResponse> generateContent(String model, List<Content> contents, GenerateContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.generateContent(model, contents, config));
    }

    public CompletableFuture<GenerateContentResponse> generateContent(String model, Content content, GenerateContentConfig config) {
        return this.generateContent(model, Transformers.tContents(null, content), config);
    }

    public CompletableFuture<GenerateContentResponse> generateContent(String model, String text, GenerateContentConfig config) {
        return this.generateContent(model, Transformers.tContents(null, text), config);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> generateContentStream(String model, List<Content> contents, GenerateContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.generateContentStream(model, contents, config));
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> generateContentStream(String model, Content content, GenerateContentConfig config) {
        return this.generateContentStream(model, Transformers.tContents(null, content), config);
    }

    public CompletableFuture<ResponseStream<GenerateContentResponse>> generateContentStream(String model, String text, GenerateContentConfig config) {
        return this.generateContentStream(model, Transformers.tContents(null, text), config);
    }

    public CompletableFuture<GenerateImagesResponse> generateImages(String model, String prompt, GenerateImagesConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.generateImages(model, prompt, config));
    }

    public CompletableFuture<EditImageResponse> editImage(String model, String prompt, List<ReferenceImage> referenceImages, EditImageConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.editImage(model, prompt, referenceImages, config));
    }

    public CompletableFuture<UpscaleImageResponse> upscaleImage(String model, Image image, String upscaleFactor, UpscaleImageConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.upscaleImage(model, image, upscaleFactor, config));
    }

    public CompletableFuture<EmbedContentResponse> embedContent(String model, String text, EmbedContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.embedContent(model, text, config));
    }

    public CompletableFuture<EmbedContentResponse> embedContent(String model, List<String> texts, EmbedContentConfig config) {
        return CompletableFuture.supplyAsync(() -> this.models.embedContent(model, texts, config));
    }
}

