/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.GoogleSearch;
import com.google.genai.types.GoogleSearchRetrieval;
import com.google.genai.types.Retrieval;
import com.google.genai.types.Tool;
import com.google.genai.types.ToolCodeExecution;
import java.util.List;
import java.util.Optional;

final class AutoValue_Tool
extends Tool {
    private final Optional<List<FunctionDeclaration>> functionDeclarations;
    private final Optional<Retrieval> retrieval;
    private final Optional<GoogleSearch> googleSearch;
    private final Optional<GoogleSearchRetrieval> googleSearchRetrieval;
    private final Optional<ToolCodeExecution> codeExecution;

    private AutoValue_Tool(Optional<List<FunctionDeclaration>> functionDeclarations, Optional<Retrieval> retrieval, Optional<GoogleSearch> googleSearch, Optional<GoogleSearchRetrieval> googleSearchRetrieval, Optional<ToolCodeExecution> codeExecution) {
        this.functionDeclarations = functionDeclarations;
        this.retrieval = retrieval;
        this.googleSearch = googleSearch;
        this.googleSearchRetrieval = googleSearchRetrieval;
        this.codeExecution = codeExecution;
    }

    @Override
    @JsonProperty(value="functionDeclarations")
    public Optional<List<FunctionDeclaration>> functionDeclarations() {
        return this.functionDeclarations;
    }

    @Override
    @JsonProperty(value="retrieval")
    public Optional<Retrieval> retrieval() {
        return this.retrieval;
    }

    @Override
    @JsonProperty(value="googleSearch")
    public Optional<GoogleSearch> googleSearch() {
        return this.googleSearch;
    }

    @Override
    @JsonProperty(value="googleSearchRetrieval")
    public Optional<GoogleSearchRetrieval> googleSearchRetrieval() {
        return this.googleSearchRetrieval;
    }

    @Override
    @JsonProperty(value="codeExecution")
    public Optional<ToolCodeExecution> codeExecution() {
        return this.codeExecution;
    }

    public String toString() {
        return "Tool{functionDeclarations=" + this.functionDeclarations + ", retrieval=" + this.retrieval + ", googleSearch=" + this.googleSearch + ", googleSearchRetrieval=" + this.googleSearchRetrieval + ", codeExecution=" + this.codeExecution + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Tool) {
            Tool that = (Tool)o;
            return this.functionDeclarations.equals(that.functionDeclarations()) && this.retrieval.equals(that.retrieval()) && this.googleSearch.equals(that.googleSearch()) && this.googleSearchRetrieval.equals(that.googleSearchRetrieval()) && this.codeExecution.equals(that.codeExecution());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.functionDeclarations.hashCode();
        h$ *= 1000003;
        h$ ^= this.retrieval.hashCode();
        h$ *= 1000003;
        h$ ^= this.googleSearch.hashCode();
        h$ *= 1000003;
        h$ ^= this.googleSearchRetrieval.hashCode();
        h$ *= 1000003;
        return h$ ^= this.codeExecution.hashCode();
    }

    @Override
    public Tool.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Tool.Builder {
        private Optional<List<FunctionDeclaration>> functionDeclarations = Optional.empty();
        private Optional<Retrieval> retrieval = Optional.empty();
        private Optional<GoogleSearch> googleSearch = Optional.empty();
        private Optional<GoogleSearchRetrieval> googleSearchRetrieval = Optional.empty();
        private Optional<ToolCodeExecution> codeExecution = Optional.empty();

        Builder() {
        }

        Builder(Tool source) {
            this.functionDeclarations = source.functionDeclarations();
            this.retrieval = source.retrieval();
            this.googleSearch = source.googleSearch();
            this.googleSearchRetrieval = source.googleSearchRetrieval();
            this.codeExecution = source.codeExecution();
        }

        @Override
        public Tool.Builder functionDeclarations(List<FunctionDeclaration> functionDeclarations) {
            this.functionDeclarations = Optional.of(functionDeclarations);
            return this;
        }

        @Override
        public Tool.Builder retrieval(Retrieval retrieval) {
            this.retrieval = Optional.of(retrieval);
            return this;
        }

        @Override
        public Tool.Builder googleSearch(GoogleSearch googleSearch) {
            this.googleSearch = Optional.of(googleSearch);
            return this;
        }

        @Override
        public Tool.Builder googleSearchRetrieval(GoogleSearchRetrieval googleSearchRetrieval) {
            this.googleSearchRetrieval = Optional.of(googleSearchRetrieval);
            return this;
        }

        @Override
        public Tool.Builder codeExecution(ToolCodeExecution codeExecution) {
            this.codeExecution = Optional.of(codeExecution);
            return this;
        }

        @Override
        public Tool build() {
            return new AutoValue_Tool(this.functionDeclarations, this.retrieval, this.googleSearch, this.googleSearchRetrieval, this.codeExecution);
        }
    }
}

