/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.helper;

import com.kms.katalon.core.helper.XMLHelper;
import com.kms.katalon.core.util.ArrayUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.core.internal.preferences.InstancePreferences;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WorkbenchPreferencesHelper {
    public static final String ECLIPSE_WORKBENCH_NODE_ID = "org.eclipse.ui.workbench";
    private static final String LOCATION_FIELD = "location";

    public static final InstancePreferences getPreferencesInstance() {
        InstancePreferences prefs = (InstancePreferences)InstanceScope.INSTANCE.getNode(ECLIPSE_WORKBENCH_NODE_ID);
        return prefs;
    }

    public static final File getPreferenceFile() {
        Path prefsLocation;
        Field location;
        try {
            location = InstancePreferences.class.getDeclaredField(LOCATION_FIELD);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            return null;
        }
        if (location == null) {
            return null;
        }
        location.setAccessible(true);
        try {
            prefsLocation = (Path)location.get(WorkbenchPreferencesHelper.getPreferencesInstance());
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
        return prefsLocation != null ? new File(prefsLocation.toString()) : null;
    }

    public static Document getPreferenceSection(String name) {
        Document doc = XMLHelper.readXML(WorkbenchPreferencesHelper.getPreferencesInstance().get(name, ""));
        return doc;
    }

    public static void setPreferencefSection(String name, Document xmlDoc) {
        String xmlString = XMLHelper.docToString(xmlDoc);
        WorkbenchPreferencesHelper.setPreferenceSection(name, xmlString);
    }

    public static void setPreferenceSection(String name, String value) {
        WorkbenchPreferencesHelper.getPreferencesInstance().put(name, value);
    }

    public static Node findNodeByAttributes(String parentSectionName, String ... attributes) {
        return WorkbenchPreferencesHelper.findNodeByAttributes(parentSectionName, ArrayUtil.toMap(attributes));
    }

    public static Node findNodeByAttributes(String parentSectionName, Map<String, String> nodeAttributes) {
        Document section = WorkbenchPreferencesHelper.getPreferenceSection(parentSectionName);
        return XMLHelper.findNodeByAttributes((Node)section, nodeAttributes);
    }
}

