/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.helper.screenrecorder;

import atu.testrecorder.ATUTestRecorder;
import atu.testrecorder.media.image.Images;
import com.kms.katalon.core.helper.screenrecorder.Recorder;
import com.kms.katalon.core.helper.screenrecorder.VideoCursor;
import com.kms.katalon.core.helper.screenrecorder.VideoFileFormat;
import com.kms.katalon.core.helper.screenrecorder.VideoQuality;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class VideoConfiguration {
    private VideoQuality videoQuality;
    private Recorder recorder = Recorder.ATU;
    private VideoFileFormat videoFormat = VideoFileFormat.AVI;
    private VideoCursor cursor = VideoCursor.WHITE;
    private int depth = 16;
    private long screenRate = 15L;
    private long mouseRate = 15L;
    private long maxFrameDuration = 1000L;
    private Point cursorOffset = new Point(-8, -5);

    public VideoConfiguration() {
    }

    public VideoConfiguration(Recorder recorder, VideoFileFormat videoFormat, int depth, long screenRate, long mouseRate, long maxFrameDuration, VideoCursor cursor) {
        this.recorder = recorder;
        this.videoFormat = videoFormat;
        this.depth = depth;
        this.screenRate = screenRate;
        this.mouseRate = mouseRate;
        this.maxFrameDuration = maxFrameDuration;
        this.cursor = cursor;
    }

    public Recorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(Recorder recorder) {
        this.recorder = recorder;
    }

    public VideoFileFormat getVideoFormat() {
        return this.videoFormat;
    }

    public int getDepth() {
        return this.depth;
    }

    public long getScreenRate() {
        return this.screenRate;
    }

    public long getMouseRate() {
        return this.mouseRate;
    }

    public int getAviSyncInterval() {
        return (int)(Math.max(this.getScreenRate(), this.getMouseRate()) * 60L);
    }

    public int getQuicktimeSyncInterval() {
        return (int)Math.max(this.getScreenRate(), this.getMouseRate());
    }

    public long getMaxFrameDuration() {
        return this.maxFrameDuration;
    }

    public VideoCursor getCursor() {
        return this.cursor;
    }

    public Point getCursorOffset() {
        return this.cursorOffset;
    }

    public BufferedImage getCursorImage() {
        if (this.getCursor() == VideoCursor.BLACK) {
            return Images.toBufferedImage((Image)Images.createImage(ATUTestRecorder.class, (String)"/atu/testrecorder/media/images/Cursor.black.png"));
        }
        return Images.toBufferedImage((Image)Images.createImage(ATUTestRecorder.class, (String)"/atu/testrecorder/media/images/Cursor.white.png"));
    }

    public void setVideoFormat(VideoFileFormat videoFormat) {
        this.videoFormat = videoFormat;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public VideoQuality getVideoQuality() {
        return this.videoQuality;
    }

    public void setVideoQuality(VideoQuality videoQuality) {
        this.videoQuality = videoQuality;
    }
}

