/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;

public enum LogLevel {
    START(10020),
    END(10030),
    PASSED(10000),
    INFO(10010),
    WARNING(10040),
    FAILED(10050),
    ERROR(10060),
    ABORTED(10090),
    INCOMPLETE(10100),
    NOT_RUN(9909),
    RUN_DATA(20000),
    DEBUG(10009),
    SKIPPED(20001);

    private final int value;
    private Level level;

    private LogLevel(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public Level getLevel() {
        if (this.level == null) {
            this.level = new InternalLogLevel(this.name(), this.getValue());
        }
        return this.level;
    }

    public static Set<LogLevel> getResultLogs() {
        LinkedHashSet<LogLevel> resultLogs = new LinkedHashSet<LogLevel>();
        resultLogs.add(PASSED);
        resultLogs.add(FAILED);
        resultLogs.add(ERROR);
        resultLogs.add(INCOMPLETE);
        resultLogs.add(SKIPPED);
        return resultLogs;
    }

    public static LogLevel valueOf(String string) {
        return Enum.valueOf(LogLevel.class, string);
    }

    private class InternalLogLevel
    extends Level {
        private static final long serialVersionUID = 7111238540539667071L;

        protected InternalLogLevel(String arg0, int arg1) {
            super(arg0, arg1);
        }
    }
}

