/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.main;

import com.kms.katalon.core.exception.StepErrorException;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.keyword.internal.KeywordExecutionContext;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.main.KeywordClassDelegatingMetaClass;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import groovy.lang.DelegatingMetaClass;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;

public class CustomKeywordDelegatingMetaClass
extends DelegatingMetaClass {
    private static final String APPLITOOLS_KEYWORD = "com.kms.katalon.keyword.applitools";
    private static final KeywordLogger logger = KeywordLogger.getInstance(CustomKeywordDelegatingMetaClass.class);
    private GroovyClassLoader groovyClassLoader;
    private ErrorCollector errorCollector = ErrorCollector.getCollector();

    CustomKeywordDelegatingMetaClass(Class<?> clazz, GroovyClassLoader groovyClassLoader) {
        super(clazz);
        this.initialize();
        this.groovyClassLoader = groovyClassLoader;
    }

    public Object invokeStaticMethod(Object object, String methodName, Object[] arguments) {
        List<Throwable> oldErrors = this.errorCollector.getCoppiedErrors();
        boolean oldIsKeywordPassed = this.errorCollector.isKeywordPassed();
        try {
            this.errorCollector.clearErrors();
            this.errorCollector.setKeywordPassed(false);
            int classAndMethodSeparatorIndex = methodName.lastIndexOf(".");
            String customKeywordClassName = methodName.substring(0, classAndMethodSeparatorIndex);
            if (customKeywordClassName.contains(APPLITOOLS_KEYWORD)) {
                KeywordExecutionContext.setUsingApplitools(true);
            }
            Class<?> customKeywordClass = this.getCustomKeywordClassAndSetMetaClass(customKeywordClassName);
            GroovyObject obj = (GroovyObject)customKeywordClass.newInstance();
            String customKeywordMethodName = methodName.substring(classAndMethodSeparatorIndex + 1, methodName.length());
            Object result = obj.invokeMethod(customKeywordMethodName, (Object)arguments);
            if (this.errorCollector.containsErrors()) {
                Throwable throwable = this.errorCollector.getFirstError();
                logger.logMessage(ErrorCollector.fromError(throwable), ExceptionsUtil.getMessageForThrowable(throwable), throwable);
            } else if (!this.errorCollector.isKeywordPassed()) {
                logger.logMessage(LogLevel.PASSED, methodName + " is PASSED");
            }
            Object object2 = result;
            return object2;
        }
        catch (Throwable throwable) {
            this.errorCollector.addError(throwable);
            Throwable errorToThrow = this.errorCollector.getFirstError();
            if (errorToThrow != null) {
                CustomKeywordDelegatingMetaClass.throwError(errorToThrow);
            }
            return null;
        }
        finally {
            this.errorCollector.getErrors().addAll(0, oldErrors);
            this.errorCollector.setKeywordPassed(oldIsKeywordPassed);
        }
    }

    private static void throwError(Throwable error) {
        String causeErrorMessage;
        String string = causeErrorMessage = error.getCause() != null ? "\n" + String.valueOf(error.getCause()) : "";
        if (ErrorCollector.isErrorFailed(error)) {
            logger.logFailed(error.getMessage() + causeErrorMessage, null, error);
            if (error instanceof InvokerInvocationException) {
                throw (InvokerInvocationException)error;
            }
            if (error instanceof AssertionError) {
                throw (AssertionError)((Object)error);
            }
            if (error instanceof StepFailedException) {
                throw (StepFailedException)error;
            }
            throw new StepFailedException(error);
        }
        logger.logError(error.getMessage() + causeErrorMessage, null, error);
        if (error instanceof StepErrorException) {
            throw (StepErrorException)error;
        }
        throw new StepErrorException(error);
    }

    private Class<?> getCustomKeywordClassAndSetMetaClass(String customKeywordClassName) throws ClassNotFoundException {
        Class customKeywordClass = this.groovyClassLoader.loadClass(customKeywordClassName);
        MetaClass keywordMetaClass = InvokerHelper.metaRegistry.getMetaClass(customKeywordClass);
        if (!(keywordMetaClass instanceof KeywordClassDelegatingMetaClass)) {
            InvokerHelper.metaRegistry.setMetaClass(customKeywordClass, (MetaClass)new KeywordClassDelegatingMetaClass(customKeywordClass, this.groovyClassLoader));
        }
        return customKeywordClass;
    }
}

