/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.main;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.testcase.TestCaseFactory;
import com.kms.katalon.core.testdata.TestDataFactory;
import com.kms.katalon.core.testobject.ObjectRepository;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.runtime.InvokerHelper;

public class ScriptEngine
extends GroovyScriptEngine {
    private static final Map<String, String> testCaseNameLookup = new ConcurrentHashMap<String, String>();
    private int counter = 0;
    private Map<String, Script> scriptLookup = new HashMap<String, Script>();
    private CompilerConfigurationProvider configurationProvider = new CompilerConfigurationProvider(this.getGroovyClassLoader());
    private GroovyClassLoader executingScriptClassLoader;
    private GroovyClassLoader variableEvaluateClassLoader;

    public static ScriptEngine getDefault(ClassLoader parentClassLoader) throws IOException {
        URL[] roots = new URL[]{new File(RunConfiguration.getProjectDir(), "Keywords").toURI().toURL()};
        return new ScriptEngine(roots, parentClassLoader);
    }

    public ScriptEngine(URL[] roots, ClassLoader parentClassLoader) {
        super(roots, parentClassLoader);
    }

    public void changeConfigForExecutingScript() throws ClassNotFoundException {
        this.setConfig(this.configurationProvider.getConfigForExecutingScript());
    }

    public void changeConfigForCollectingVariable() {
        this.setConfig(this.configurationProvider.getConfigForCollectingVariable());
    }

    public GroovyClassLoader getExecutingScriptClassLoader() throws ClassNotFoundException {
        if (this.executingScriptClassLoader == null) {
            this.executingScriptClassLoader = new GroovyClassLoader(this.getParentClassLoader(), this.configurationProvider.getConfigForExecutingScript());
        }
        return this.executingScriptClassLoader;
    }

    protected GroovyClassLoader getVariableValuateClassLoader() throws ClassNotFoundException {
        if (this.variableEvaluateClassLoader == null) {
            this.variableEvaluateClassLoader = new GroovyClassLoader(this.getParentClassLoader(), this.configurationProvider.getConfigForCollectingVariable());
        }
        return this.variableEvaluateClassLoader;
    }

    protected synchronized String generateScriptName() {
        return "Script" + ++this.counter + ".groovy";
    }

    public Object runScript(String scriptText, Binding binding) throws ResourceException, ScriptException, IOException, ClassNotFoundException {
        return this.run(this.getGroovyCodeSource(scriptText, this.generateScriptName()), binding, false);
    }

    public Object runScriptWithoutLogging(String scriptText, Binding binding) throws ResourceException, ScriptException, IOException, ClassNotFoundException {
        Class clazz = this.getVariableValuateClassLoader().parseClass(this.getGroovyCodeSource(scriptText, this.generateScriptName()), true);
        return this.getScript(clazz, binding, false).run();
    }

    public Object runScriptAsRawText(String scriptText, String className, Binding binding, String testCaseName) throws ResourceException, ScriptException, IOException, ClassNotFoundException {
        if (testCaseName != null) {
            String scriptId = new File(className).getName();
            testCaseNameLookup.put(scriptId, testCaseName);
            testCaseNameLookup.put(scriptId.replace(".groovy", ""), testCaseName);
        }
        String processedScriptText = this.preProcessScriptBeforeBuild(scriptText);
        return this.run(this.getGroovyCodeSource(processedScriptText, className), binding, true);
    }

    public Object runScriptMethodAsRawText(String scriptText, String className, String methodName, Object args, Binding binding) throws ResourceException, ScriptException, ClassNotFoundException, IOException {
        String processedScriptText = this.preProcessScriptBeforeBuild(scriptText);
        return this.getScript(this.getGroovyCodeSource(processedScriptText, className), binding, true).invokeMethod(methodName, args);
    }

    public Object runScriptMethodAsRawText(String scriptText, String className, String methodName, Binding binding) throws ResourceException, ScriptException, ClassNotFoundException, IOException {
        String processedScriptText = this.preProcessScriptBeforeBuild(scriptText);
        return this.getScript(this.getGroovyCodeSource(processedScriptText, className), binding, true).invokeMethod(methodName, null);
    }

    private String preProcessScriptBeforeBuild(String scriptText) {
        return ScriptEngine.processNotRunLabels(scriptText);
    }

    private static String processNotRunLabels(String scriptText) {
        String notRunLabel = "not_run";
        String notRunLabelSearchString = notRunLabel + ":";
        String notRunLabelPrefix = notRunLabel + "_";
        Matcher m = Pattern.compile(notRunLabelSearchString).matcher(scriptText);
        StringBuffer sb = new StringBuffer();
        int generatedIndex = 0;
        while (m.find()) {
            m.appendReplacement(sb, notRunLabelPrefix + generatedIndex++ + ":");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public Object runScriptMethod(String className, String methodName, Object args, Binding binding) throws ResourceException, ScriptException, ClassNotFoundException {
        return this.getScript(this.getGroovyClassLoader().loadClass(className), binding, true).invokeMethod(methodName, args);
    }

    public Object runScriptMethod(String className, String methodName, Binding binding) throws ResourceException, ScriptException, ClassNotFoundException {
        return this.runScriptMethod(className, methodName, null, binding);
    }

    public Object runScript(File file, Binding binding) throws ResourceException, ScriptException, IOException, ClassNotFoundException {
        return this.run(this.getGroovyCodeSource(file), binding, true);
    }

    public Script parseClass(File file, Binding binding) throws IOException, ClassNotFoundException {
        return this.getScript(this.getGroovyCodeSource(file), binding, true);
    }

    private GroovyCodeSource getGroovyCodeSource(File file) {
        try {
            return this.getGroovyCodeSource(FileUtils.readFileToString((File)file, (String)"UTF-8"), file.toURI().toURL().toExternalForm());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private GroovyCodeSource getGroovyCodeSource(final String scriptText, final String fileName) {
        GroovyCodeSource gcs = AccessController.doPrivileged(new PrivilegedAction<GroovyCodeSource>(){

            @Override
            public GroovyCodeSource run() {
                return new GroovyCodeSource(scriptText, fileName, "/groovy/shell");
            }
        });
        return gcs;
    }

    private Object run(GroovyCodeSource gcs, Binding binding, boolean remember) throws IOException, ClassNotFoundException {
        return this.getScript(gcs, binding, remember).run();
    }

    private Script getScript(GroovyCodeSource gcs, Binding binding, boolean remember) throws IOException, ClassNotFoundException {
        Class clazz = this.getExecutingScriptClassLoader().parseClass(gcs, remember);
        return this.getScript(clazz, binding, remember);
    }

    public Script getScript(Class<?> clazz, Binding binding, boolean remember) {
        if (!remember) {
            return InvokerHelper.createScript(clazz, (Binding)binding);
        }
        Script script = this.scriptLookup.get(clazz.getName());
        return script != null ? script : InvokerHelper.createScript(clazz, (Binding)binding);
    }

    public static String getTestCaseName(String script) {
        String testCaseName = testCaseNameLookup.get(script);
        return testCaseName;
    }

    private class CompilerConfigurationProvider {
        private static final String FIND_TEST_CASE_METHOD_NAME = "findTestCase";
        private static final String FIND_TEST_DATA_METHOD_NAME = "findTestData";
        private static final String FIND_TEST_OBJECT_METHOD_NAME = "findTestObject";
        private GroovyClassLoader parentClassLoader;
        private CompilerConfiguration executingScriptConfig;
        private CompilerConfiguration collectingVariableConfig;

        public CompilerConfigurationProvider(GroovyClassLoader parentClassLoader) {
            this.parentClassLoader = parentClassLoader;
        }

        public CompilerConfiguration getConfigForExecutingScript() throws ClassNotFoundException {
            if (this.executingScriptConfig == null) {
                this.executingScriptConfig = new CompilerConfiguration(System.getProperties());
                Class astTransformationClass = this.parentClassLoader.loadClass("com.kms.katalon.core.ast.RequireAstTestStepTransformation");
                this.executingScriptConfig.addCompilationCustomizers(new CompilationCustomizer[]{new ASTTransformationCustomizer(astTransformationClass)});
            }
            return this.executingScriptConfig;
        }

        public CompilerConfiguration getConfigForCollectingVariable() {
            if (this.collectingVariableConfig == null) {
                this.collectingVariableConfig = new CompilerConfiguration();
                ImportCustomizer importCustomizer = new ImportCustomizer();
                importCustomizer.addImport(TestDataFactory.class.getSimpleName(), TestDataFactory.class.getName());
                importCustomizer.addImport(ObjectRepository.class.getSimpleName(), ObjectRepository.class.getName());
                importCustomizer.addImport(TestCaseFactory.class.getSimpleName(), TestCaseFactory.class.getName());
                importCustomizer.addImport(RunConfiguration.class.getSimpleName(), RunConfiguration.class.getName());
                importCustomizer.addStaticImport(TestDataFactory.class.getName(), FIND_TEST_DATA_METHOD_NAME);
                importCustomizer.addStaticImport(ObjectRepository.class.getName(), FIND_TEST_OBJECT_METHOD_NAME);
                importCustomizer.addStaticImport(TestCaseFactory.class.getName(), FIND_TEST_CASE_METHOD_NAME);
                importCustomizer.addImport("GlobalVariable", "internal.GlobalVariable");
                this.collectingVariableConfig.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
            }
            return this.collectingVariableConfig;
        }
    }
}

