/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testdata;

import com.kms.katalon.core.testdata.AbstractTestData;
import com.kms.katalon.core.testdata.TestDataType;
import com.kms.katalon.core.testdata.reader.CSVReader;
import com.kms.katalon.core.testdata.reader.CSVSeparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CSVData
extends AbstractTestData {
    private CSVReader reader;
    private CSVSeparator separator;

    public CSVData(String sourceUrl, boolean containsHeader, CSVSeparator separator) throws IOException {
        super(sourceUrl, containsHeader);
        this.separator = separator;
    }

    private CSVReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new CSVReader(this.sourceUrl, this.separator, this.hasHeaders);
        }
        return this.reader;
    }

    @Override
    protected String internallyGetValue(String columnName, int rowIndex) throws IOException {
        return this.getReader().getData().get(rowIndex).get(this.getReader().getColumnIndex(columnName));
    }

    @Override
    protected String internallyGetValue(int columnIndex, int rowIndex) throws IOException {
        return this.getReader().getData().get(rowIndex).get(columnIndex);
    }

    @Override
    public TestDataType getType() {
        return TestDataType.CSV_FILE;
    }

    @Override
    public String[] getColumnNames() throws IOException {
        if (this.getReader().getColumnNames() != null) {
            return this.getReader().getColumnNames();
        }
        return new String[0];
    }

    @Override
    public int getRowNumbers() throws IOException {
        return this.getReader().getData().size();
    }

    @Override
    public int getColumnNumbers() throws IOException {
        return this.getColumnNames().length;
    }

    @Override
    public void activeHeaders(boolean active) throws IOException {
        super.activeHeaders(active);
        this.reader = null;
    }

    public List<List<String>> getData() throws IOException {
        return this.getReader().getData();
    }

    @Override
    public List<List<Object>> getAllData() throws IOException {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        for (List<String> row : this.getData()) {
            data.add(new ArrayList<String>(row));
        }
        return data;
    }
}

