/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testdata.reader;

import com.kms.katalon.core.testdata.reader.CSVSeparator;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.ICsvListReader;
import org.supercsv.prefs.CsvPreference;

public class CSVReader {
    private ICsvListReader listReader;
    private List<List<String>> data;
    private String[] columnNames;
    private boolean containsHeader;

    public CSVReader(String sourceUrl, CSVSeparator separator, boolean containHeader) throws IOException {
        try {
            List rowValues;
            this.containsHeader = containHeader;
            FileReader reader = new FileReader(new File(sourceUrl));
            switch (separator) {
                case COMMA: {
                    this.listReader = new CsvListReader((Reader)reader, CsvPreference.STANDARD_PREFERENCE);
                    break;
                }
                case SEMICOLON: {
                    this.listReader = new CsvListReader((Reader)reader, CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE);
                    break;
                }
                case TAB: {
                    this.listReader = new CsvListReader((Reader)reader, CsvPreference.TAB_PREFERENCE);
                }
            }
            if (containHeader) {
                this.columnNames = this.listReader.getHeader(containHeader);
            }
            this.data = new ArrayList<List<String>>();
            while ((rowValues = this.listReader.read()) != null) {
                this.data.add(rowValues);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.listReader);
        }
    }

    public String[] getColumnNames() throws IOException {
        if (this.columnNames == null) {
            this.columnNames = new String[this.getColumnCount()];
        }
        return this.columnNames;
    }

    public List<List<String>> getData() {
        return this.data;
    }

    public int getColumnIndex(String columnName) throws IOException {
        if (columnName != null && !columnName.isEmpty()) {
            int i = 0;
            while (i < this.getColumnNames().length) {
                if (this.columnNames[i] != null && this.getColumnNames()[i].equals(columnName)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int getColumnCount() throws IOException {
        if (this.containsHeader) {
            return this.getColumnNames().length;
        }
        if (this.data != null && this.data.size() > 0) {
            return this.data.get(0).size();
        }
        return 0;
    }
}

