/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testdata.reader;

import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.testdata.ExcelData;
import com.kms.katalon.core.testdata.reader.ExcelProvider;
import com.kms.katalon.core.testdata.reader.HTMLTableProvider;
import com.kms.katalon.core.testdata.reader.WorbookProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;

public class ExcelFactory {
    private static ExcelProvider[] providers = new ExcelProvider[]{new WorbookProvider(), new HTMLTableProvider()};

    public static ExcelData getExcelDataWithDefaultSheet(String fullFilePath, String sheetName, boolean hasHeaders) throws IOException {
        ExcelData excelData = ExcelFactory.getExcelData(fullFilePath, hasHeaders);
        excelData.changeSheet(sheetName);
        return excelData;
    }

    public static ExcelData getExcelData(String fullFilePath, boolean hasHeaders) throws IOException {
        File inputFile = new File(fullFilePath);
        if (!inputFile.exists()) {
            throw new FileNotFoundException(fullFilePath);
        }
        ExcelData excel = null;
        ExcelProvider[] excelProviderArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            ExcelProvider provider = excelProviderArray[n2];
            try {
                excel = provider.getExcelData(fullFilePath, hasHeaders);
                if (excel != null) {
                    break;
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        if (excel == null) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_FILE_IS_UNSUPPORTED, fullFilePath));
        }
        return excel;
    }
}

