/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject;

import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.HttpMessage;
import com.kms.katalon.core.testobject.PerformanceResourceTiming;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import com.kms.katalon.core.util.MimeTypeUtil;
import com.kms.katalon.core.util.internal.XMLUtil;
import com.kms.katalon.util.DocumentBuilderProvider;
import com.kms.katalon.util.TransformerFactoryProvider;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ResponseObject
implements PerformanceResourceTiming,
HttpMessage {
    private static final String DF_CHARSET = "UTF-8";
    private String contentType = "text/plain";
    private String contentDisposition = null;
    private final transient Pattern SOAPPatternEnvelope = Pattern.compile(":Envelope>?");
    private final transient Pattern SOAPPatternBody = Pattern.compile(":Body>?");
    @Deprecated
    private String responseText;
    private int statusCode;
    private Map<String, List<String>> headerFields;
    private long responseHeaderSize;
    private long responseBodySize;
    private long waitingTime;
    private long contentDownloadTime;
    private String contentCharset;
    private HttpBodyContent responseBodyContent;

    public ResponseObject() {
    }

    public ResponseObject(String responseText) {
        this.responseText = responseText;
    }

    public String getResponseBodyContent() throws Exception {
        String responseText = this.getResponseTextSafely();
        if (responseText != null) {
            if (this.contentType != null && this.contentType.startsWith("application/xml")) {
                Matcher SOAPEnvMatcher = this.SOAPPatternEnvelope.matcher(responseText);
                Matcher SOAPBodyMatcher = this.SOAPPatternBody.matcher(responseText);
                if (SOAPEnvMatcher.find() && SOAPBodyMatcher.find()) {
                    DocumentBuilder db = DocumentBuilderProvider.newBuilderInstance();
                    Document doc = db.parse(new InputSource(new StringReader(responseText)));
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    NodeList nodes = (NodeList)xPath.evaluate("/*/*/*", doc, XPathConstants.NODESET);
                    if (nodes.getLength() > 0) {
                        Node lastNode = nodes.item(nodes.getLength() - 1);
                        return this.nodeToString(lastNode);
                    }
                    return "";
                }
                return responseText;
            }
            if (this.contentType != null && this.contentType.startsWith("application/json")) {
                return responseText;
            }
            return responseText;
        }
        return "";
    }

    public String getResponseText() throws IOException {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        this.responseBodyContent.writeTo(outstream);
        return outstream.toString(this.getContentCharset());
    }

    public void setResponseText(String responseText) {
        this.responseBodyContent = new HttpTextBodyContent(responseText);
        this.responseText = responseText;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    private String nodeToString(Node node) throws TransformerException {
        StringWriter writer = new StringWriter();
        TransformerFactory tf = TransformerFactoryProvider.newInstance();
        Transformer xform = tf.newTransformer();
        xform.setOutputProperty("omit-xml-declaration", "yes");
        xform.transform(new DOMSource(node), new StreamResult(writer));
        return writer.toString();
    }

    public boolean isJsonContentType() {
        return this.contentType != null && this.contentType.toLowerCase().startsWith("application/json");
    }

    public boolean isXmlContentType() {
        String contentTypeString = this.contentType.toLowerCase();
        return this.contentType != null && (contentTypeString.startsWith("application/xml") || contentTypeString.equals("application/soap+xml") || contentTypeString.equals("text/xml"));
    }

    public boolean isSOAPResponse() {
        String responseText = this.getResponseTextSafely();
        Matcher SOAPEnvMatcher = this.SOAPPatternEnvelope.matcher(responseText);
        Matcher SOAPBodyMatcher = this.SOAPPatternBody.matcher(responseText);
        return this.isXmlContentType() && SOAPEnvMatcher.find() && SOAPBodyMatcher.find();
    }

    public boolean isTextContentType() {
        return !this.isJsonContentType() && !this.isXmlContentType();
    }

    public Map<String, List<String>> getHeaderFields() {
        if (this.headerFields == null) {
            this.headerFields = Collections.emptyMap();
        }
        return this.headerFields;
    }

    public void setHeaderFields(Map<String, List<String>> headerFields) {
        this.headerFields = headerFields;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public long getResponseSize() {
        return this.getResponseHeaderSize() + this.getResponseBodySize();
    }

    public long getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    public void setResponseHeaderSize(long reponseHeaderSize) {
        this.responseHeaderSize = reponseHeaderSize;
    }

    public long getResponseBodySize() {
        return this.responseBodySize;
    }

    public void setResponseBodySize(long reponseBodySize) {
        this.responseBodySize = reponseBodySize;
    }

    @Override
    public long getElapsedTime() {
        return this.getWaitingTime() + this.getContentDownloadTime();
    }

    @Override
    public long getWaitingTime() {
        return this.waitingTime;
    }

    public void setWaitingTime(long waitingTime) {
        this.waitingTime = waitingTime;
    }

    @Override
    public long getContentDownloadTime() {
        return this.contentDownloadTime;
    }

    public void setContentDownloadTime(long contentDownloadTime) {
        this.contentDownloadTime = contentDownloadTime;
    }

    @Override
    public HttpBodyContent getBodyContent() {
        return this.responseBodyContent;
    }

    public void setBodyContent(HttpBodyContent bodyContent) {
        this.responseBodyContent = bodyContent;
    }

    public String getContentCharset() {
        if (StringUtils.isEmpty((CharSequence)this.contentCharset)) {
            return DF_CHARSET;
        }
        return this.contentCharset;
    }

    public void setContentCharset(String contentCharset) {
        this.contentCharset = contentCharset;
    }

    public String toString() {
        return this.getStatusCode() + " " + FileUtils.byteCountToDisplaySize((long)this.getResponseSize());
    }

    public String getHeaderField(String name) {
        List<String> headerValues = this.headerFields.get(name);
        if (headerValues != null && headerValues.size() > 0) {
            return headerValues.get(0);
        }
        return null;
    }

    public String extractSOAPBodyAsContent() {
        String responseText = this.getResponseTextSafely();
        if (responseText != null && this.contentType != null && this.isXmlContentType()) {
            Matcher SOAPEnvMatcher = this.SOAPPatternEnvelope.matcher(responseText);
            Matcher SOAPBodyMatcher = this.SOAPPatternBody.matcher(responseText);
            if (SOAPEnvMatcher.find() && SOAPBodyMatcher.find()) {
                return XMLUtil.extractSOAPBodyAsContent(responseText);
            }
            return responseText;
        }
        return responseText;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeResponseBodyToFile(String absoluteFilePath) throws Exception {
        Throwable throwable;
        File parentDir;
        if (this.responseBodyContent == null) {
            throw new IllegalStateException("Response body content is null");
        }
        if (StringUtils.isBlank((CharSequence)absoluteFilePath)) {
            throw new IllegalArgumentException("File path cannot be null or empty");
        }
        File file = new File(absoluteFilePath);
        if (file.getParentFile() != null && !file.getParentFile().exists() && !(parentDir = file.getParentFile()).exists()) {
            try {
                if (!parentDir.mkdirs()) {
                    if (!parentDir.canWrite()) {
                        throw new IOException(MessageFormat.format(StringConstants.WS_SAVE_RESPONSE_MISSING_WRITE_PERMISSION_ERROR_MSG, parentDir.getAbsolutePath()));
                    }
                    throw new IOException(MessageFormat.format(StringConstants.WS_SAVE_RESPONSE_DISK_SPACE_ERROR_MSG, absoluteFilePath));
                }
            }
            catch (SecurityException se) {
                throw new IOException(MessageFormat.format(StringConstants.WS_SAVE_RESPONSE_SECURITY_RESTRICTION_ERROR_MSG, parentDir.getAbsolutePath()), se);
            }
        }
        if (MimeTypeUtil.isTextContentType(this.contentType)) {
            throwable = null;
            Object var4_7 = null;
            try {
                InputStream inputStream = this.responseBodyContent.getInputStream();
                try {
                    block63: {
                        InputStreamReader reader = new InputStreamReader(inputStream, this.getContentCharset());
                        try {
                            block62: {
                                BufferedReader bufferedReader = new BufferedReader(reader);
                                try {
                                    block61: {
                                        FileOutputStream fos = new FileOutputStream(file);
                                        try {
                                            block60: {
                                                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, this.getContentCharset());
                                                try {
                                                    try (BufferedWriter bufferedWriter = new BufferedWriter(writer);){
                                                        int charsRead;
                                                        char[] buffer = new char[8192];
                                                        while ((charsRead = bufferedReader.read(buffer)) != -1) {
                                                            bufferedWriter.write(buffer, 0, charsRead);
                                                        }
                                                    }
                                                    if (writer == null) break block60;
                                                }
                                                catch (Throwable throwable2) {
                                                    if (throwable == null) {
                                                        throwable = throwable2;
                                                    } else if (throwable != throwable2) {
                                                        throwable.addSuppressed(throwable2);
                                                    }
                                                    if (writer == null) throw throwable;
                                                    writer.close();
                                                    throw throwable;
                                                }
                                                writer.close();
                                            }
                                            if (fos == null) break block61;
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable == null) {
                                                throwable = throwable3;
                                            } else if (throwable != throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                            if (fos == null) throw throwable;
                                            fos.close();
                                            throw throwable;
                                        }
                                        fos.close();
                                    }
                                    if (bufferedReader == null) break block62;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                    } else if (throwable != throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    if (bufferedReader == null) throw throwable;
                                    bufferedReader.close();
                                    throw throwable;
                                }
                                bufferedReader.close();
                            }
                            if (reader == null) break block63;
                        }
                        catch (Throwable throwable5) {
                            if (throwable == null) {
                                throwable = throwable5;
                            } else if (throwable != throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            if (reader == null) throw throwable;
                            reader.close();
                            throw throwable;
                        }
                        reader.close();
                    }
                    if (inputStream == null) return;
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return;
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        throwable = null;
        Object var4_14 = null;
        try {
            InputStream inputStream = this.responseBodyContent.getInputStream();
            try {
                block65: {
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        try (BufferedOutputStream bos = new BufferedOutputStream(fos);){
                            int bytesRead;
                            byte[] buffer = new byte[8192];
                            while ((bytesRead = inputStream.read(buffer)) != -1) {
                                bos.write(buffer, 0, bytesRead);
                            }
                        }
                        if (fos == null) break block65;
                    }
                    catch (Throwable throwable8) {
                        if (throwable == null) {
                            throwable = throwable8;
                        } else if (throwable != throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                        if (fos == null) throw throwable;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                }
                if (inputStream == null) return;
            }
            catch (Throwable throwable9) {
                if (throwable == null) {
                    throwable = throwable9;
                } else if (throwable != throwable9) {
                    throwable.addSuppressed(throwable9);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return;
        }
        catch (Throwable throwable10) {
            if (throwable == null) {
                throwable = throwable10;
                throw throwable;
            }
            if (throwable == throwable10) throw throwable;
            throwable.addSuppressed(throwable10);
            throw throwable;
        }
    }

    public ResponseObject clone() {
        ResponseObject cloneObject = new ResponseObject();
        cloneObject.statusCode = this.statusCode;
        cloneObject.contentType = this.contentType;
        cloneObject.contentDisposition = this.contentDisposition;
        cloneObject.responseHeaderSize = this.responseHeaderSize;
        cloneObject.responseBodySize = this.responseBodySize;
        cloneObject.waitingTime = this.waitingTime;
        cloneObject.contentDownloadTime = this.contentDownloadTime;
        cloneObject.contentCharset = this.contentCharset;
        cloneObject.responseText = this.responseText;
        if (this.headerFields != null) {
            cloneObject.headerFields = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry : this.headerFields.entrySet()) {
                cloneObject.headerFields.put(entry.getKey(), entry.getValue() != null ? new ArrayList(entry.getValue()) : null);
            }
        }
        if (this.responseBodyContent != null) {
            cloneObject.responseBodyContent = this.responseBodyContent;
        }
        return cloneObject;
    }

    private String getResponseTextSafely() {
        try {
            return this.getResponseText();
        }
        catch (Exception exception) {
            return this.responseText;
        }
    }
}

