/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject.authorization;

import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.testobject.authorization.OAuth1SignatureMethod;
import com.kms.katalon.core.testobject.authorization.RequestAuthorization;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class OAuth1Authorization
extends BasicRequestAuthorization {
    private static final long serialVersionUID = 1L;
    private static final String CONSUMER_KEY_KEY = "consumer_key";
    private static final String CONSUMER_SECRET_KEY = "consumer_secret";
    private static final String SIGNATURE_METHOD_KEY = "signature_method";
    private static final String TOKEN_KEY = "token";
    private static final String TOKEN_SECRET_KEY = "token_secret";
    private static final String REALM_KEY = "realm";
    public static final String AUTHORIZATION_TYPE = "OAuth 1.0";

    public OAuth1Authorization(RequestAuthorization source) throws UnsupportedEncodingException, GeneralSecurityException {
        this(source.getAuthorizationInfo());
    }

    public OAuth1Authorization(Map<String, String> props) {
        this.init(props);
    }

    public OAuth1Authorization(String consumerKey, String consumerSecret, OAuth1SignatureMethod signatureMethod, String token, String tokenSecret, String realm) throws UnsupportedEncodingException, GeneralSecurityException {
        HashMap<String, String> authorizationInfo = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)consumerKey)) {
            authorizationInfo.put(CONSUMER_KEY_KEY, consumerKey);
        }
        if (StringUtils.isNotBlank((CharSequence)consumerSecret)) {
            authorizationInfo.put(CONSUMER_SECRET_KEY, OAuth1Authorization.encrypt(consumerSecret));
        }
        if (Objects.nonNull((Object)signatureMethod)) {
            authorizationInfo.put(SIGNATURE_METHOD_KEY, signatureMethod.name());
        }
        if (StringUtils.isNotBlank((CharSequence)token)) {
            authorizationInfo.put(TOKEN_KEY, token);
        }
        if (StringUtils.isNotBlank((CharSequence)tokenSecret)) {
            authorizationInfo.put(TOKEN_SECRET_KEY, OAuth1Authorization.encrypt(tokenSecret));
        }
        if (StringUtils.isNotBlank((CharSequence)realm)) {
            authorizationInfo.put(REALM_KEY, realm);
        }
        this.init(authorizationInfo);
    }

    public static OAuth1Authorization adapt(Map<String, String> properties) {
        if (Objects.isNull(properties)) {
            throw new IllegalArgumentException("The Map<String, String> parameter is required but null");
        }
        return new OAuth1Authorization(properties);
    }

    public static OAuth1Authorization adapt(RequestAuthorization requestAuthorization) throws UnsupportedEncodingException, GeneralSecurityException {
        if (!OAuth1Authorization.is(requestAuthorization)) {
            throw new IllegalArgumentException("The RequestAuthorization parameter isn't the type of OAuth1Authorization");
        }
        return new OAuth1Authorization(requestAuthorization);
    }

    public String getConsumerKey() {
        return this.getWithEmpty(CONSUMER_KEY_KEY);
    }

    public String getConsumerSecret() throws GeneralSecurityException, IOException {
        String encryptedValue = this.getWithEmpty(CONSUMER_SECRET_KEY);
        if (StringUtils.isNotBlank((CharSequence)encryptedValue)) {
            CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)encryptedValue);
            return CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo);
        }
        return "";
    }

    public String getSignatureMethod() {
        return this.getWithEmpty(SIGNATURE_METHOD_KEY);
    }

    public String getToken() {
        return this.getWithEmpty(TOKEN_KEY);
    }

    public String getTokenSecret() throws GeneralSecurityException, IOException {
        String encryptedValue = this.getWithEmpty(TOKEN_SECRET_KEY);
        if (StringUtils.isNotBlank((CharSequence)encryptedValue)) {
            CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)encryptedValue);
            return CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo);
        }
        return "";
    }

    public String getRealm() {
        return this.getWithEmpty(REALM_KEY);
    }

    public void validate() {
    }

    public static boolean is(RequestAuthorization requestAuthorization) {
        String authType;
        if (Objects.nonNull(requestAuthorization) && StringUtils.isNotBlank((CharSequence)(authType = requestAuthorization.getAuthorizationType()))) {
            return authType.toLowerCase().equals(AUTHORIZATION_TYPE.toLowerCase());
        }
        return false;
    }

    public static String encrypt(String vl) throws UnsupportedEncodingException, GeneralSecurityException {
        if (StringUtils.isBlank((CharSequence)vl)) {
            return "";
        }
        CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)vl);
        return CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo);
    }

    private void init(Map<String, String> info) {
        this.setAuthorizationType(AUTHORIZATION_TYPE);
        this.setAuthorizationInfo(info);
    }

    private String getWithEmpty(String key) {
        Map<String, String> dict = this.getAuthorizationInfo();
        if (!dict.containsKey(key)) {
            return "";
        }
        String value = dict.get(key);
        return StringUtils.isBlank((CharSequence)value) ? "" : value;
    }
}

