/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject.impl;

import com.kms.katalon.core.testobject.HttpBodyContent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import org.apache.commons.lang.StringUtils;

public class HttpTextBodyContent
implements HttpBodyContent {
    private static final String DF_CHARSET = "UTF-8";
    private static final String DF_CONTENT_TYPE = "text/plain";
    private final String text;
    private final String charset;
    private final String contentType;
    private final byte[] bytes;

    public HttpTextBodyContent(String text) {
        this(text, DF_CHARSET, DF_CONTENT_TYPE);
    }

    public HttpTextBodyContent(String text, String charset) {
        this(text, charset, DF_CONTENT_TYPE);
    }

    public HttpTextBodyContent(String text, String charset, String contentType) {
        this.text = text;
        this.charset = charset;
        this.contentType = contentType;
        if (StringUtils.isNotEmpty((String)text)) {
            Charset charsetObject;
            try {
                charsetObject = Charset.forName(StringUtils.defaultString((String)charset, (String)DF_CHARSET));
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                charsetObject = Charset.forName(DF_CHARSET);
            }
            this.bytes = text.getBytes(charsetObject);
        } else {
            this.bytes = new byte[0];
        }
    }

    @Override
    public String getContentType() {
        if (StringUtils.isEmpty((String)this.contentType)) {
            return DF_CONTENT_TYPE;
        }
        return this.contentType;
    }

    @Override
    public long getContentLength() {
        return this.bytes.length;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException, UnsupportedOperationException {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        outstream.write(this.bytes);
        outstream.flush();
    }

    public String getText() {
        return this.text;
    }

    public String getCharset() {
        return this.charset;
    }
}

