/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.helper.LogRecordHelper;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import org.apache.commons.lang3.StringUtils;

public class VideoRecorderUtil {
    private static final String FFMPEG_COMMAND_PATTERN = "  \t\tffmpeg -i \"{0}\" -c:v {1} -crf {2,number,#} -pix_fmt yuv420p -b:v 0 \"{3}\"\n";
    public static final String SCREEN_RECORDING_NAME_PATTERN_TEST_CASE_NAME = "%s_%d_%d";
    public static final String SCREEN_RECORDING_NAME_PATTERN_SUFFIX = "_%d_%d";
    public static final String SCREEN_RECORDING_NAME_PATTERN_TEST_CASE_NAME_WITH_VAR_BINDING = "%s_%s_%d_%d";
    public static final String SCREEN_RECORDING_NAME_PATTERN_WITH_VAR_BINDING_SUFFIX = "_%s_%d_%d";
    public static final String TC_NAME_BLACKLIST_PATTERN = "[\\x00-\\x1F\\x7F\\?\\[\\]\\\\=/+<>;:\"',|#*\\.]";
    public static final int MAX_TEST_CASE_NAME_LENGTH_DTT = 20;
    public static final int MAX_ITERATION_NAME_LENGTH_DTT = 10;
    public static final int FIX_FILE_NAME_LENGTH = 25;
    public static final int MAX_OS_FILE_PATH_LENGTH = 255;

    public static String getScreenRecordingNameSuffix(int index, int retryIndex) {
        return String.format(SCREEN_RECORDING_NAME_PATTERN_SUFFIX, index, retryIndex);
    }

    public static String getScreenRecordingNameWithFormat(ILogRecord logRecord, int tcMaxLength) {
        String iterationVariableValue = ((TestCaseLogRecord)logRecord).getIterationVariableValue();
        iterationVariableValue = VideoRecorderUtil.cleanIterationName(iterationVariableValue);
        Object testCaseName = logRecord.getName();
        int index = LogRecordHelper.getLogRecordIndex(logRecord);
        int retryIdx = LogRecordHelper.getRetyCount(logRecord);
        testCaseName = VideoRecorderUtil.cleanTestCaseName((String)testCaseName);
        if (StringUtils.isNotEmpty((CharSequence)iterationVariableValue)) {
            testCaseName = (String)testCaseName + "_" + iterationVariableValue;
        }
        testCaseName = VideoRecorderUtil.formatTestCaseName((String)testCaseName, tcMaxLength);
        return String.format(SCREEN_RECORDING_NAME_PATTERN_TEST_CASE_NAME, testCaseName, index + 1, retryIdx);
    }

    public static String getScreenRecordingNameWithFormat(InternalTestCaseContext tcContext, int tcMaxLength) {
        String iterationVariableValue = tcContext.getIterationVariableValue();
        iterationVariableValue = VideoRecorderUtil.cleanIterationName(iterationVariableValue);
        Object testCaseName = VideoRecorderUtil.getTestCaseNameFromFullPath(tcContext.getTestCaseName());
        int index = tcContext.getTestCaseIndex();
        int retryIdx = tcContext.getRetryIndex();
        testCaseName = VideoRecorderUtil.cleanTestCaseName((String)testCaseName);
        if (StringUtils.isNotEmpty((CharSequence)iterationVariableValue)) {
            testCaseName = (String)testCaseName + "_" + iterationVariableValue;
        }
        testCaseName = VideoRecorderUtil.formatTestCaseName((String)testCaseName, tcMaxLength);
        return String.format(SCREEN_RECORDING_NAME_PATTERN_TEST_CASE_NAME, testCaseName, index + 1, retryIdx);
    }

    private static String cleanIterationName(String iterName) {
        if (StringUtils.isEmpty((CharSequence)iterName)) {
            return "";
        }
        return iterName.replaceAll(TC_NAME_BLACKLIST_PATTERN, "-");
    }

    public static String getTestCaseNameFromFullPath(String path) {
        if (path == null || StringUtils.isEmpty((CharSequence)path)) {
            return "_";
        }
        path = path.trim();
        String[] paths = path.split("/");
        assert (paths.length > 0) : "arr must has at least one element";
        return paths[paths.length - 1];
    }

    @Deprecated
    public static String cleanTestCaseName(String input) {
        if (input == null || StringUtils.isEmpty((CharSequence)input)) {
            return "_";
        }
        return input.replaceAll(TC_NAME_BLACKLIST_PATTERN, "-");
    }

    @Deprecated
    public static String formatTestCaseName(String tc, int maxLength) {
        int numChars = tc.length();
        if (numChars <= maxLength) {
            return tc;
        }
        tc.length();
        int numRemove = numChars - maxLength + 3;
        int half = (numChars - numRemove) / 2;
        String leftPart = tc.substring(0, half);
        String rightPart = tc.substring(half + numRemove, numChars);
        String res = leftPart + "..." + rightPart;
        return res;
    }
}

