/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util.internal;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

public class KeywordLoader {
    public static List<Class<?>> loadAllClass(String ... packageNames) {
        ArrayList cls = new ArrayList();
        String[] stringArray = packageNames;
        int n = packageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String packageName = stringArray[n2];
            cls.addAll(KeywordLoader.getAllClassInPackage(packageName));
            ++n2;
        }
        return cls;
    }

    public static List<Class<?>> loadAllClass(Class<?> aClass) {
        return KeywordLoader.getAllClassInPackage(aClass.getPackage().getName());
    }

    private static List<Class<?>> getAllClassInPackage(String packageName) {
        try {
            ArrayList classes = new ArrayList();
            ClassLoader cld = KeywordLoader.class.getClassLoader();
            Enumeration<URL> urls = cld.getResources(packageName.replace('.', '/'));
            while (urls.hasMoreElements()) {
                File f;
                URL url = urls.nextElement();
                if (url.getProtocol().contains("jar")) {
                    String file = url.getFile();
                    file = file.substring(5, file.indexOf("!"));
                    return KeywordLoader.getAllClassInPackageJar(file, packageName);
                }
                String path = URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8.name());
                if (path.startsWith("/") && path.contains(":")) {
                    path = path.substring(1);
                }
                if (!(f = new File(path)).isDirectory()) continue;
                String[] stringArray = f.list();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    if (fileName.endsWith(".class")) {
                        classes.add(cld.loadClass((packageName + "." + fileName).replaceAll("\\.class", "")));
                    }
                    ++n2;
                }
            }
            return classes;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    private static List<Class<?>> getAllClassInPackageJar(String jarFile, String packageName) throws Exception {
        try (ZipFile jar = null;){
            jar = new JarFile(URLDecoder.decode(jarFile, StandardCharsets.UTF_8.name()));
            ClassLoader cld = KeywordLoader.class.getClassLoader();
            Pattern pat = Pattern.compile(packageName.replace('.', '/') + "/[^/]+");
            ArrayList classes = new ArrayList();
            Enumeration<JarEntry> entries = ((JarFile)jar).entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!pat.matcher(name).matches()) continue;
                classes.add(cld.loadClass(name.replace('/', '.').replaceAll("\\.class", "")));
            }
            ArrayList arrayList = classes;
            return arrayList;
        }
    }

    public static List<Class<?>> listClasses(String ... packages) {
        try {
            return KeywordLoader.loadAllClass(packages);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }
}

