/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testcloud.driver;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.core.driver.IDriverType;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import com.kms.katalon.testcloud.core.model.TestCloudDesktopBrowser;
import com.kms.katalon.testcloud.core.model.TestCloudEntity;
import com.kms.katalon.testcloud.core.model.TestCloudMobilePlatformName;
import com.kms.katalon.testcloud.core.model.TestCloudSessionType;
import com.kms.katalon.util.CryptoUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

public class TestCloudDriverConnector
extends RemoteWebDriverConnector {
    private TestCloudEntity testCloudEntity;
    private TestCloudSessionType testCloudSessionType;

    public TestCloudDriverConnector(String configurationFolderPath) throws IOException {
        super(configurationFolderPath);
        this.remoteWebDriverConnectorType = RemoteWebDriverConnector.RemoteWebDriverConnectorType.Selenium;
    }

    public IDriverType getDriverType() {
        return WebUIDriverType.TESTCLOUD_DRIVER;
    }

    public Map<String, Object> getSystemProperties() {
        Map systemProperties = super.getSystemProperties();
        if (Objects.nonNull(this.testCloudEntity)) {
            systemProperties.putAll(this.testCloudEntity.getSystemPropertiesMap());
        }
        try {
            String remoteServerUrl = this.getRemoteServerUrl();
            if (remoteServerUrl == null) {
                remoteServerUrl = "";
            }
            remoteServerUrl = CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)remoteServerUrl));
            systemProperties.put("remoteWebDriverUrl", remoteServerUrl);
            systemProperties.put("isEncrypted", true);
        }
        catch (UnsupportedEncodingException | GeneralSecurityException exception) {}
        return systemProperties;
    }

    protected void loadDriverProperties() throws IOException {
        if (this.propertyConfigFile.exists()) {
            Map allProperties = this.getAllDriverProperties();
            if (allProperties.get(this.getDriverType().getName()) == null) {
                this.driverProperties = new LinkedHashMap();
                return;
            }
            this.driverProperties = (Map)allProperties.get(this.getDriverType().getName());
        } else {
            this.driverProperties = new LinkedHashMap();
        }
    }

    public void exportConfigProperties(String exportFilePath) throws IOException {
        super.exportConfigProperties(exportFilePath);
        File exportFile = new File(exportFilePath);
        Gson gsonObj = new GsonBuilder().setPrettyPrinting().create();
        String strJson = gsonObj.toJson((Object)this.getUserConfigProperties());
        FileUtils.writeStringToFile((File)exportFile, (String)strJson);
    }

    public TestCloudEntity getTestCloudEntity() {
        return this.testCloudEntity;
    }

    public void setTestCloudEntity(TestCloudEntity testCloudEntity) {
        this.testCloudEntity = testCloudEntity;
        if (!(testCloudEntity instanceof TestCloudDesktopBrowser)) {
            if (testCloudEntity.getPlatformName().equals((Object)TestCloudMobilePlatformName.ANDROID)) {
                this.setMobileDriverType(MobileDriverType.ANDROID_DRIVER);
            } else {
                this.setMobileDriverType(MobileDriverType.IOS_DRIVER);
            }
        }
    }

    public TestCloudSessionType getTestCloudSessionType() {
        return this.testCloudSessionType;
    }

    public void setTestCloudSessionType(TestCloudSessionType testCloudSessionType) {
        this.testCloudSessionType = testCloudSessionType;
    }

    public Map<String, Object> importConfigProperties(String importFilePath, boolean isOverridingExistingProperties) throws Exception {
        boolean shouldOverride;
        Map importProperties = this.parseConfigPropertiesFromJSONFile(importFilePath);
        HashMap<String, Object> currentProperties = new HashMap<String, Object>(this.getUserConfigProperties());
        boolean bl = shouldOverride = isOverridingExistingProperties || currentProperties.isEmpty();
        if (shouldOverride) {
            this.driverProperties = importProperties;
            return importProperties;
        }
        if (importProperties == null) {
            return currentProperties;
        }
        currentProperties.forEach((key, value) -> importProperties.putIfAbsent(key, value));
        this.driverProperties = importProperties;
        return this.driverProperties;
    }

    public void saveUserConfigProperties() throws IOException {
        if (!this.propertyConfigFile.exists()) {
            this.propertyConfigFile.createNewFile();
        }
        Map driverPropertiesMap = this.getAllDriverProperties();
        driverPropertiesMap.put(this.getDriverType().getName(), this.driverProperties);
        Gson gsonObj = new Gson();
        String strJson = gsonObj.toJson((Object)driverPropertiesMap);
        FileUtils.writeStringToFile((File)this.propertyConfigFile, (String)strJson, (Charset)Charset.defaultCharset());
    }
}

