/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.dialog;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.project.constants.StringConstants;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ProjectTrustDialog
extends AbstractDialog {
    private String projectPath;
    private Button trustParentFolderCheckbox;
    private boolean trustParentFolder = false;
    public static final int CLOSE_PROJECT_ID = 0;
    public static final int OPEN_PROJECT_ID = 1;
    private static final String DIALOG_TITLE = StringConstants.PROJECT_TRUST_DIALOG_TITLE;
    private static final String DIALOG_MESSAGE = StringConstants.PROJECT_TRUST_DIALOG_MESSAGE;
    private static final String PROJECT_PATH_LABEL = StringConstants.PROJECT_TRUST_DIALOG_PROJECT_PATH_LABEL;
    private static final String TRUST_PARENT_FOLDER_LABEL = StringConstants.PROJECT_TRUST_DIALOG_TRUST_PARENT_FOLDER;
    private static final String DONT_TRUST_BUTTON = StringConstants.PROJECT_TRUST_DIALOG_DONT_TRUST_BUTTON;
    private static final String TRUST_PROJECT_BUTTON = StringConstants.PROJECT_TRUST_DIALOG_TRUST_PROJECT_BUTTON;

    public ProjectTrustDialog(Shell parentShell, String projectPath) {
        super(parentShell);
        this.projectPath = projectPath;
        this.setDialogTitle(DIALOG_TITLE);
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1, (int)0).marginVertical(5).marginHorizontal(10).gridSpacing(10, 0).fillHorizontal().build();
        ComponentBuilder.label((Composite)container, (int)64).text(DIALOG_MESSAGE).fillHorizontal().width(600).top().noFillVertical().build();
        ComponentBuilder.label((Composite)container, (int)64).text(PROJECT_PATH_LABEL).build();
        ComponentBuilder.text((Composite)container, (int)8).text(this.projectPath).background(ColorUtil.WHITE_COLOR).border(2048).build();
        this.trustParentFolderCheckbox = (Button)ComponentBuilder.checkBox((Composite)container, (int)64).text(MessageFormat.format(TRUST_PARENT_FOLDER_LABEL, this.getParentFolderName(this.projectPath))).fillHorizontal().build();
        return container;
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1, (int)0).marginVertical(0).marginHorizontal(0).noFillVertical().right().build();
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)3, (int)0).marginVertical(5).marginHorizontal(10).gridSpacing(10, 0).fillHorizontal().build();
        ComponentBuilder.label((Composite)container).fillHorizontal().middle().build();
        Composite buttonContainer = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).gridHorizontalSpacing(2).right().build();
        buttonContainer.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        ComponentBuilder.from((Widget)this.createButton(buttonContainer, 0, DONT_TRUST_BUTTON, false)).secondaryButton().build();
        Button openButton = this.createButton(buttonContainer, 1, TRUST_PROJECT_BUTTON, true);
        ComponentBuilder.from((Widget)openButton).marginLeft(5).primaryButton().build();
    }

    protected void registerControlModifyListeners() {
        if (this.trustParentFolderCheckbox != null) {
            this.trustParentFolderCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProjectTrustDialog.this.trustParentFolder = ProjectTrustDialog.this.trustParentFolderCheckbox.getSelection();
                }
            });
        }
    }

    protected void setInput() {
    }

    private String getParentFolderName(String path) {
        if (path == null || path.trim().isEmpty()) {
            return "";
        }
        try {
            File file = new File(path);
            File parent = file.getParentFile();
            return parent != null ? parent.getName() : "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean isTrustParentFolder() {
        return this.trustParentFolder;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void handleShellCloseEvent() {
        this.setReturnCode(0);
        this.close();
    }
}

