/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.project.sample.service;

import com.kms.katalon.composer.project.sample.CloneSampleProjectRequest;
import com.kms.katalon.composer.project.sample.service.ICloneSampleProjectManager;
import com.kms.katalon.composer.project.template.SampleProjectProvider;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteCloneWithLocalFallbackManager
implements ICloneSampleProjectManager {
    private static final Logger logger = LoggerFactory.getLogger(RemoteCloneWithLocalFallbackManager.class);
    private final CloneSampleProjectRequest cloneSampleProjectRequest;
    private final SampleProjectProvider projectProvider;
    private final AtomicInteger attemptCount = new AtomicInteger(0);
    private final AtomicBoolean isCompleted = new AtomicBoolean(false);
    private final AtomicBoolean isProcessingFailure = new AtomicBoolean(false);
    private final int maxCloneRetries;
    private final int retryDelayMs;

    public RemoteCloneWithLocalFallbackManager(CloneSampleProjectRequest request, SampleProjectProvider projectProvider, int maxCloneRetries, int retryDelayMs) {
        this.cloneSampleProjectRequest = request;
        this.projectProvider = projectProvider;
        this.maxCloneRetries = maxCloneRetries;
        this.retryDelayMs = retryDelayMs;
    }

    @Override
    public void startCloneProcess() {
        this.attemptRemoteClone();
    }

    @Override
    public void handleProjectCreated(Event event) {
        ProjectEntity createdProject = (ProjectEntity)event.getProperty("org.eclipse.e4.data");
        if (this.isMatchingProject(createdProject) && this.markAsCompleted()) {
            logger.info("Successfully created remote project: {}", (Object)this.cloneSampleProjectRequest.getProjectName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCloneFailure(Event event) {
        String failedLocation = (String)event.getProperty("org.eclipse.e4.data");
        if (!this.isMatchingLocation(failedLocation)) {
            return;
        }
        RemoteCloneWithLocalFallbackManager remoteCloneWithLocalFallbackManager = this;
        synchronized (remoteCloneWithLocalFallbackManager) {
            if (this.isCompleted.get() || !this.isProcessingFailure.compareAndSet(false, true)) {
                return;
            }
        }
        Display.getDefault().asyncExec(() -> {
            try {
                RemoteCloneWithLocalFallbackManager remoteCloneWithLocalFallbackManager = this;
                synchronized (remoteCloneWithLocalFallbackManager) {
                    if (!this.isCompleted.get()) {
                        this.processCloneFailure();
                    }
                }
            }
            catch (Throwable throwable) {
                RemoteCloneWithLocalFallbackManager remoteCloneWithLocalFallbackManager = this;
                synchronized (remoteCloneWithLocalFallbackManager) {
                    this.isProcessingFailure.set(false);
                }
                throw throwable;
            }
            RemoteCloneWithLocalFallbackManager remoteCloneWithLocalFallbackManager = this;
            synchronized (remoteCloneWithLocalFallbackManager) {
                this.isProcessingFailure.set(false);
            }
        });
    }

    private void attemptRemoteClone() {
        this.isProcessingFailure.set(false);
        if (this.isCompleted.get()) {
            return;
        }
        this.attemptCount.incrementAndGet();
        try {
            this.projectProvider.performRemoteClone(this.cloneSampleProjectRequest);
        }
        catch (Exception e) {
            logger.warn("Failed to initiate remote clone: {}", (Object)e.getMessage());
        }
    }

    private void processCloneFailure() {
        int currentAttempt = this.attemptCount.get();
        if (currentAttempt < this.maxCloneRetries) {
            this.cleanupFailedClone();
            Display.getDefault().timerExec(this.retryDelayMs, this::attemptRemoteClone);
        } else {
            this.fallbackToLocalProject();
        }
    }

    private void fallbackToLocalProject() {
        if (!this.markAsCompleted()) {
            return;
        }
        logger.debug("All clone attempts failed, falling back to local project");
        new Thread(this::performLocalFallback).start();
    }

    private void performLocalFallback() {
        try {
            this.cleanupFailedClone();
            this.projectProvider.performLocalClone(this.cloneSampleProjectRequest);
        }
        catch (Exception e) {
            logger.error("Failed to create local fallback project: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void cleanupFailedClone() {
        try {
            File projectDir = new File(this.cloneSampleProjectRequest.getProjectLocation());
            if (projectDir.exists()) {
                FileUtils.deleteDirectory((File)projectDir);
            }
        }
        catch (Exception e) {
            logger.error("Failed to cleanup failed clone directory", (Throwable)e);
        }
    }

    private boolean isMatchingProject(ProjectEntity project) {
        return project != null && project.getFolderLocation().equals(this.cloneSampleProjectRequest.getProjectLocation());
    }

    private boolean isMatchingLocation(String location) {
        return this.cloneSampleProjectRequest.getProjectLocation().equals(location);
    }

    private boolean markAsCompleted() {
        return this.isCompleted.compareAndSet(false, true);
    }
}

